/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.resource.java.MutableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableImpl
extends AbstractResourceAnnotation<Attribute>
implements MutableAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Mutable");
    private final AnnotationElementAdapter<Boolean> valueAdapter;
    private static final DeclarationAnnotationElementAdapter<Boolean> VALUE_ADAPTER = MutableImpl.buildValueAdapter();
    private Boolean value;

    protected MutableImpl(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super((JavaResourceNode)parent, (Member)attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, VALUE_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.value(astRoot);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Mutable";
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Boolean newValue) {
        if (this.attributeValueHasNotChanged(this.value, newValue)) {
            return;
        }
        Boolean oldValue = this.value;
        this.value = newValue;
        this.valueAdapter.setValue((Object)newValue);
        this.firePropertyChanged("valueProperty", oldValue, newValue);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setValue(this.value(astRoot));
    }

    protected Boolean value(CompilationUnit astRoot) {
        return (Boolean)this.valueAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", false, BooleanExpressionConverter.instance());
    }

    public static class MutableAnnotationDefinition
    implements AnnotationDefinition {
        private static final MutableAnnotationDefinition INSTANCE = new MutableAnnotationDefinition();

        public static MutableAnnotationDefinition instance() {
            return INSTANCE;
        }

        private MutableAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new MutableImpl((JavaResourcePersistentAttribute)parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.Mutable";
        }
    }
}

