/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.JpaDataSource;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.ResourceModelListener;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.internal.AbstractJpaNode;
import org.eclipse.jpt.core.internal.SynchronousJpaProjectUpdater;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.utility.CommandExecutor;
import org.eclipse.jpt.utility.CommandExecutorProvider;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaProject
extends AbstractJpaNode
implements JpaProject {
    protected final IProject project;
    protected final JpaPlatform jpaPlatform;
    protected final JpaDataSource dataSource;
    protected String userOverrideDefaultCatalog;
    protected String userOverrideDefaultSchema;
    protected boolean discoversAnnotatedClasses;
    protected final Vector<JpaFile> jpaFiles;
    protected JpaRootContextNode rootContextNode;
    protected final ThreadLocal<CommandExecutor> threadLocalModifySharedDocumentCommandExecutor;
    protected final CommandExecutorProvider modifySharedDocumentCommandExecutorProvider;
    protected JpaProject.Updater updater;
    protected ResourceModelListener resourceModelListener;
    protected static final String WEB_PROJECT_ROOT_DEPLOY_LOCATION = "WEB-INF/classes";
    protected static final String JST_WEB_MODULE = "jst.web";

    public GenericJpaProject(JpaProject.Config config) throws CoreException {
        super(null);
        if (config.getProject() == null || config.getJpaPlatform() == null) {
            throw new NullPointerException();
        }
        this.project = config.getProject();
        this.jpaPlatform = config.getJpaPlatform();
        this.dataSource = this.getJpaFactory().buildJpaDataSource(this, config.getConnectionProfileName());
        this.userOverrideDefaultCatalog = config.getUserOverrideDefaultCatalog();
        this.userOverrideDefaultSchema = config.getUserOverrideDefaultSchema();
        this.discoversAnnotatedClasses = config.discoverAnnotatedClasses();
        this.jpaFiles = this.buildEmptyJpaFiles();
        this.threadLocalModifySharedDocumentCommandExecutor = this.buildThreadLocalModifySharedDocumentCommandExecutor();
        this.modifySharedDocumentCommandExecutorProvider = this.buildModifySharedDocumentCommandExecutorProvider();
        this.resourceModelListener = this.buildResourceModelListener();
        this.project.accept(this.buildInitialResourceProxyVisitor(), 0);
        this.rootContextNode = this.buildRootContextNode();
        this.setUpdater_(new SynchronousJpaProjectUpdater(this));
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    protected Vector<JpaFile> buildEmptyJpaFiles() {
        return new Vector<JpaFile>();
    }

    protected ResourceDeltaVisitor buildResourceDeltaVisitor() {
        return new ResourceDeltaVisitor();
    }

    protected ThreadLocal<CommandExecutor> buildThreadLocalModifySharedDocumentCommandExecutor() {
        return new ThreadLocal<CommandExecutor>();
    }

    protected CommandExecutorProvider buildModifySharedDocumentCommandExecutorProvider() {
        return new ModifySharedDocumentCommandExecutorProvider();
    }

    protected ResourceModelListener buildResourceModelListener() {
        return new DefaultResourceModelListener();
    }

    protected IResourceProxyVisitor buildInitialResourceProxyVisitor() {
        return new InitialResourceProxyVisitor();
    }

    protected JpaRootContextNode buildRootContextNode() {
        return this.getJpaFactory().buildRootContextNode(this);
    }

    @Override
    public JpaProject getJpaProject() {
        return this;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    @Override
    public JpaPlatform getJpaPlatform() {
        return this.jpaPlatform;
    }

    @Override
    public JpaDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.dataSource.getConnectionProfile();
    }

    @Override
    public Catalog getDefaultDbCatalog() {
        String catalog = this.getDefaultCatalog();
        return catalog == null ? null : this.getDbCatalog(catalog);
    }

    @Override
    public String getDefaultCatalog() {
        String catalog = this.getUserOverrideDefaultCatalog();
        return catalog != null ? catalog : this.getDatabaseDefaultCatalog();
    }

    protected String getDatabaseDefaultCatalog() {
        Catalog dbCatalog = this.getDatabaseDefaultDbCatalog();
        return dbCatalog == null ? null : dbCatalog.getIdentifier();
    }

    protected Catalog getDatabaseDefaultDbCatalog() {
        Database db = this.getDatabase();
        return db == null ? null : db.getDefaultCatalog();
    }

    @Override
    public SchemaContainer getDefaultDbSchemaContainer() {
        String catalog = this.getDefaultCatalog();
        return catalog != null ? this.getDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Schema getDefaultDbSchema() {
        SchemaContainer sc = this.getDefaultDbSchemaContainer();
        return sc == null ? null : sc.getSchemaForIdentifier(this.getDefaultSchema());
    }

    @Override
    public String getDefaultSchema() {
        Schema dbSchema;
        Catalog dbCatalog;
        String schema = this.getUserOverrideDefaultSchema();
        if (schema != null) {
            return schema;
        }
        String catalog = this.getDefaultCatalog();
        if (catalog != null && (dbCatalog = this.getDbCatalog(catalog)) != null && (dbSchema = dbCatalog.getDefaultSchema()) != null) {
            return dbSchema.getIdentifier();
        }
        return this.getDatabaseDefaultSchema();
    }

    protected String getDatabaseDefaultSchema() {
        Schema schema = this.getDatabaseDefaultDbSchema();
        return schema == null ? null : schema.getIdentifier();
    }

    protected Schema getDatabaseDefaultDbSchema() {
        Database db = this.getDatabase();
        return db == null ? null : db.getDefaultSchema();
    }

    @Override
    public String getUserOverrideDefaultCatalog() {
        return this.userOverrideDefaultCatalog;
    }

    @Override
    public void setUserOverrideDefaultCatalog(String catalog) {
        String old = this.userOverrideDefaultCatalog;
        this.userOverrideDefaultCatalog = catalog;
        this.firePropertyChanged("userOverrideDefaultCatalog", old, catalog);
    }

    @Override
    public String getUserOverrideDefaultSchema() {
        return this.userOverrideDefaultSchema;
    }

    @Override
    public void setUserOverrideDefaultSchema(String schema) {
        String old = this.userOverrideDefaultSchema;
        this.userOverrideDefaultSchema = schema;
        this.firePropertyChanged("userOverrideDefaultSchema", old, schema);
    }

    @Override
    public boolean discoversAnnotatedClasses() {
        return this.discoversAnnotatedClasses;
    }

    @Override
    public void setDiscoversAnnotatedClasses(boolean discoversAnnotatedClasses) {
        boolean old = this.discoversAnnotatedClasses;
        this.discoversAnnotatedClasses = discoversAnnotatedClasses;
        this.firePropertyChanged("discoversAnnotatedClasses", old, discoversAnnotatedClasses);
    }

    @Override
    public Iterator<JpaFile> jpaFiles() {
        return new CloneIterator(this.jpaFiles);
    }

    @Override
    public int jpaFilesSize() {
        return this.jpaFiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JpaFile getJpaFile(IFile file) {
        Vector<JpaFile> vector = this.jpaFiles;
        synchronized (vector) {
            for (JpaFile jpaFile : this.jpaFiles) {
                if (!jpaFile.getFile().equals((Object)file)) continue;
                return jpaFile;
            }
        }
        return null;
    }

    protected boolean addJpaFile(IFile file) {
        JpaFile jpaFile = this.addJpaFile_(file);
        if (jpaFile != null) {
            this.fireItemAdded("jpaFiles", jpaFile);
            return true;
        }
        return false;
    }

    protected JpaFile addJpaFile_(IFile file) {
        if (!this.getJavaProject().isOnClasspath((IResource)file)) {
            return null;
        }
        JpaFile jpaFile = this.getJpaPlatform().buildJpaFile(this, file);
        if (jpaFile == null) {
            return null;
        }
        jpaFile.addResourceModelListener(this.resourceModelListener);
        this.jpaFiles.add(jpaFile);
        return jpaFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeJpaFile(IFile file) {
        Vector<JpaFile> vector = this.jpaFiles;
        synchronized (vector) {
            block4: {
                JpaFile jpaFile = this.getJpaFile(file);
                if (jpaFile == null) break block4;
                this.removeJpaFile(jpaFile);
                return true;
            }
            return false;
        }
    }

    protected void removeJpaFile(JpaFile jpaFile) {
        jpaFile.removeResourceModelListener(this.resourceModelListener);
        if (!this.removeItemFromCollection(jpaFile, this.jpaFiles, "jpaFiles")) {
            throw new IllegalArgumentException(jpaFile.toString());
        }
    }

    protected boolean containsJpaFile(IFile file) {
        return this.getJpaFile(file) != null;
    }

    @Override
    public JpaRootContextNode getRootContextNode() {
        return this.rootContextNode;
    }

    @Override
    public Iterator<String> annotatedClassNames() {
        return new TransformationIterator<JavaResourcePersistentType, String>(this.persistedJavaResourcePersistentTypes()){

            protected String transform(JavaResourcePersistentType jrpt) {
                return jrpt.getQualifiedName();
            }
        };
    }

    protected Iterator<JavaResourcePersistentType> persistedJavaResourcePersistentTypes() {
        return new FilteringIterator<JavaResourcePersistentType, JavaResourcePersistentType>(this.persistableJavaResourcePersistentTypes()){

            protected boolean accept(JavaResourcePersistentType jrpt) {
                return jrpt.isPersisted();
            }
        };
    }

    protected Iterator<JavaResourcePersistentType> persistableJavaResourcePersistentTypes() {
        return new CompositeIterator(this.persistableJavaResourcePersistentTypeIterators());
    }

    protected Iterator<Iterator<JavaResourcePersistentType>> persistableJavaResourcePersistentTypeIterators() {
        return new TransformationIterator<JpaFile, Iterator<JavaResourcePersistentType>>(this.jpaFiles()){

            protected Iterator<JavaResourcePersistentType> transform(JpaFile jpaFile) {
                return jpaFile.persistableTypes();
            }
        };
    }

    @Override
    public JavaResourcePersistentType getJavaResourcePersistentType(String typeName) {
        Iterator<JavaResourcePersistentType> stream = this.persistableJavaResourcePersistentTypes();
        while (stream.hasNext()) {
            JavaResourcePersistentType pt = stream.next();
            if (!pt.getQualifiedName().equals(typeName)) continue;
            return pt;
        }
        return null;
    }

    @Override
    public void javaElementChanged(ElementChangedEvent event) {
        Iterator<JpaFile> stream = this.jpaFiles();
        while (stream.hasNext()) {
            stream.next().javaElementChanged(event);
        }
    }

    @Override
    public Iterator<IMessage> validationMessages() {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        this.validate(messages);
        return messages.iterator();
    }

    protected void validate(List<IMessage> messages) {
        this.validateConnection(messages);
        this.rootContextNode.validate(messages);
    }

    protected void validateConnection(List<IMessage> messages) {
        String cpName = this.dataSource.getConnectionProfileName();
        if (StringTools.stringIsEmpty((String)cpName)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_NO_CONNECTION", this));
            return;
        }
        ConnectionProfile cp = this.dataSource.getConnectionProfile();
        if (cp == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_INVALID_CONNECTION", new String[]{cpName}, this));
            return;
        }
        if (cp.isInactive()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_INACTIVE_CONNECTION", new String[]{cpName}, this));
        }
    }

    @Override
    public String getRootDeployLocation() {
        return this.isWebProject() ? WEB_PROJECT_ROOT_DEPLOY_LOCATION : "";
    }

    protected boolean isWebProject() {
        return JptCorePlugin.projectHasWebFacet(this.project);
    }

    @Override
    public void dispose() {
        this.updater.dispose();
        this.dataSource.dispose();
    }

    @Override
    public void synchronizeJpaFiles(IResourceDelta delta) throws CoreException {
        ResourceDeltaVisitor resourceDeltaVisitor = this.buildResourceDeltaVisitor();
        delta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
        if (resourceDeltaVisitor.jpaFilesChanged()) {
            Iterator<JpaFile> stream = this.jpaFiles();
            while (stream.hasNext()) {
                stream.next().jpaFilesChanged();
            }
        }
    }

    protected boolean synchronizeJpaFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.addJpaFile(file);
            }
            case 2: {
                return this.removeJpaFile(file);
            }
        }
        return false;
    }

    protected CommandExecutor getThreadLocalModifySharedDocumentCommandExecutor() {
        CommandExecutor ce = this.threadLocalModifySharedDocumentCommandExecutor.get();
        return ce != null ? ce : CommandExecutor.Default.instance();
    }

    @Override
    public void setThreadLocalModifySharedDocumentCommandExecutor(CommandExecutor commandExecutor) {
        this.threadLocalModifySharedDocumentCommandExecutor.set(commandExecutor);
    }

    @Override
    public CommandExecutorProvider getModifySharedDocumentCommandExecutorProvider() {
        return this.modifySharedDocumentCommandExecutorProvider;
    }

    @Override
    public JpaProject.Updater getUpdater() {
        return this.updater;
    }

    @Override
    public void setUpdater(JpaProject.Updater updater) {
        if (updater == null) {
            throw new NullPointerException();
        }
        this.updater.dispose();
        this.setUpdater_(updater);
    }

    protected void setUpdater_(JpaProject.Updater updater) {
        this.updater = updater;
        this.updater.start();
    }

    @Override
    public void update() {
        this.updater.update();
    }

    @Override
    public IStatus update(IProgressMonitor monitor) {
        try {
            this.rootContextNode.update(monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Throwable ex) {
            JptCorePlugin.log(ex);
        }
        return Status.OK_STATUS;
    }

    protected class DefaultResourceModelListener
    implements ResourceModelListener {
        protected DefaultResourceModelListener() {
        }

        public void resourceModelChanged() {
            GenericJpaProject.this.update();
        }
    }

    protected class InitialResourceProxyVisitor
    implements IResourceProxyVisitor {
        protected InitialResourceProxyVisitor() {
        }

        public boolean visit(IResourceProxy resource) throws CoreException {
            switch (resource.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
                case 1: {
                    GenericJpaProject.this.addJpaFile_((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }
    }

    protected class ModifySharedDocumentCommandExecutorProvider
    implements CommandExecutorProvider {
        protected ModifySharedDocumentCommandExecutorProvider() {
        }

        public CommandExecutor getCommandExecutor() {
            return GenericJpaProject.this.getThreadLocalModifySharedDocumentCommandExecutor();
        }
    }

    protected class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean jpaFilesChanged = false;

        protected ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
                case 1: {
                    if (GenericJpaProject.this.synchronizeJpaFiles((IFile)res, delta.getKind())) {
                        this.jpaFilesChanged = true;
                    }
                    return false;
                }
            }
            return false;
        }

        protected boolean jpaFilesChanged() {
            return this.jpaFilesChanged;
        }
    }
}

