/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.common.AbstractJpaEObject;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTypeMapping<T extends AbstractXmlTypeMapping>
extends AbstractXmlContextNode
implements OrmTypeMapping {
    protected String class_;
    public AccessType defaultAccess;
    protected AccessType specifiedAccess;
    public boolean defaultMetadataComplete;
    protected Boolean specifiedMetadataComplete;
    protected JavaPersistentType javaPersistentType;
    protected T resourceTypeMapping;

    protected AbstractOrmTypeMapping(OrmPersistentType parent) {
        super(parent);
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        AccessType accessType = this.getSpecifiedAccess();
        if (accessType == null && this.getPersistentType().getParentPersistentType() instanceof OrmPersistentType) {
            accessType = ((OrmPersistentType)this.getPersistentType().getParentPersistentType()).getMapping().getSpecifiedAccess();
        }
        if (accessType == null && this.isMetadataComplete() && (accessType = this.getPersistentType().getContext().getDefaultPersistentTypeAccess()) == null) {
            accessType = AccessType.FIELD;
        }
        return accessType;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        AccessType accessType = null;
        if (accessType == null && this.getPersistentType().getParentPersistentType() instanceof OrmPersistentType) {
            accessType = ((OrmPersistentType)this.getPersistentType().getParentPersistentType()).getMapping().getDefaultAccess();
        }
        if (accessType == null) {
            accessType = this.getPersistentType().getContext().getDefaultPersistentTypeAccess();
        }
        return accessType;
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getPrimaryTableName() {
        return null;
    }

    @Override
    public String getClass_() {
        return this.class_;
    }

    @Override
    public void setClass(String newClass) {
        String oldClass = this.class_;
        this.class_ = newClass;
        ((AbstractXmlTypeMapping)this.resourceTypeMapping).setClassName(newClass);
        this.firePropertyChanged("classProperty", oldClass, newClass);
        this.getPersistentType().classChanged(oldClass, newClass);
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType newDefaultAccess) {
        AccessType oldDefaultAccess = this.defaultAccess;
        this.defaultAccess = newDefaultAccess;
        this.firePropertyChanged("defaultAccessProperty", (Object)oldDefaultAccess, (Object)newDefaultAccess);
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType newSpecifiedAccess) {
        AccessType oldSpecifiedAccess = this.specifiedAccess;
        this.specifiedAccess = newSpecifiedAccess;
        ((AbstractXmlTypeMapping)this.resourceTypeMapping).setAccess(AccessType.toXmlResourceModel(newSpecifiedAccess));
        this.firePropertyChanged("specifiedAccessProperty", (Object)oldSpecifiedAccess, (Object)newSpecifiedAccess);
    }

    @Override
    public AccessType getAccess() {
        return this.getSpecifiedAccess() == null ? this.getDefaultAccess() : this.getSpecifiedAccess();
    }

    @Override
    public boolean isMetadataComplete() {
        if (this.isDefaultMetadataComplete()) {
            return true;
        }
        return this.getSpecifiedMetadataComplete() == null ? this.isDefaultMetadataComplete() : this.getSpecifiedMetadataComplete().booleanValue();
    }

    @Override
    public boolean isDefaultMetadataComplete() {
        return this.defaultMetadataComplete;
    }

    protected void setDefaultMetadataComplete(boolean newDefaultMetadataComplete) {
        boolean oldMetadataComplete = this.defaultMetadataComplete;
        this.defaultMetadataComplete = newDefaultMetadataComplete;
        this.firePropertyChanged("defaultMetadataCompleteProperty", oldMetadataComplete, newDefaultMetadataComplete);
    }

    @Override
    public Boolean getSpecifiedMetadataComplete() {
        return this.specifiedMetadataComplete;
    }

    @Override
    public void setSpecifiedMetadataComplete(Boolean newSpecifiedMetadataComplete) {
        Boolean oldMetadataComplete = this.specifiedMetadataComplete;
        this.specifiedMetadataComplete = newSpecifiedMetadataComplete;
        ((AbstractXmlTypeMapping)this.resourceTypeMapping).setMetadataComplete(newSpecifiedMetadataComplete);
        this.firePropertyChanged("specifiedMetadataCompleteProperty", oldMetadataComplete, newSpecifiedMetadataComplete);
    }

    @Override
    public OrmPersistentType getPersistentType() {
        return (OrmPersistentType)this.getParent();
    }

    @Override
    public void initializeFrom(OrmTypeMapping oldMapping) {
        this.setClass(oldMapping.getClass_());
        this.setSpecifiedAccess(oldMapping.getSpecifiedAccess());
        this.setSpecifiedMetadataComplete(oldMapping.getSpecifiedMetadataComplete());
        this.setDefaultAccess(oldMapping.getDefaultAccess());
        this.setDefaultMetadataComplete(oldMapping.isDefaultMetadataComplete());
    }

    @Override
    public Table getPrimaryDbTable() {
        return null;
    }

    @Override
    public Table getDbTable(String tableName) {
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return null;
    }

    @Override
    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return true;
    }

    @Override
    public Iterator<OrmPersistentAttribute> overridableAttributes() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAttributes() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<OrmPersistentAttribute> overridableAssociations() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAssociations() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allOverridableAssociationNames() {
        return EmptyIterator.instance();
    }

    public T getResourceTypeMapping() {
        return this.resourceTypeMapping;
    }

    protected AccessType defaultAccess() {
        if (!this.isMetadataComplete() && this.getJavaPersistentType() != null) {
            if (this.getJavaPersistentType().hasAnyAttributeMappingAnnotations()) {
                return this.getJavaPersistentType().getAccess();
            }
            if (this.getPersistentType().getParentPersistentType() != null) {
                return this.getPersistentType().getParentPersistentType().getAccess();
            }
        }
        return this.getMappingFileRoot().getAccess();
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.javaPersistentType;
    }

    protected void setJavaPersistentType(JavaPersistentType newJavaPersistentType) {
        JavaPersistentType oldJavaPersistentType = this.javaPersistentType;
        this.javaPersistentType = newJavaPersistentType;
        this.firePropertyChanged("javaPersistentTypeProperty", oldJavaPersistentType, newJavaPersistentType);
    }

    protected void initializeJavaPersistentType() {
        JavaResourcePersistentType persistentTypeResource = this.getJavaResourcePersistentType();
        if (persistentTypeResource != null) {
            this.javaPersistentType = this.buildJavaPersistentType(persistentTypeResource);
        }
    }

    protected JavaResourcePersistentType getJavaResourcePersistentType() {
        JavaResourcePersistentType persistentTypeResource = this.getJpaProject().getJavaResourcePersistentType(this.getClass_());
        if (persistentTypeResource == null) {
            String packageName = this.getPersistentType().getContext().getDefaultPersistentTypePackage();
            persistentTypeResource = this.getJpaProject().getJavaResourcePersistentType(String.valueOf(packageName) + '.' + this.getClass_());
        }
        return persistentTypeResource;
    }

    protected void updateJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJavaResourcePersistentType();
        if (jrpt == null) {
            this.setJavaPersistentType(null);
        } else if (this.getJavaPersistentType() != null) {
            this.getJavaPersistentType().update(jrpt);
        } else {
            this.setJavaPersistentType(this.buildJavaPersistentType(jrpt));
        }
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourcePersistentType resourcePersistentType) {
        return this.getJpaFactory().buildJavaPersistentType(this, resourcePersistentType);
    }

    public void initialize(T mapping) {
        this.resourceTypeMapping = mapping;
        this.class_ = ((AbstractXmlTypeMapping)mapping).getClassName();
        this.initializeJavaPersistentType();
        this.specifiedMetadataComplete = this.metadataComplete((AbstractXmlTypeMapping)mapping);
        this.defaultMetadataComplete = this.getPersistentType().getContext().isDefaultPersistentTypeMetadataComplete();
        this.specifiedAccess = AccessType.fromXmlResourceModel(((AbstractXmlTypeMapping)mapping).getAccess());
        this.defaultAccess = this.defaultAccess();
    }

    public void update(T mapping) {
        this.resourceTypeMapping = mapping;
        this.setClass(((AbstractXmlTypeMapping)mapping).getClassName());
        this.updateJavaPersistentType();
        this.setSpecifiedMetadataComplete(this.metadataComplete((AbstractXmlTypeMapping)mapping));
        this.setDefaultMetadataComplete(this.getPersistentType().getContext().isDefaultPersistentTypeMetadataComplete());
        this.setSpecifiedAccess(AccessType.fromXmlResourceModel(((AbstractXmlTypeMapping)mapping).getAccess()));
        this.setDefaultAccess(this.defaultAccess());
    }

    protected Boolean metadataComplete(AbstractXmlTypeMapping mapping) {
        return mapping.getMetadataComplete();
    }

    public JpaStructureNode getStructureNode(int offset) {
        if (((AbstractJpaEObject)this.resourceTypeMapping).containsOffset(offset)) {
            return this.getPersistentType();
        }
        return null;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return ((AbstractJpaEObject)this.resourceTypeMapping).getSelectionTextRange();
    }

    public TextRange getClassTextRange() {
        return ((AbstractXmlTypeMapping)this.resourceTypeMapping).getClassTextRange();
    }

    @Override
    public TextRange getAttributesTextRange() {
        return ((AbstractXmlTypeMapping)this.resourceTypeMapping).getAttributesTextRange();
    }

    @Override
    public boolean containsOffset(int textOffset) {
        if (this.resourceTypeMapping == null) {
            return false;
        }
        return ((AbstractJpaEObject)this.resourceTypeMapping).containsOffset(textOffset);
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        this.validateClass(messages);
    }

    protected void validateClass(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.class_)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNSPECIFIED_CLASS", this, this.getClassTextRange()));
            return;
        }
        if (this.javaPersistentType == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNRESOLVED_CLASS", new String[]{this.class_}, this, this.getClassTextRange()));
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return ((AbstractJpaEObject)this.resourceTypeMapping).getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPersistentType().getName());
    }
}

