/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractNamedColumn;
import org.eclipse.jpt.core.internal.resource.java.NullDiscriminatorColumn;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorType;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscriminatorColumnImpl
extends AbstractNamedColumn
implements DiscriminatorColumnAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.DiscriminatorColumn");
    private static final DeclarationAnnotationElementAdapter<String> DISCRIMINATOR_TYPE_ADAPTER = DiscriminatorColumnImpl.buildDiscriminatorTypeAdapter();
    private final DeclarationAnnotationElementAdapter<Integer> lengthDeclarationAdapter;
    private final AnnotationElementAdapter<String> discriminatorTypeAdapter;
    private final AnnotationElementAdapter<Integer> lengthAdapter;
    private DiscriminatorType discriminatorType;
    private Integer length;

    protected DiscriminatorColumnImpl(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        super(parent, member, daa, (AnnotationAdapter)new MemberAnnotationAdapter(member, daa));
        this.discriminatorTypeAdapter = new ShortCircuitAnnotationElementAdapter<String>(member, DISCRIMINATOR_TYPE_ADAPTER);
        this.lengthDeclarationAdapter = this.buildIntegerElementAdapter("length");
        this.lengthAdapter = this.buildShortCircuitIntegerElementAdapter(this.lengthDeclarationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.discriminatorType = this.discriminatorType(astRoot);
        this.length = this.length(astRoot);
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    protected String getColumnDefinitionElementName() {
        return "columnDefinition";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.DiscriminatorColumn";
    }

    public void moveAnnotation(int newIndex) {
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        DiscriminatorColumnAnnotation oldColumn = (DiscriminatorColumnAnnotation)((Object)oldAnnotation);
        this.setLength(oldColumn.getLength());
        this.setDiscriminatorType(oldColumn.getDiscriminatorType());
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public void setDiscriminatorType(DiscriminatorType newDiscriminatorType) {
        if (this.attributeValueHasNotChanged((Object)this.discriminatorType, (Object)newDiscriminatorType)) {
            return;
        }
        DiscriminatorType oldDiscriminatorType = this.discriminatorType;
        this.discriminatorType = newDiscriminatorType;
        this.discriminatorTypeAdapter.setValue(DiscriminatorType.toJavaAnnotationValue(newDiscriminatorType));
        this.firePropertyChanged("discriminatorTypeProperty", (Object)oldDiscriminatorType, (Object)newDiscriminatorType);
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer newLength) {
        if (this.attributeValueHasNotChanged(this.length, newLength)) {
            return;
        }
        Integer oldLength = this.length;
        this.length = newLength;
        this.lengthAdapter.setValue(newLength);
        this.firePropertyChanged("lengthProperty", oldLength, newLength);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setLength(this.length(astRoot));
        this.setDiscriminatorType(this.discriminatorType(astRoot));
    }

    protected Integer length(CompilationUnit astRoot) {
        return this.lengthAdapter.getValue(astRoot);
    }

    protected DiscriminatorType discriminatorType(CompilationUnit astRoot) {
        return DiscriminatorType.fromJavaAnnotationValue(this.discriminatorTypeAdapter.getValue(astRoot));
    }

    private static DeclarationAnnotationElementAdapter<String> buildDiscriminatorTypeAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "discriminatorType");
    }

    public static class DiscriminatorColumnAnnotationDefinition
    implements AnnotationDefinition {
        private static final DiscriminatorColumnAnnotationDefinition INSTANCE = new DiscriminatorColumnAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private DiscriminatorColumnAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new DiscriminatorColumnImpl((JavaResourceNode)parent, member, DECLARATION_ANNOTATION_ADAPTER);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new NullDiscriminatorColumn(parent);
        }

        public String getAnnotationName() {
            return "javax.persistence.DiscriminatorColumn";
        }
    }
}

