/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdClassImpl
extends AbstractResourceAnnotation<Type>
implements IdClassAnnotation {
    private final AnnotationElementAdapter<String> valueAdapter;
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.IdClass");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = IdClassImpl.buildValueAdapter();
    private String value;
    private String fullyQualifiedValue;

    public IdClassImpl(JavaResourceNode parent, Type type) {
        super(parent, type, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter<String>(type, VALUE_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.value(astRoot);
        this.fullyQualifiedValue = this.fullyQualifiedClass(astRoot);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.IdClass";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        if (this.attributeValueHasNotChanged(this.value, newValue)) {
            return;
        }
        String oldValue = this.value;
        this.value = newValue;
        this.valueAdapter.setValue(newValue);
        this.firePropertyChanged("valueProperty", oldValue, newValue);
    }

    @Override
    public String getFullyQualifiedClass() {
        return this.fullyQualifiedValue;
    }

    private void setFullyQualifiedClass(String newQualifiedClass) {
        String oldQualifiedClass = this.fullyQualifiedValue;
        this.fullyQualifiedValue = newQualifiedClass;
        this.firePropertyChanged("fullyQualifiedClassProperty", oldQualifiedClass, newQualifiedClass);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setValue(this.value(astRoot));
        this.setFullyQualifiedClass(this.fullyQualifiedClass(astRoot));
    }

    protected String value(CompilationUnit astRoot) {
        return this.valueAdapter.getValue(astRoot);
    }

    private String fullyQualifiedClass(CompilationUnit astRoot) {
        if (this.getValue() == null) {
            return null;
        }
        return JDTTools.resolveFullyQualifiedName(this.valueAdapter.getExpression(astRoot));
    }

    protected static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter<String>(DECLARATION_ANNOTATION_ADAPTER, "value", SimpleTypeStringExpressionConverter.instance());
    }

    public static class IdClassAnnotationDefinition
    implements AnnotationDefinition {
        private static final IdClassAnnotationDefinition INSTANCE = new IdClassAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private IdClassAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new IdClassImpl(parent, (Type)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.IdClass";
        }
    }
}

