/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourcePersistentMember;
import org.eclipse.jpt.core.internal.resource.java.JavaResourcePersistentAttributeImpl;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.core.resource.java.AccessType;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.Counter;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.TreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaResourcePersistentTypeImpl
extends AbstractJavaResourcePersistentMember<Type>
implements JavaResourcePersistentType {
    private String name;
    private String qualifiedName;
    private String superClassQualifiedName;
    private boolean abstract_;
    private final Vector<JavaResourcePersistentType> types = new Vector();
    private final Vector<JavaResourcePersistentAttribute> fields = new Vector();
    private final Vector<JavaResourcePersistentAttribute> methods = new Vector();
    private AccessType access;

    public static JavaResourcePersistentType newInstance(JpaCompilationUnit jpaCompilationUnit, TypeDeclaration typeDeclaration, CompilationUnit astRoot) {
        JDTType type = new JDTType(typeDeclaration, jpaCompilationUnit.getCompilationUnit(), jpaCompilationUnit.getModifySharedDocumentCommandExecutorProvider(), jpaCompilationUnit.getAnnotationEditFormatter());
        JavaResourcePersistentTypeImpl jrpt = new JavaResourcePersistentTypeImpl(jpaCompilationUnit, type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    protected static JavaResourcePersistentType newInstance(JpaCompilationUnit jpaCompilationUnit, Type declaringType, TypeDeclaration typeDeclaration, int occurrence, CompilationUnit astRoot) {
        JDTType type = new JDTType(declaringType, typeDeclaration, occurrence, jpaCompilationUnit.getCompilationUnit(), jpaCompilationUnit.getModifySharedDocumentCommandExecutorProvider(), jpaCompilationUnit.getAnnotationEditFormatter());
        JavaResourcePersistentTypeImpl jrpt = new JavaResourcePersistentTypeImpl(jpaCompilationUnit, type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    public JavaResourcePersistentTypeImpl(JpaCompilationUnit jpaCompilationUnit, Type type) {
        super(jpaCompilationUnit, type);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.name = this.buildName(astRoot);
        this.qualifiedName = this.buildQualifiedName(astRoot);
        this.superClassQualifiedName = this.buildSuperClassQualifiedName(astRoot);
        this.abstract_ = this.buildAbstract(astRoot);
        this.initializeTypes(astRoot);
        this.initializeFields(astRoot);
        this.initializeMethods(astRoot);
        this.access = this.buildAccess();
    }

    protected void initializeTypes(CompilationUnit astRoot) {
        TypeDeclaration[] typeDeclarations = ((Type)this.getMember()).getTypes(astRoot);
        CounterMap counters = new CounterMap(typeDeclarations.length);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration td = typeDeclarationArray[n2];
            String tdName = td.getName().getFullyQualifiedName();
            int occurrence = counters.increment(tdName);
            this.types.add(this.buildType(td, occurrence, astRoot));
            ++n2;
        }
    }

    protected void initializeFields(CompilationUnit astRoot) {
        FieldDeclaration[] fieldDeclarations = ((Type)this.getMember()).getFields(astRoot);
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : JavaResourcePersistentTypeImpl.fragments(fieldDeclaration)) {
                String fieldName = fragment.getName().getFullyQualifiedName();
                int occurrence = counters.increment(fieldName);
                this.fields.add(this.buildField(fieldName, occurrence, astRoot));
            }
            ++n2;
        }
    }

    protected void initializeMethods(CompilationUnit astRoot) {
        MethodDeclaration[] methodDeclarations = ((Type)this.getMember()).getMethods(astRoot);
        CounterMap counters = new CounterMap(methodDeclarations.length);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = JDTTools.buildMethodSignature(methodDeclaration);
            int occurrence = counters.increment(signature);
            this.methods.add(this.buildMethod(signature, occurrence, astRoot));
            ++n2;
        }
    }

    @Override
    protected Annotation buildMappingAnnotation(String mappingAnnotationName) {
        return this.getAnnotationProvider().buildTypeMappingAnnotation(this, (Type)this.getMember(), mappingAnnotationName);
    }

    @Override
    protected Annotation buildNullMappingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeMappingAnnotation(this, (Type)this.getMember(), annotationName);
    }

    @Override
    protected Annotation buildSupportingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildTypeSupportingAnnotation(this, (Type)this.getMember(), annotationName);
    }

    @Override
    protected Annotation buildNullSupportingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeSupportingAnnotation(this, (Type)this.getMember(), annotationName);
    }

    @Override
    protected ListIterator<String> validMappingAnnotationNames() {
        return this.getAnnotationProvider().typeMappingAnnotationNames();
    }

    @Override
    protected ListIterator<String> validSupportingAnnotationNames() {
        return this.getAnnotationProvider().typeSupportingAnnotationNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.setSuperClassQualifiedName(this.buildSuperClassQualifiedName(astRoot));
        Iterator<JavaResourcePersistentAttribute> stream = this.fields();
        while (stream.hasNext()) {
            stream.next().resolveTypes(astRoot);
        }
        this.updateMethods(astRoot);
        stream = this.methods();
        while (stream.hasNext()) {
            stream.next().resolveTypes(astRoot);
        }
        Vector<JavaResourcePersistentType> vector = this.types;
        synchronized (vector) {
            for (JavaResourcePersistentType type : this.types) {
                type.resolveTypes(astRoot);
            }
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    protected void setQualifiedName(String qualifiedName) {
        String old = this.qualifiedName;
        this.qualifiedName = qualifiedName;
        this.firePropertyChanged("qualifiedName", old, qualifiedName);
    }

    @Override
    public String getSuperClassQualifiedName() {
        return this.superClassQualifiedName;
    }

    protected void setSuperClassQualifiedName(String superClassQualifiedName) {
        String old = this.superClassQualifiedName;
        this.superClassQualifiedName = superClassQualifiedName;
        this.firePropertyChanged("superClassQualifiedName", old, superClassQualifiedName);
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    protected void setAbstract(boolean abstract_) {
        boolean old = this.abstract_;
        this.abstract_ = abstract_;
        this.firePropertyChanged("abstract", old, abstract_);
    }

    @Override
    public AccessType getAccess() {
        return this.access;
    }

    protected void setAccess(AccessType access) {
        AccessType old = this.access;
        this.access = access;
        this.firePropertyChanged("access", (Object)old, (Object)access);
    }

    @Override
    public boolean hasAnyAttributeAnnotations() {
        Iterator<JavaResourcePersistentAttribute> stream = this.persistableAttributes();
        while (stream.hasNext()) {
            if (!stream.next().hasAnyAnnotations()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<JavaResourcePersistentType> types() {
        return new CloneIterator(this.types);
    }

    @Override
    public Iterator<JavaResourcePersistentType> allTypes() {
        return new TreeIterator<JavaResourcePersistentType>((JavaResourcePersistentType)this){

            protected Iterator<? extends JavaResourcePersistentType> children(JavaResourcePersistentType type) {
                return type.types();
            }
        };
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistableTypes() {
        return JavaResourcePersistentTypeImpl.persistableMembers(this.types());
    }

    @Override
    public Iterator<JavaResourcePersistentType> allPersistableTypes() {
        return JavaResourcePersistentTypeImpl.persistableMembers(this.allTypes());
    }

    protected JavaResourcePersistentType getType(String typeName, int occurrence) {
        for (JavaResourcePersistentType type : this.types) {
            if (!type.isFor(typeName, occurrence)) continue;
            return type;
        }
        return null;
    }

    protected void addType(JavaResourcePersistentType type) {
        this.addItemToCollection(type, this.types, "types");
    }

    protected void removeTypes(Collection<JavaResourcePersistentType> remove) {
        this.removeItemsFromCollection(remove, this.types, "types");
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> fields() {
        return new CloneIterator(this.fields);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFields() {
        return JavaResourcePersistentTypeImpl.persistableMembers(this.fields());
    }

    protected void addField(JavaResourcePersistentAttribute field) {
        this.addItemToCollection(field, this.fields, "fields");
    }

    protected JavaResourcePersistentAttribute getField(String fieldName, int occurrence) {
        for (JavaResourcePersistentAttribute field : this.fields) {
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    protected void removeFields(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.fields, "fields");
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> methods() {
        return new CloneIterator(this.methods);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableProperties() {
        return JavaResourcePersistentTypeImpl.persistableMembers(this.methods());
    }

    protected JavaResourcePersistentAttribute getMethod(MethodSignature signature, int occurrence) {
        for (JavaResourcePersistentAttribute method : this.methods) {
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    protected void addMethod(JavaResourcePersistentAttribute method) {
        this.addItemToCollection(method, this.methods, "methods");
    }

    protected void removeMethods(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.methods, "methods");
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistableProperties()});
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setName(this.buildName(astRoot));
        this.setQualifiedName(this.buildQualifiedName(astRoot));
        this.setSuperClassQualifiedName(this.buildSuperClassQualifiedName(astRoot));
        this.setAbstract(this.buildAbstract(astRoot));
        this.updateTypes(astRoot);
        this.updateFields(astRoot);
        this.updateMethods(astRoot);
        this.setAccess(this.buildAccess());
    }

    protected String buildName(CompilationUnit astRoot) {
        return ((Type)this.getMember()).getBinding(astRoot).getName();
    }

    protected String buildQualifiedName(CompilationUnit astRoot) {
        return ((Type)this.getMember()).getBinding(astRoot).getQualifiedName();
    }

    protected String buildSuperClassQualifiedName(CompilationUnit astRoot) {
        ITypeBinding typeBinding = ((Type)this.getMember()).getBinding(astRoot);
        if (typeBinding == null) {
            return null;
        }
        ITypeBinding superClassTypeBinding = typeBinding.getSuperclass();
        if (superClassTypeBinding == null) {
            return null;
        }
        return superClassTypeBinding.getTypeDeclaration().getQualifiedName();
    }

    protected boolean buildAbstract(CompilationUnit astRoot) {
        return Modifier.isAbstract((int)((Type)this.getMember()).getBinding(astRoot).getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTypes(CompilationUnit astRoot) {
        Vector<JavaResourcePersistentType> vector = this.types;
        synchronized (vector) {
            this.updateTypes_(astRoot);
        }
    }

    protected void updateTypes_(CompilationUnit astRoot) {
        TypeDeclaration[] typeDeclarations = ((Type)this.getMember()).getTypes(astRoot);
        CounterMap counters = new CounterMap(typeDeclarations.length);
        HashSet<JavaResourcePersistentType> typesToRemove = new HashSet<JavaResourcePersistentType>(this.types);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            TypeDeclaration typeDeclaration = typeDeclarationArray[n2];
            String tdName = typeDeclaration.getName().getFullyQualifiedName();
            JavaResourcePersistentType type = this.getType(tdName, occurrence = counters.increment(tdName));
            if (type == null) {
                this.addType(this.buildType(typeDeclaration, occurrence, astRoot));
            } else {
                typesToRemove.remove(type);
                type.update(astRoot);
            }
            ++n2;
        }
        this.removeTypes(typesToRemove);
    }

    protected JavaResourcePersistentType buildType(TypeDeclaration nestedTypeDeclaration, int occurrence, CompilationUnit astRoot) {
        return JavaResourcePersistentTypeImpl.newInstance(this.getJpaCompilationUnit(), (Type)this.getMember(), nestedTypeDeclaration, occurrence, astRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFields(CompilationUnit astRoot) {
        Vector<JavaResourcePersistentAttribute> vector = this.fields;
        synchronized (vector) {
            this.updateFields_(astRoot);
        }
    }

    protected void updateFields_(CompilationUnit astRoot) {
        FieldDeclaration[] fieldDeclarations = ((Type)this.getMember()).getFields(astRoot);
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        HashSet<JavaResourcePersistentAttribute> fieldsToRemove = new HashSet<JavaResourcePersistentAttribute>(this.fields);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : JavaResourcePersistentTypeImpl.fragments(fieldDeclaration)) {
                int occurrence;
                String fieldName = fragment.getName().getFullyQualifiedName();
                JavaResourcePersistentAttribute field = this.getField(fieldName, occurrence = counters.increment(fieldName));
                if (field == null) {
                    this.addField(this.buildField(fieldName, occurrence, astRoot));
                    continue;
                }
                fieldsToRemove.remove(field);
                field.update(astRoot);
            }
            ++n2;
        }
        this.removeFields(fieldsToRemove);
    }

    protected JavaResourcePersistentAttribute buildField(String fieldName, int occurrence, CompilationUnit astRoot) {
        return JavaResourcePersistentAttributeImpl.newInstance((JavaResourcePersistentType)this, (Type)this.getMember(), fieldName, occurrence, this.getJpaCompilationUnit(), astRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMethods(CompilationUnit astRoot) {
        Vector<JavaResourcePersistentAttribute> vector = this.methods;
        synchronized (vector) {
            this.updateMethods_(astRoot);
        }
    }

    protected void updateMethods_(CompilationUnit astRoot) {
        MethodDeclaration[] methodDeclarations = ((Type)this.getMember()).getMethods(astRoot);
        CounterMap counters = new CounterMap(methodDeclarations.length);
        HashSet<JavaResourcePersistentAttribute> methodsToRemove = new HashSet<JavaResourcePersistentAttribute>(this.methods);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = JDTTools.buildMethodSignature(methodDeclaration);
            JavaResourcePersistentAttribute method = this.getMethod(signature, occurrence = counters.increment(signature));
            if (method == null) {
                this.addMethod(this.buildMethod(signature, occurrence, astRoot));
            } else {
                methodsToRemove.remove(method);
                method.update(astRoot);
            }
            ++n2;
        }
        this.removeMethods(methodsToRemove);
    }

    protected JavaResourcePersistentAttribute buildMethod(MethodSignature signature, int occurrence, CompilationUnit astRoot) {
        return JavaResourcePersistentAttributeImpl.newInstance((JavaResourcePersistentType)this, (Type)this.getMember(), signature, occurrence, this.getJpaCompilationUnit(), astRoot);
    }

    protected AccessType buildAccess() {
        boolean hasPersistableFields = false;
        Iterator<JavaResourcePersistentAttribute> stream = this.persistableFields();
        while (stream.hasNext()) {
            hasPersistableFields = true;
            if (!stream.next().hasAnyAnnotations()) continue;
            return AccessType.FIELD;
        }
        boolean hasPersistableProperties = false;
        Iterator<JavaResourcePersistentAttribute> stream2 = this.persistableProperties();
        while (stream2.hasNext()) {
            hasPersistableProperties = true;
            if (!stream2.next().hasAnyAnnotations()) continue;
            return AccessType.PROPERTY;
        }
        if (hasPersistableProperties && !hasPersistableFields) {
            return AccessType.PROPERTY;
        }
        return null;
    }

    protected static List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }

    protected static class CounterMap {
        private final HashMap<Object, Counter> counters;

        protected CounterMap(int initialCapacity) {
            this.counters = new HashMap(initialCapacity);
        }

        int increment(Object o) {
            Counter counter = this.counters.get(o);
            if (counter == null) {
                counter = new Counter();
                this.counters.put(o, counter);
            }
            counter.increment();
            return counter.count();
        }
    }
}

