/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceTable;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.resource.java.JoinColumnImpl;
import org.eclipse.jpt.core.internal.resource.java.NullJoinTable;
import org.eclipse.jpt.core.internal.resource.java.UniqueConstraintImpl;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinColumn;
import org.eclipse.jpt.core.resource.java.NestableUniqueConstraint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableImpl
extends AbstractResourceTable
implements JoinTableAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinTable");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "name");
    private static final DeclarationAnnotationElementAdapter<String> SCHEMA_ADAPTER = ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "schema");
    private static final DeclarationAnnotationElementAdapter<String> CATALOG_ADAPTER = ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "catalog");
    protected final List<NestableJoinColumn> joinColumns = new ArrayList<NestableJoinColumn>();
    protected final List<NestableJoinColumn> inverseJoinColumns = new ArrayList<NestableJoinColumn>();
    private final JoinColumnsContainerAnnotation joinColumnsContainerAnnotation = new JoinColumnsContainerAnnotation();
    private final InverseJoinColumnsContainerAnnotation inverseJoinColumnsContainerAnnotation = new InverseJoinColumnsContainerAnnotation();

    protected JoinTableImpl(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, DECLARATION_ANNOTATION_ADAPTER));
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this.joinColumnsContainerAnnotation);
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this.inverseJoinColumnsContainerAnnotation);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getNameAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return NAME_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getSchemaAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return SCHEMA_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getCatalogAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return CATALOG_ADAPTER;
    }

    @Override
    protected String getUniqueConstraintsElementName() {
        return "uniqueConstraints";
    }

    @Override
    protected NestableUniqueConstraint createUniqueConstraint(int index) {
        return UniqueConstraintImpl.createJoinTableUniqueConstraint(this, this.getMember(), index);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.updateJoinColumnsFromJava(astRoot);
        this.updateInverseJoinColumnsFromJava(astRoot);
    }

    private void updateJoinColumnsFromJava(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this.joinColumnsContainerAnnotation);
    }

    private void updateInverseJoinColumnsFromJava(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this.inverseJoinColumnsContainerAnnotation);
    }

    @Override
    public ListIterator<JoinColumnAnnotation> joinColumns() {
        return new CloneListIterator(this.joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.joinColumns.size();
    }

    @Override
    public NestableJoinColumn joinColumnAt(int index) {
        return this.joinColumns.get(index);
    }

    @Override
    public int indexOfJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.joinColumns.indexOf(joinColumn);
    }

    @Override
    public JoinColumnAnnotation addJoinColumn(int index) {
        NestableJoinColumn joinColumn = (NestableJoinColumn)ContainerAnnotationTools.addNestedAnnotation(index, this.joinColumnsContainerAnnotation);
        this.fireItemAdded("joinColumnsList", index, joinColumn);
        return joinColumn;
    }

    protected void addJoinColumn(int index, NestableJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.joinColumns, "joinColumnsList");
    }

    @Override
    public void removeJoinColumn(int index) {
        NestableJoinColumn joinColumn = this.joinColumns.get(index);
        this.removeJoinColumn(joinColumn);
        joinColumn.removeAnnotation();
        ContainerAnnotationTools.synchAnnotationsAfterRemove(index, this.joinColumnsContainerAnnotation);
    }

    protected void removeJoinColumn(NestableJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.joinColumns, "joinColumnsList");
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        this.moveJoinColumnInternal(targetIndex, sourceIndex);
        ContainerAnnotationTools.synchAnnotationsAfterMove(targetIndex, sourceIndex, this.joinColumnsContainerAnnotation);
        this.fireItemMoved("joinColumnsList", targetIndex, sourceIndex);
    }

    protected void moveJoinColumnInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex);
    }

    @Override
    public ListIterator<JoinColumnAnnotation> inverseJoinColumns() {
        return new CloneListIterator(this.inverseJoinColumns);
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.inverseJoinColumns.size();
    }

    @Override
    public NestableJoinColumn inverseJoinColumnAt(int index) {
        return this.inverseJoinColumns.get(index);
    }

    @Override
    public int indexOfInverseJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.inverseJoinColumns.indexOf(joinColumn);
    }

    @Override
    public JoinColumnAnnotation addInverseJoinColumn(int index) {
        NestableJoinColumn inverseJoinColumn = (NestableJoinColumn)ContainerAnnotationTools.addNestedAnnotation(index, this.inverseJoinColumnsContainerAnnotation);
        this.fireItemAdded("inverseJoinColumnsList", index, inverseJoinColumn);
        return inverseJoinColumn;
    }

    protected void addInverseJoinColumn(int index, NestableJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.inverseJoinColumns, "inverseJoinColumnsList");
    }

    @Override
    public void removeInverseJoinColumn(int index) {
        NestableJoinColumn joinColumn = this.inverseJoinColumns.get(index);
        this.removeInverseJoinColumn(joinColumn);
        joinColumn.removeAnnotation();
        ContainerAnnotationTools.synchAnnotationsAfterRemove(index, this.inverseJoinColumnsContainerAnnotation);
    }

    protected void removeInverseJoinColumn(NestableJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.inverseJoinColumns, "inverseJoinColumnsList");
    }

    @Override
    public void moveInverseJoinColumn(int targetIndex, int sourceIndex) {
        this.moveInverseJoinColumnInternal(targetIndex, sourceIndex);
        ContainerAnnotationTools.synchAnnotationsAfterMove(targetIndex, sourceIndex, this.inverseJoinColumnsContainerAnnotation);
        this.fireItemMoved("inverseJoinColumnsList", targetIndex, sourceIndex);
    }

    protected void moveInverseJoinColumnInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.inverseJoinColumns, (int)targetIndex, (int)sourceIndex);
    }

    protected NestableJoinColumn createJoinColumn(int index) {
        return JoinColumnImpl.createJoinTableJoinColumn(this, this.getMember(), index);
    }

    protected NestableJoinColumn createInverseJoinColumn(int index) {
        return JoinColumnImpl.createJoinTableInverseJoinColumn(this, this.getMember(), index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractContainerAnnotation
    extends AbstractJavaResourceNode
    implements ContainerAnnotation<NestableJoinColumn> {
        public AbstractContainerAnnotation() {
            super(JoinTableImpl.this);
        }

        @Override
        public void initialize(CompilationUnit astRoot) {
        }

        @Override
        public String getAnnotationName() {
            return JoinTableImpl.this.getAnnotationName();
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        @Override
        public void remove(int index) {
            this.remove((NestableJoinColumn)this.nestedAnnotationAt(index));
        }

        @Override
        public NestableJoinColumn nestedAnnotationFor(org.eclipse.jdt.core.dom.Annotation jdtAnnotation) {
            for (NestableJoinColumn joinColumn : CollectionTools.iterable((Iterator)this.nestedAnnotations())) {
                if (jdtAnnotation != joinColumn.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
                return joinColumn;
            }
            return null;
        }

        @Override
        public org.eclipse.jdt.core.dom.Annotation getJdtAnnotation(CompilationUnit astRoot) {
            return JoinTableImpl.this.getJdtAnnotation(astRoot);
        }

        @Override
        public void newAnnotation() {
            JoinTableImpl.this.newAnnotation();
        }

        @Override
        public void removeAnnotation() {
            JoinTableImpl.this.removeAnnotation();
        }

        @Override
        public void update(CompilationUnit astRoot) {
            JoinTableImpl.this.update(astRoot);
        }

        @Override
        public TextRange getTextRange(CompilationUnit astRoot) {
            return JoinTableImpl.this.getTextRange(astRoot);
        }

        public void toString(StringBuilder sb) {
            sb.append(this.getAnnotationName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InverseJoinColumnsContainerAnnotation
    extends AbstractContainerAnnotation {
        protected InverseJoinColumnsContainerAnnotation() {
        }

        @Override
        public NestableJoinColumn addInternal(int index) {
            NestableJoinColumn joinColumn = JoinTableImpl.this.createInverseJoinColumn(index);
            JoinTableImpl.this.inverseJoinColumns.add(index, joinColumn);
            return joinColumn;
        }

        @Override
        public NestableJoinColumn add(int index) {
            NestableJoinColumn joinColumn = JoinTableImpl.this.createInverseJoinColumn(index);
            JoinTableImpl.this.addInverseJoinColumn(index, joinColumn);
            return joinColumn;
        }

        @Override
        public int indexOf(NestableJoinColumn joinColumn) {
            return JoinTableImpl.this.indexOfInverseJoinColumn(joinColumn);
        }

        @Override
        public void move(int targetIndex, int sourceIndex) {
            JoinTableImpl.this.moveInverseJoinColumn(targetIndex, sourceIndex);
        }

        @Override
        public void moveInternal(int targetIndex, int sourceIndex) {
            JoinTableImpl.this.moveInverseJoinColumnInternal(targetIndex, sourceIndex);
        }

        @Override
        public NestableJoinColumn nestedAnnotationAt(int index) {
            return JoinTableImpl.this.inverseJoinColumnAt(index);
        }

        @Override
        public ListIterator<NestableJoinColumn> nestedAnnotations() {
            return new CloneListIterator(JoinTableImpl.this.inverseJoinColumns);
        }

        @Override
        public int nestedAnnotationsSize() {
            return JoinTableImpl.this.inverseJoinColumnsSize();
        }

        @Override
        public void remove(NestableJoinColumn nestedAnnotation) {
            JoinTableImpl.this.removeInverseJoinColumn(nestedAnnotation);
        }

        @Override
        public String getElementName() {
            return "inverseJoinColumns";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JoinColumnsContainerAnnotation
    extends AbstractContainerAnnotation {
        protected JoinColumnsContainerAnnotation() {
        }

        @Override
        public NestableJoinColumn addInternal(int index) {
            NestableJoinColumn joinColumn = JoinTableImpl.this.createJoinColumn(index);
            JoinTableImpl.this.joinColumns.add(index, joinColumn);
            return joinColumn;
        }

        @Override
        public NestableJoinColumn add(int index) {
            NestableJoinColumn joinColumn = JoinTableImpl.this.createJoinColumn(index);
            JoinTableImpl.this.addJoinColumn(index, joinColumn);
            return joinColumn;
        }

        @Override
        public int indexOf(NestableJoinColumn joinColumn) {
            return JoinTableImpl.this.indexOfJoinColumn(joinColumn);
        }

        @Override
        public void move(int targetIndex, int sourceIndex) {
            JoinTableImpl.this.moveJoinColumn(targetIndex, sourceIndex);
        }

        @Override
        public void moveInternal(int targetIndex, int sourceIndex) {
            JoinTableImpl.this.moveJoinColumnInternal(targetIndex, sourceIndex);
        }

        @Override
        public NestableJoinColumn nestedAnnotationAt(int index) {
            return JoinTableImpl.this.joinColumnAt(index);
        }

        @Override
        public ListIterator<NestableJoinColumn> nestedAnnotations() {
            return new CloneListIterator(JoinTableImpl.this.joinColumns);
        }

        @Override
        public int nestedAnnotationsSize() {
            return JoinTableImpl.this.joinColumnsSize();
        }

        @Override
        public void remove(NestableJoinColumn nestedAnnotation) {
            JoinTableImpl.this.removeJoinColumn(nestedAnnotation);
        }

        @Override
        public String getElementName() {
            return "joinColumns";
        }
    }

    public static class JoinTableAnnotationDefinition
    implements AnnotationDefinition {
        private static final JoinTableAnnotationDefinition INSTANCE = new JoinTableAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private JoinTableAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new JoinTableImpl(parent, member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new NullJoinTable(parent);
        }

        public String getAnnotationName() {
            return "javax.persistence.JoinTable";
        }
    }
}

