/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.persistence.customization;

import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Customization;
import org.eclipse.jpt.eclipselink.ui.JptEclipseLinkUiPlugin;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionCustomizersComposite
extends Pane<Customization> {
    public SessionCustomizersComposite(Pane<? extends Customization> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private void addSessionCustomizerClass(ObjectListSelectionModel listSelectionModel) {
        IType type = this.chooseType();
        if (type != null) {
            String className = type.getFullyQualifiedName('.');
            if (!((Customization)this.getSubject()).sessionCustomizerExists(className)) {
                ClassRef classRef = ((Customization)this.getSubject()).addSessionCustomizer(className);
                listSelectionModel.setSelectedValue((Object)classRef);
            }
        }
    }

    private AddRemovePane.Adapter buildAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                SessionCustomizersComposite.this.addSessionCustomizerClass(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ((Customization)SessionCustomizersComposite.this.getSubject()).removeSessionCustomizer((ClassRef)item);
                    ++n2;
                }
            }
        };
    }

    private ILabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                ClassRef classRef = (ClassRef)element;
                String name = classRef.getClassName();
                if (name == null) {
                    name = EclipseLinkUiMessages.PersistenceXmlCustomizationTab_noName;
                }
                return name;
            }
        };
    }

    private ListValueModel<ClassRef> buildItemListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildListHolder(), new String[]{"javaPersistentType", "className"});
    }

    private ListValueModel<ClassRef> buildListHolder() {
        return new ListAspectAdapter<Customization, ClassRef>(this.getSubjectHolder(), new String[]{"sessionCustomizerListProperty"}){

            protected ListIterator<ClassRef> listIterator_() {
                return ((Customization)this.subject).sessionCustomizers();
            }

            protected int size_() {
                return ((Customization)this.subject).sessionCustomizersSize();
            }
        };
    }

    private WritablePropertyValueModel<ClassRef> buildSelectedItemHolder() {
        return new SimplePropertyValueModel();
    }

    private IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IPackageFragmentRoot root = this.packageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            JptEclipseLinkUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(JptUiMessages.ClassChooserPane_dialogTitle);
        typeSelectionDialog.setMessage(JptUiMessages.ClassChooserPane_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    protected void initializeLayout(Composite container) {
        this.addMultiLineLabel(container, EclipseLinkUiMessages.PersistenceXmlCustomizationTab_sessionCustomizerLabel);
        new AddRemoveListPane<Customization>((Pane)this, container, this.buildAdapter(), this.buildItemListHolder(), this.buildSelectedItemHolder(), this.buildLabelProvider()){

            protected void initializeTable(Table table) {
                super.initializeTable(table);
                Composite container = table.getParent();
                GridData gridData = (GridData)container.getLayoutData();
                gridData.heightHint = 75;
            }
        };
    }

    private IPackageFragmentRoot packageFragmentRoot() {
        IProject project = ((Customization)this.getSubject()).getJpaProject().getProject();
        IJavaProject root = JavaCore.create((IProject)project);
        try {
            return root.getAllPackageFragmentRoots()[0];
        }
        catch (JavaModelException e) {
            JptEclipseLinkUiPlugin.log(e);
            return null;
        }
    }
}

