/*******************************************************************************
 * Copyright (c) 2007, 2008 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.core.internal;

import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.resource.common.JpaXmlResource;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/**
 * Provisional API: This interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is available at this early stage to solicit feedback from
 * pioneering adopters on the understanding that any code that uses this API
 * will almost certainly be broken (repeatedly) as the API evolves.
 */
public class XmlJpaFile
	extends AbstractJpaFile
{
	private final JpaXmlResource resource;


	public XmlJpaFile(JpaProject jpaProject, IFile file, JpaXmlResource resource) {
		super(jpaProject, file);
		this.resource = resource;
		this.resource.setResourceModelListener(this.getResourceModelListener());
	}

	public Iterator<JavaResourcePersistentType> persistableTypes() {
		return EmptyIterator.<JavaResourcePersistentType>instance();
	}

	public String getResourceType() {
		return this.resource.getType();
	}

	public void javaElementChanged(ElementChangedEvent event) {
		// nothing to do yet
	}

	public void jpaFilesChanged() {
		// nothing to do yet
	}

}
