/*******************************************************************************
 * Copyright (c) 2008 Oracle. All rights reserved.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *******************************************************************************/
package org.eclipse.jpt.core.internal.resource.persistence.translators;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jpt.core.internal.resource.common.translators.BooleanTranslator;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class PersistenceUnitTranslator extends Translator
	implements PersistenceXmlMapper
{
	private Translator[] children;
	
	
	public PersistenceUnitTranslator(String domNameAndPath, EStructuralFeature aFeature) {
		super(domNameAndPath, aFeature);
	}
	
	@Override
	protected Translator[] getChildren() {
		if (children == null) {
			children = createChildren();
		}
		return children;
	}
	
	protected Translator[] createChildren() {
		return new Translator[] {
			createNameTranslator(),
			createTransactionTypeTranslator(),
			createDescriptionTranslator(),
			createProviderTranslator(),
			createJtaDataSourceTranslator(),
			createNonJtaDataSourceTranslator(),
			createMappingFileTranslator(),
			createJarFileTranslator(),
			createClassTranslator(),
			createExcludeUnlistedClassesTranslator(),
			createPropertiesTranslator()
		};
	}
	
	private Translator createNameTranslator() {
		return new Translator(NAME, PERSISTENCE_PKG.getXmlPersistenceUnit_Name(), DOM_ATTRIBUTE);
	}
	
	private Translator createTransactionTypeTranslator() {
		return new Translator(TRANSACTION_TYPE, PERSISTENCE_PKG.getXmlPersistenceUnit_TransactionType(), DOM_ATTRIBUTE | UNSET_IF_NULL);
	}
	
	private Translator createDescriptionTranslator() {
		return new Translator(DESCRIPTION, PERSISTENCE_PKG.getXmlPersistenceUnit_Description());
	}
	
	private Translator createProviderTranslator() {
		return new Translator(PROVIDER, PERSISTENCE_PKG.getXmlPersistenceUnit_Provider());
	}
	
	private Translator createJtaDataSourceTranslator() {
		return new Translator(JTA_DATA_SOURCE, PERSISTENCE_PKG.getXmlPersistenceUnit_JtaDataSource());
	}
	
	private Translator createNonJtaDataSourceTranslator() {
		return new Translator(NON_JTA_DATA_SOURCE, PERSISTENCE_PKG.getXmlPersistenceUnit_NonJtaDataSource());
	}
	
	private Translator createMappingFileTranslator() {
		return new MappingFileTranslator(MAPPING_FILE, PERSISTENCE_PKG.getXmlPersistenceUnit_MappingFiles());
	}
	
	private Translator createJarFileTranslator() {
		return new Translator(JAR_FILE, PERSISTENCE_PKG.getXmlPersistenceUnit_JarFiles(), Translator.END_TAG_NO_INDENT);
	}
	
	private Translator createClassTranslator() {
		return new JavaClassRefTranslator(CLASS, PERSISTENCE_PKG.getXmlPersistenceUnit_Classes(), Translator.END_TAG_NO_INDENT);
	}
	
	private Translator createExcludeUnlistedClassesTranslator() {
		return new BooleanTranslator(EXCLUDE_UNLISTED_CLASSES, PERSISTENCE_PKG.getXmlPersistenceUnit_ExcludeUnlistedClasses());
	}
	
	private Translator createPropertiesTranslator() {
		return new PropertiesTranslator(PROPERTIES, PERSISTENCE_PKG.getXmlPersistenceUnit_Properties());
	}
}
