/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.MappedSuperclass;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.internal.context.java.JavaNullTypeMapping;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaEntityTests
extends ContextModelTestCase {
    private static final String ENTITY_NAME = "entityName";
    private static final String TABLE_NAME = "MY_TABLE";
    private static final String DISCRIMINATOR_VALUE = "MY_DISCRIMINATOR_VALUE";
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    public JavaEntityTests(String name) {
        super(name);
    }

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createIdAnnotation() throws Exception {
        this.createAnnotationAndMembers("Id", "");
    }

    private void createMappedSuperclassAnnotation() throws Exception {
        this.createAnnotationAndMembers("MappedSuperclass", "");
    }

    private void createTableAnnotation() throws Exception {
        this.createAnnotationAndMembers("Table", "String name() default \"\";");
    }

    private void createInheritanceAnnotation() throws Exception {
        this.createInheritanceTypeEnum();
        this.createAnnotationAndMembers("Inheritance", "InheritanceType strategy() default SINGLE_TABLE;");
    }

    private void createInheritanceTypeEnum() throws Exception {
        this.createEnumAndMembers("InheritanceType", "SINGLE_TABLE, JOINED, TABLE_PER_CLASS");
    }

    private void createDiscriminatorValueAnnotation() throws Exception {
        this.createAnnotationAndMembers("DiscriminatorValue", "String value();");
    }

    private void createSecondaryTableAnnotation() throws Exception {
        this.createAnnotationAndMembers("SecondaryTable", "String name(); String catalog() default \"\"; String schema() default \"\"; ");
    }

    private void createSecondaryTablesAnnotation() throws Exception {
        this.createSecondaryTableAnnotation();
        this.createAnnotationAndMembers("SecondaryTables", "SecondaryTable[] value();");
    }

    private void createPrimaryKeyJoinColumnAnnotation() throws Exception {
        this.createAnnotationAndMembers("PrimaryKeyJoinColumn", "String name(); String referencedColumnName() default \"\"; String columnDefinition() default \"\"; ");
    }

    private void createPrimaryKeyJoinColumnsAnnotation() throws Exception {
        this.createPrimaryKeyJoinColumnAnnotation();
        this.createAnnotationAndMembers("PrimaryKeyJoinColumns", "PrimaryKeyJoinColumn[] value();");
    }

    private ICompilationUnit createTestEntity() throws Exception {
        this.createEntityAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private void createTestAbstractEntity() throws Exception {
        this.createEntityAnnotation();
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public abstract class ").append("AnnotationTestType").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityAnnotationOnProperty() throws Exception {
        this.createEntityAnnotation();
        this.createIdAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        this.createMappedSuperclassAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private ICompilationUnit createTestEntityWithName() throws Exception {
        this.createEntityAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity(name=\"entityName\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithTable() throws Exception {
        this.createEntityAnnotation();
        this.createTableAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Table"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Table(name=\"MY_TABLE\")");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(JavaEntityTests.SUB_TYPE_NAME).append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithInheritance() throws Exception {
        this.createEntityAnnotation();
        this.createInheritanceAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithDiscriminatorValue() throws Exception {
        this.createEntityAnnotation();
        this.createDiscriminatorValueAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.DiscriminatorValue"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@DiscriminatorValue(value=\"MY_DISCRIMINATOR_VALUE\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTable() throws Exception {
        this.createEntityAnnotation();
        this.createSecondaryTableAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@SecondaryTable(name=\"foo\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTables() throws Exception {
        this.createEntityAnnotation();
        this.createSecondaryTablesAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@SecondaryTables({@SecondaryTable(name=\"foo\"), @SecondaryTable(name=\"bar\")})");
            }
        });
    }

    public void testMorphToMappedSuperclass() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = (Entity)this.javaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.addTableGenerator();
        entity.addSequenceGenerator();
        entity.setIdClass("myIdClass");
        entity.addNamedNativeQuery(0);
        entity.addNamedQuery(0);
        this.javaPersistentType().setMappingKey("mappedSuperclass");
        JavaEntityTests.assertTrue((boolean)(this.javaPersistentType().getMapping() instanceof MappedSuperclass));
        JavaEntityTests.assertNull((Object)typeResource.getMappingAnnotation("javax.persistence.Entity"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Table"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTable"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Inheritance"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorValue"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedQuery"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedNativeQuery"));
    }

    public void testMorphToEmbeddable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = (Entity)this.javaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.addTableGenerator();
        entity.addSequenceGenerator();
        entity.setIdClass("myIdClass");
        entity.addNamedNativeQuery(0);
        entity.addNamedQuery(0);
        this.javaPersistentType().setMappingKey("embeddable");
        JavaEntityTests.assertTrue((boolean)(this.javaPersistentType().getMapping() instanceof Embeddable));
        JavaEntityTests.assertNull((Object)typeResource.getMappingAnnotation("javax.persistence.Entity"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Table"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTable"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Inheritance"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorValue"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedQuery"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedNativeQuery"));
    }

    public void testMorphToNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = (Entity)this.javaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.addTableGenerator();
        entity.addSequenceGenerator();
        entity.setIdClass("myIdClass");
        entity.addNamedNativeQuery(0);
        entity.addNamedQuery(0);
        this.javaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaEntityTests.assertTrue((boolean)(this.javaPersistentType().getMapping() instanceof JavaNullTypeMapping));
        JavaEntityTests.assertNull((Object)typeResource.getMappingAnnotation("javax.persistence.Entity"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Table"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTable"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Inheritance"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorValue"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedQuery"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedNativeQuery"));
    }

    public void testAccessNoAnnotations() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)this.javaPersistentType().getAccess());
    }

    public void testAccessAnnotationsOnParent() throws Exception {
        this.createTestEntityAnnotationOnProperty();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        JavaPersistentType childPersistentType = this.javaPersistentType();
        PersistentType parentPersistentType = childPersistentType.getParentPersistentType();
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)parentPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        ((IdMapping)parentPersistentType.getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("FOO");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        ((JavaResourcePersistentAttribute)typeResource.properties().next()).setMappingAnnotation(null);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)parentPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        ((BasicMapping)parentPersistentType.getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName(null);
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)parentPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)childPersistentType.getAccess());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)parentPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        this.entityMappings().setSpecifiedAccess(AccessType.FIELD);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)parentPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.removeXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getJavaPersistentType().getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)childPersistentType.getAccess());
        OrmPersistentType childOrmPersistentType = this.entityMappings().addOrmPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.removeXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getJavaPersistentType().getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)childOrmPersistentType.getJavaPersistentType().getAccess());
    }

    public void testAccessWithXmlSettings() throws Exception {
        this.createTestEntityAnnotationOnProperty();
        this.addXmlClassRef("test.AnnotationTestType");
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.javaPersistentType().getAccess());
        ((IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("FOO");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        ((JavaResourcePersistentAttribute)typeResource.properties().next()).setMappingAnnotation(null);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.javaPersistentType().getAccess());
        ((BasicMapping)this.javaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName(null);
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)this.javaPersistentType().getAccess());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.javaPersistentType().getAccess());
        this.entityMappings().setSpecifiedAccess(AccessType.FIELD);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.javaPersistentType().getAccess());
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getJavaPersistentType().getAccess());
        ((OrmEntity)ormPersistentType.getMapping()).setSpecifiedAccess(AccessType.PROPERTY);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getJavaPersistentType().getAccess());
    }

    public void testGetSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.javaEntity().getSpecifiedName());
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)ENTITY_NAME, (String)this.javaEntity().getSpecifiedName());
    }

    public void testGetDefaultNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.javaEntity().getDefaultName());
    }

    public void testGetDefaultName() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.javaEntity().getDefaultName());
    }

    public void testGetNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.javaEntity().getName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)ENTITY_NAME, (String)this.javaEntity().getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().setSpecifiedName("foo");
        JavaEntityTests.assertEquals((String)"foo", (String)this.javaEntity().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"foo", (String)((EntityAnnotation)typeResource.getMappingAnnotation()).getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().setSpecifiedName(null);
        JavaEntityTests.assertNull((Object)this.javaEntity().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)((EntityAnnotation)typeResource.getMappingAnnotation()).getName());
    }

    public void testUpdateFromSpecifiedNameChangeInResourceModel() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        EntityAnnotation entity = (EntityAnnotation)typeResource.getMappingAnnotation();
        entity.setName("foo");
        JavaEntityTests.assertEquals((String)"foo", (String)this.javaEntity().getSpecifiedName());
    }

    public void testGetTableName() throws Exception {
        this.addXmlClassRef("test.AnnotationTestType");
        this.createTestEntityWithName();
        JavaEntityTests.assertEquals((String)ENTITY_NAME, (String)this.javaEntity().getTableName());
    }

    public void testGetTableName2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.javaEntity().getTableName());
    }

    public void testGetTableName3() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)TABLE_NAME, (String)this.javaEntity().getTableName());
    }

    public void testSetTableNameWithNullTable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Table table = this.javaEntity().getTable();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table.getName());
        this.assertSourceDoesNotContain("@Table", cu);
        table.setSpecifiedName(TABLE_NAME);
        this.assertSourceContains("@Table(name=\"MY_TABLE\")", cu);
        JavaEntityTests.assertEquals((String)TABLE_NAME, (String)this.javaEntity().getTableName());
        JavaEntityTests.assertEquals((String)TABLE_NAME, (String)table.getName());
        table.setSpecifiedCatalog(TABLE_NAME);
    }

    public void testGetInheritanceStrategy() throws Exception {
        this.createTestEntityWithInheritance();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.javaEntity().getInheritanceStrategy());
    }

    public void testGetDefaultInheritanceStrategy() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNotSame((Object)this.javaEntity(), (Object)this.javaEntity().getRootEntity());
        JavaEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)this.javaEntity().getDefaultInheritanceStrategy());
        this.javaEntity().getRootEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        JavaEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)this.javaEntity().getRootEntity().getDefaultInheritanceStrategy());
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.javaEntity().getDefaultInheritanceStrategy());
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.javaEntity().getInheritanceStrategy());
        JavaEntityTests.assertNull((Object)this.javaEntity().getSpecifiedInheritanceStrategy());
    }

    public void testGetSpecifiedInheritanceStrategy() throws Exception {
        this.createTestEntityWithInheritance();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.javaEntity().getSpecifiedInheritanceStrategy());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        InheritanceAnnotation inheritance = (InheritanceAnnotation)typeResource.getAnnotation("javax.persistence.Inheritance");
        inheritance.setStrategy(org.eclipse.jpt.core.resource.java.InheritanceType.JOINED);
        JavaEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)this.javaEntity().getSpecifiedInheritanceStrategy());
        inheritance.setStrategy(null);
        JavaEntityTests.assertNull((Object)this.javaEntity().getSpecifiedInheritanceStrategy());
    }

    public void testSetSpecifiedInheritanceStrategy() throws Exception {
        this.createTestEntityWithInheritance();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.javaEntity().getSpecifiedInheritanceStrategy());
        this.javaEntity().setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        JavaEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)this.javaEntity().getSpecifiedInheritanceStrategy());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        InheritanceAnnotation inheritance = (InheritanceAnnotation)typeResource.getAnnotation("javax.persistence.Inheritance");
        JavaEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.java.InheritanceType.JOINED, (Object)inheritance.getStrategy());
    }

    public void testGetDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)DISCRIMINATOR_VALUE, (String)this.javaEntity().getDiscriminatorValue());
    }

    public void testGetDefaultDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)this.javaEntity().getName(), (String)this.javaEntity().getDefaultDiscriminatorValue());
        this.javaEntity().getDiscriminatorColumn().setSpecifiedDiscriminatorType(DiscriminatorType.INTEGER);
        JavaEntityTests.assertNull((Object)this.javaEntity().getDefaultDiscriminatorValue());
    }

    public void testGetSpecifiedDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)DISCRIMINATOR_VALUE, (String)this.javaEntity().getSpecifiedDiscriminatorValue());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorValue");
        discriminatorValue.setValue("foo");
        JavaEntityTests.assertEquals((String)"foo", (String)this.javaEntity().getSpecifiedDiscriminatorValue());
        discriminatorValue.setValue(null);
        JavaEntityTests.assertNull((Object)this.javaEntity().getSpecifiedDiscriminatorValue());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorValue"));
    }

    public void testSetSpecifiedDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)DISCRIMINATOR_VALUE, (String)this.javaEntity().getSpecifiedDiscriminatorValue());
        this.javaEntity().setSpecifiedDiscriminatorValue("foo");
        JavaEntityTests.assertEquals((String)"foo", (String)this.javaEntity().getSpecifiedDiscriminatorValue());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorValue");
        JavaEntityTests.assertEquals((String)"foo", (String)discriminatorValue.getValue());
    }

    public void testSecondaryTables() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator secondaryTables = this.javaEntity().secondaryTables();
        JavaEntityTests.assertTrue((boolean)secondaryTables.hasNext());
        JavaEntityTests.assertEquals((String)"foo", (String)((JavaSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testSecondaryTablesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)entity.secondaryTablesSize());
        ((SecondaryTableAnnotation)typeResource.addAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("FOO");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAR");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(2, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)entity.secondaryTablesSize());
    }

    public void testSpecifiedSecondaryTables() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedSecondaryTables = this.javaEntity().specifiedSecondaryTables();
        JavaEntityTests.assertTrue((boolean)specifiedSecondaryTables.hasNext());
        JavaEntityTests.assertEquals((String)"foo", (String)((JavaSecondaryTable)specifiedSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"bar", (String)((JavaSecondaryTable)specifiedSecondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedSecondaryTables.hasNext());
    }

    public void testSpecifiedSecondaryTablesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)entity.specifiedSecondaryTablesSize());
        ((SecondaryTableAnnotation)typeResource.addAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("FOO");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAR");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(2, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)entity.specifiedSecondaryTablesSize());
    }

    public void testAddSpecifiedSecondaryTable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        this.javaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAR");
        this.javaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        Iterator secondaryTables = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testAddSpecifiedSecondaryTable2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        this.javaEntity().addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        this.javaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        Iterator secondaryTables = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testAddSpecifiedSecondaryTablePreservePkJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable specifiedSecondaryTable = this.javaEntity().addSpecifiedSecondaryTable(0);
        specifiedSecondaryTable.setSpecifiedName("FOO");
        specifiedSecondaryTable.setSpecifiedCatalog("CATALOG");
        specifiedSecondaryTable.setSpecifiedSchema("SCHEMA");
        specifiedSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("PK_NAME");
        SecondaryTable specifiedSecondaryTable2 = this.javaEntity().addSpecifiedSecondaryTable(1);
        specifiedSecondaryTable2.setSpecifiedName("BAR");
        Iterator secondaryTables = this.javaEntity().secondaryTables();
        SecondaryTable secondaryTable = (SecondaryTable)secondaryTables.next();
        JavaEntityTests.assertEquals((Object)secondaryTable, (Object)specifiedSecondaryTable);
        JavaEntityTests.assertEquals((String)"FOO", (String)secondaryTable.getName());
        JavaEntityTests.assertEquals((String)"CATALOG", (String)secondaryTable.getCatalog());
        JavaEntityTests.assertEquals((String)"SCHEMA", (String)secondaryTable.getSchema());
        JavaEntityTests.assertEquals((int)1, (int)secondaryTable.specifiedPrimaryKeyJoinColumnsSize());
        PrimaryKeyJoinColumn pkJoinColumn = (PrimaryKeyJoinColumn)secondaryTable.specifiedPrimaryKeyJoinColumns().next();
        JavaEntityTests.assertEquals((String)"PK_NAME", (String)pkJoinColumn.getName());
        secondaryTable = (SecondaryTable)secondaryTables.next();
        JavaEntityTests.assertEquals((Object)secondaryTable, (Object)specifiedSecondaryTable2);
        JavaEntityTests.assertEquals((String)"BAR", (String)secondaryTable.getName());
        JavaEntityTests.assertEquals((int)0, (int)secondaryTable.specifiedPrimaryKeyJoinColumnsSize());
    }

    public void testRemoveSpecifiedSecondaryTable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        this.javaEntity().addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        this.javaEntity().addSpecifiedSecondaryTable(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
        this.javaEntity().removeSpecifiedSecondaryTable(1);
        Iterator secondaryTableResources = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTableResources.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)secondaryTableResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTableResources.hasNext());
        Iterator secondaryTables = this.javaEntity().secondaryTables();
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        this.javaEntity().removeSpecifiedSecondaryTable(1);
        secondaryTableResources = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTableResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTableResources.hasNext());
        secondaryTables = this.javaEntity().secondaryTables();
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        this.javaEntity().removeSpecifiedSecondaryTable(0);
        secondaryTableResources = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertFalse((boolean)secondaryTableResources.hasNext());
        secondaryTables = this.javaEntity().secondaryTables();
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTables"));
    }

    public void testMoveSpecifiedSecondaryTable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        entity.addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        entity.addSpecifiedSecondaryTable(2).setSpecifiedName("BAZ");
        ListIterator javaSecondaryTables = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaSecondaryTables));
        entity.moveSpecifiedSecondaryTable(2, 0);
        ListIterator secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        javaSecondaryTables = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        entity.moveSpecifiedSecondaryTable(0, 1);
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        javaSecondaryTables = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
    }

    public void testUpdateSpecifiedSecondaryTables() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("FOO");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAR");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(2, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAZ");
        ListIterator secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        typeResource.move(2, 0, "javax.persistence.SecondaryTables");
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        typeResource.move(0, 1, "javax.persistence.SecondaryTables");
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testAssociatedTables() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)this.javaEntity().associatedTables()));
        Iterator associatedTables = this.javaEntity().associatedTables();
        Table table1 = (Table)associatedTables.next();
        SecondaryTable table2 = (SecondaryTable)associatedTables.next();
        SecondaryTable table3 = (SecondaryTable)associatedTables.next();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table1.getName());
        JavaEntityTests.assertEquals((String)"foo", (String)table2.getName());
        JavaEntityTests.assertEquals((String)"bar", (String)table3.getName());
    }

    public void testAssociatedTablesIncludingInherited() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Entity parentEntity = this.javaEntity().getRootEntity();
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)parentEntity.associatedTablesIncludingInherited()));
        Iterator associatedTables = parentEntity.associatedTablesIncludingInherited();
        Table table1 = (Table)associatedTables.next();
        SecondaryTable table2 = (SecondaryTable)associatedTables.next();
        SecondaryTable table3 = (SecondaryTable)associatedTables.next();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table1.getName());
        JavaEntityTests.assertEquals((String)"foo", (String)table2.getName());
        JavaEntityTests.assertEquals((String)"bar", (String)table3.getName());
        Entity childEntity = this.javaEntity();
        JavaEntityTests.assertEquals((int)4, (int)CollectionTools.size((Iterator)childEntity.associatedTablesIncludingInherited()));
    }

    public void testAssociatedTableNamesIncludingInherited() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Entity parentEntity = this.javaEntity().getRootEntity();
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)parentEntity.associatedTableNamesIncludingInherited()));
        Iterator associatedTables = parentEntity.associatedTableNamesIncludingInherited();
        String table1 = (String)associatedTables.next();
        String table2 = (String)associatedTables.next();
        String table3 = (String)associatedTables.next();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table1);
        JavaEntityTests.assertEquals((String)"foo", (String)table2);
        JavaEntityTests.assertEquals((String)"bar", (String)table3);
        Entity childEntity = this.javaEntity();
        JavaEntityTests.assertEquals((int)4, (int)CollectionTools.size((Iterator)childEntity.associatedTableNamesIncludingInherited()));
    }

    public void testAddSecondaryTableToResourceModel() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)typeResource.addAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTable.setName("FOO");
        JavaEntityTests.assertEquals((int)1, (int)this.javaEntity().secondaryTablesSize());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)this.javaEntity().secondaryTables().next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)this.javaEntity().secondaryTables().next()).getName());
        SecondaryTableAnnotation secondaryTable2 = (SecondaryTableAnnotation)typeResource.addAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTable2.setName("BAR");
        JavaEntityTests.assertEquals((int)2, (int)this.javaEntity().secondaryTablesSize());
        ListIterator secondaryTables = this.javaEntity().secondaryTables();
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        SecondaryTableAnnotation secondaryTable3 = (SecondaryTableAnnotation)typeResource.addAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTable3.setName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)this.javaEntity().secondaryTablesSize());
        secondaryTables = this.javaEntity().secondaryTables();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
    }

    public void testRemoveSecondaryTableFromResourceModel() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().addSpecifiedSecondaryTable(2).setSpecifiedName("baz");
        ListIterator secondaryTables = this.javaEntity().secondaryTables();
        JavaEntityTests.assertEquals((int)3, (int)this.javaEntity().secondaryTablesSize());
        JavaEntityTests.assertEquals((String)"foo", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"bar", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"baz", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        typeResource.removeAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTables = this.javaEntity().secondaryTables();
        JavaEntityTests.assertEquals((int)2, (int)this.javaEntity().secondaryTablesSize());
        JavaEntityTests.assertEquals((String)"bar", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"baz", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        typeResource.removeAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTables = this.javaEntity().secondaryTables();
        JavaEntityTests.assertEquals((int)1, (int)this.javaEntity().secondaryTablesSize());
        JavaEntityTests.assertEquals((String)"baz", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        typeResource.removeAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTables = this.javaEntity().secondaryTables();
        JavaEntityTests.assertEquals((int)0, (int)this.javaEntity().secondaryTablesSize());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testGetSequenceGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.javaEntity().getSequenceGenerator());
        JavaEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)this.javaEntity().getPersistenceUnit().allGenerators()));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        typeResource.addAnnotation("javax.persistence.SequenceGenerator");
        JavaEntityTests.assertNotNull((Object)this.javaEntity().getSequenceGenerator());
        JavaEntityTests.assertEquals((int)1, (int)typeResource.annotationsSize());
        JavaEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.javaEntity().getPersistenceUnit().allGenerators()));
        this.javaEntity().getSequenceGenerator().setName("foo");
        JavaEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.javaEntity().getPersistenceUnit().allGenerators()));
    }

    public void testAddSequenceGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.javaEntity().getSequenceGenerator());
        this.javaEntity().addSequenceGenerator();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNotNull((Object)this.javaEntity().getSequenceGenerator());
        try {
            this.javaEntity().addSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveSequenceGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        typeResource.addAnnotation("javax.persistence.SequenceGenerator");
        this.javaEntity().removeSequenceGenerator();
        JavaEntityTests.assertNull((Object)this.javaEntity().getSequenceGenerator());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        try {
            this.javaEntity().removeSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetTableGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.javaEntity().getTableGenerator());
        JavaEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)this.javaEntity().getPersistenceUnit().allGenerators()));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        typeResource.addAnnotation("javax.persistence.TableGenerator");
        JavaEntityTests.assertNotNull((Object)this.javaEntity().getTableGenerator());
        JavaEntityTests.assertEquals((int)1, (int)typeResource.annotationsSize());
        JavaEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.javaEntity().getPersistenceUnit().allGenerators()));
        this.javaEntity().getTableGenerator().setName("foo");
        JavaEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.javaEntity().getPersistenceUnit().allGenerators()));
    }

    public void testAddTableGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.javaEntity().getTableGenerator());
        this.javaEntity().addTableGenerator();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNotNull((Object)this.javaEntity().getTableGenerator());
        try {
            this.javaEntity().addTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveTableGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        typeResource.addAnnotation("javax.persistence.TableGenerator");
        this.javaEntity().removeTableGenerator();
        JavaEntityTests.assertNull((Object)this.javaEntity().getTableGenerator());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.TableGenerator"));
        try {
            this.javaEntity().removeTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetDiscriminatorColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNotNull((Object)this.javaEntity().getDiscriminatorColumn());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.addAnnotation("javax.persistence.DiscriminatorColumn");
        column.setName("foo");
        JavaEntityTests.assertEquals((String)"foo", (String)this.javaEntity().getDiscriminatorColumn().getSpecifiedName());
        column.setName(null);
        JavaEntityTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedName());
        typeResource.removeAnnotation("javax.persistence.DiscriminatorColumn");
        JavaEntityTests.assertNotNull((Object)this.javaEntity().getDiscriminatorColumn());
    }

    public void testSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedPkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        PrimaryKeyJoinColumnAnnotation pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        pkJoinColumn.setName("FOO");
        specifiedPkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        pkJoinColumn.setName("BAR");
        specifiedPkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        pkJoinColumn.setName("BAZ");
        specifiedPkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        typeResource.move(1, 0, "javax.persistence.PrimaryKeyJoinColumns");
        specifiedPkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        specifiedPkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        specifiedPkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        specifiedPkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
    }

    public void testSpecifiedPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)this.javaEntity().specifiedPrimaryKeyJoinColumnsSize());
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)this.javaEntity().specifiedPrimaryKeyJoinColumnsSize());
    }

    public void testPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)1, (int)this.javaEntity().primaryKeyJoinColumnsSize());
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)this.javaEntity().primaryKeyJoinColumnsSize());
    }

    public void testGetDefaultPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNotNull((Object)this.javaEntity().getDefaultPrimaryKeyJoinColumn());
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaEntityTests.assertNull((Object)this.javaEntity().getDefaultPrimaryKeyJoinColumn());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        Iterator pkJoinColumns = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        Iterator pkJoinColumns = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
    }

    public void testRemoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")));
        this.javaEntity().removeSpecifiedPrimaryKeyJoinColumn(1);
        Iterator pkJoinColumnResources = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        Iterator pkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
        this.javaEntity().removeSpecifiedPrimaryKeyJoinColumn(1);
        pkJoinColumnResources = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        pkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
        this.javaEntity().removeSpecifiedPrimaryKeyJoinColumn(0);
        pkJoinColumnResources = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        pkJoinColumns = this.javaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumns"));
    }

    public void testMoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        entity.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        entity.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        entity.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        ListIterator javaPrimaryKeyJoinColumns = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaPrimaryKeyJoinColumns));
        entity.moveSpecifiedPrimaryKeyJoinColumn(2, 0);
        ListIterator primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaPrimaryKeyJoinColumns = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        entity.moveSpecifiedPrimaryKeyJoinColumn(0, 1);
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaPrimaryKeyJoinColumns = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
    }

    public void testUpdateSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        ((PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")).setName("FOO");
        ((PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")).setName("BAR");
        ((PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(2, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")).setName("BAZ");
        ListIterator primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        typeResource.move(2, 0, "javax.persistence.PrimaryKeyJoinColumns");
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        typeResource.move(0, 1, "javax.persistence.PrimaryKeyJoinColumns");
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
    }

    public void testPrimaryKeyJoinColumnIsVirtual() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertTrue((boolean)this.javaEntity().getDefaultPrimaryKeyJoinColumn().isVirtual());
        this.javaEntity().addSpecifiedPrimaryKeyJoinColumn(0);
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumn.isVirtual());
        JavaEntityTests.assertNull((Object)this.javaEntity().getDefaultPrimaryKeyJoinColumn());
    }

    public void testTableNameIsInvalid() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertFalse((boolean)this.javaEntity().tableNameIsInvalid("AnnotationTestType"));
        JavaEntityTests.assertTrue((boolean)this.javaEntity().tableNameIsInvalid("FOO"));
        this.javaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAR");
        JavaEntityTests.assertFalse((boolean)this.javaEntity().tableNameIsInvalid("BAR"));
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = (Entity)this.javaPersistentType().getMapping();
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basic"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("id"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embedded"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embeddedId"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("version"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transient"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToOne"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToOne"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToMany"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToMany"));
    }

    public void testOverridableAttributes() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.javaEntity().overridableAttributes();
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.javaEntity().overridableAttributeNames();
        JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testAllOverridableAttributes() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.javaEntity().allOverridableAttributes();
        JavaEntityTests.assertEquals((String)"id", (String)((PersistentAttribute)overridableAttributes.next()).getName());
        JavaEntityTests.assertEquals((String)"name", (String)((PersistentAttribute)overridableAttributes.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((PersistentAttribute)overridableAttributes.next()).getName());
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributesMappedSuperclassInOrmXml() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.entityMappings().addOrmPersistentType("mappedSuperclass", "test.AnnotationTestType");
        Iterator overridableAttributes = this.javaEntity().allOverridableAttributes();
        JavaEntityTests.assertEquals((String)"id", (String)((PersistentAttribute)overridableAttributes.next()).getName());
        JavaEntityTests.assertEquals((String)"name", (String)((PersistentAttribute)overridableAttributes.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((PersistentAttribute)overridableAttributes.next()).getName());
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributeNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.javaEntity().allOverridableAttributeNames();
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedAttributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        specifiedAttributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        specifiedAttributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAZ");
        specifiedAttributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.move(1, 0, "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testDefaultAttributeOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEntityTests.assertEquals((int)3, (int)javaEntity.virtualAttributeOverridesSize());
        AttributeOverride virtualAttributeOverride = (AttributeOverride)javaEntity.virtualAttributeOverrides().next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.javaPersistentType().getMapping();
        BasicMapping idMapping = (BasicMapping)mappedSuperclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTable("BAR");
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEntityTests.assertEquals((int)3, (int)javaEntity.virtualAttributeOverridesSize());
        virtualAttributeOverride = (AttributeOverride)javaEntity.virtualAttributeOverrides().next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTable());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTable(null);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        virtualAttributeOverride = (AttributeOverride)javaEntity.virtualAttributeOverrides().next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = virtualAttributeOverride.setVirtual(false);
        JavaEntityTests.assertEquals((int)2, (int)javaEntity.virtualAttributeOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)this.javaEntity().specifiedAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        JavaEntityTests.assertEquals((int)2, (int)this.javaEntity().specifiedAttributeOverridesSize());
    }

    public void testDefaultAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Entity javaEntity = this.javaEntity();
        JavaEntityTests.assertEquals((int)3, (int)javaEntity.virtualAttributeOverridesSize());
        ((AttributeOverride)javaEntity.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)2, (int)javaEntity.virtualAttributeOverridesSize());
        ((AttributeOverride)javaEntity.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)1, (int)javaEntity.virtualAttributeOverridesSize());
        ((AttributeOverride)javaEntity.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)0, (int)javaEntity.virtualAttributeOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Entity javaEntity = this.javaEntity();
        JavaEntityTests.assertEquals((int)3, (int)javaEntity.attributeOverridesSize());
        ((AttributeOverride)javaEntity.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)3, (int)javaEntity.attributeOverridesSize());
        ((AttributeOverride)javaEntity.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)3, (int)javaEntity.attributeOverridesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("bar");
        JavaEntityTests.assertEquals((int)4, (int)javaEntity.attributeOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ((AttributeOverride)this.javaEntity().virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)this.javaEntity().virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator attributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator virtualAttributeOverrides = this.javaEntity().virtualAttributeOverrides();
        virtualAttributeOverrides.next();
        ((JavaAttributeOverride)virtualAttributeOverrides.next()).setVirtual(false);
        ((AttributeOverride)this.javaEntity().virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator attributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ((AttributeOverride)this.javaEntity().virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)this.javaEntity().virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)this.javaEntity().virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
        ((AttributeOverride)this.javaEntity().specifiedAttributeOverrides().next()).setVirtual(true);
        Iterator attributeOverrideResources = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        Iterator attributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)this.javaEntity().specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrideResources = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)this.javaEntity().specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrideResources = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = this.javaEntity().specifiedAttributeOverrides();
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        ((AttributeOverride)this.javaEntity().virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)this.javaEntity().virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)this.javaEntity().virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator javaAttributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaAttributeOverrides));
        entity.moveSpecifiedAttributeOverride(2, 0);
        ListIterator attributeOverrides = entity.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        entity.moveSpecifiedAttributeOverride(0, 1);
        attributeOverrides = entity.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        ((AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")).setName("FOO");
        ((AttributeOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")).setName("BAR");
        ((AttributeOverrideAnnotation)typeResource.addAnnotation(2, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")).setName("BAZ");
        ListIterator attributeOverrides = entity.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.move(2, 0, "javax.persistence.AttributeOverrides");
        attributeOverrides = entity.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.move(0, 1, "javax.persistence.AttributeOverrides");
        attributeOverrides = entity.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverrides = entity.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverrides = entity.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverrides = entity.specifiedAttributeOverrides();
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator virtualAttributeOverrides = this.javaEntity().virtualAttributeOverrides();
        AttributeOverride virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
        ((AttributeOverride)this.javaEntity().virtualAttributeOverrides().next()).setVirtual(false);
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)this.javaEntity().specifiedAttributeOverrides().next();
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverride.isVirtual());
        virtualAttributeOverrides = this.javaEntity().virtualAttributeOverrides();
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
    }

    public void testOverridableAssociations() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.javaEntity().overridableAssociations();
        JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testOverridableAssociationNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.javaEntity().overridableAssociationNames();
        JavaEntityTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociationNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.javaEntity().allOverridableAssociationNames();
        JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociationNames.next()));
        JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociationNames.next()));
        JavaEntityTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociations() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.javaEntity().allOverridableAssociations();
        JavaEntityTests.assertEquals((String)"address", (String)((PersistentAttribute)overridableAssociations.next()).getName());
        JavaEntityTests.assertEquals((String)"address2", (String)((PersistentAttribute)overridableAssociations.next()).getName());
        JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testAllOverridableAssociationsMappedSuperclassInOrmXml() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.entityMappings().addOrmPersistentType("mappedSuperclass", "test.AnnotationTestType");
        Iterator overridableAssociations = this.javaEntity().allOverridableAssociations();
        JavaEntityTests.assertEquals((String)"address", (String)((PersistentAttribute)overridableAssociations.next()).getName());
        JavaEntityTests.assertEquals((String)"address2", (String)((PersistentAttribute)overridableAssociations.next()).getName());
        JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedAssociationOverrides = this.javaEntity().specifiedAssociationOverrides();
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("FOO");
        specifiedAssociationOverrides = this.javaEntity().specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        specifiedAssociationOverrides = this.javaEntity().specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAZ");
        specifiedAssociationOverrides = this.javaEntity().specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.move(1, 0, "javax.persistence.AssociationOverrides");
        specifiedAssociationOverrides = this.javaEntity().specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        specifiedAssociationOverrides = this.javaEntity().specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        specifiedAssociationOverrides = this.javaEntity().specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        specifiedAssociationOverrides = this.javaEntity().specifiedAssociationOverrides();
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testDefaultAssociationOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        JavaEntityTests.assertEquals((int)2, (int)javaEntity.virtualAssociationOverridesSize());
        AssociationOverride virtualAssociationOverride = (AssociationOverride)javaEntity.virtualAssociationOverrides().next();
        JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        JavaEntityTests.assertEquals((int)2, (int)javaEntity.virtualAssociationOverridesSize());
        virtualAssociationOverride = (AssociationOverride)javaEntity.virtualAssociationOverrides().next();
        JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        virtualAssociationOverride = (AssociationOverride)javaEntity.virtualAssociationOverrides().next();
        JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride = virtualAssociationOverride.setVirtual(false);
        JavaEntityTests.assertEquals((int)1, (int)javaEntity.virtualAssociationOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)this.javaEntity().specifiedAssociationOverridesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("FOO");
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        JavaEntityTests.assertEquals((int)2, (int)this.javaEntity().specifiedAssociationOverridesSize());
    }

    public void testDefaultAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Entity javaEntity = this.javaEntity();
        JavaEntityTests.assertEquals((int)2, (int)javaEntity.virtualAssociationOverridesSize());
        ((AssociationOverride)javaEntity.virtualAssociationOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)1, (int)javaEntity.virtualAssociationOverridesSize());
        ((AssociationOverride)javaEntity.virtualAssociationOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)0, (int)javaEntity.virtualAssociationOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Entity javaEntity = this.javaEntity();
        JavaEntityTests.assertEquals((int)2, (int)javaEntity.associationOverridesSize());
        ((AssociationOverride)javaEntity.virtualAssociationOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)2, (int)javaEntity.associationOverridesSize());
        ((AssociationOverride)javaEntity.virtualAssociationOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)2, (int)javaEntity.associationOverridesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        AssociationOverrideAnnotation annotation = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        annotation.setName("bar");
        JavaEntityTests.assertEquals((int)3, (int)javaEntity.associationOverridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ((AssociationOverride)this.javaEntity().virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)this.javaEntity().virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator associationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator virtualAssociationOverrides = this.javaEntity().virtualAssociationOverrides();
        virtualAssociationOverrides.next();
        ((JavaAssociationOverride)virtualAssociationOverrides.next()).setVirtual(false);
        ((AssociationOverride)this.javaEntity().virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator associationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ((AssociationOverride)this.javaEntity().virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)this.javaEntity().virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")));
        ((AssociationOverride)this.javaEntity().specifiedAssociationOverrides().next()).setVirtual(true);
        Iterator associationOverrideResources = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrideResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrideResources.hasNext());
        Iterator associationOverrides = this.javaEntity().specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        ((AssociationOverride)this.javaEntity().specifiedAssociationOverrides().next()).setVirtual(true);
        associationOverrideResources = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertFalse((boolean)associationOverrideResources.hasNext());
        associationOverrides = this.javaEntity().specifiedAssociationOverrides();
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        ((AssociationOverride)this.javaEntity().virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)this.javaEntity().virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator javaAssociationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)javaAssociationOverrides));
        entity.moveSpecifiedAssociationOverride(1, 0);
        ListIterator associationOverrides = entity.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        entity.moveSpecifiedAssociationOverride(0, 1);
        associationOverrides = entity.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        ((AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("FOO");
        ((AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("BAR");
        ((AssociationOverrideAnnotation)typeResource.addAnnotation(2, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("BAZ");
        ListIterator associationOverrides = entity.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.move(2, 0, "javax.persistence.AssociationOverrides");
        associationOverrides = entity.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.move(0, 1, "javax.persistence.AssociationOverrides");
        associationOverrides = entity.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverrides = entity.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverrides = entity.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverrides = entity.specifiedAssociationOverrides();
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator virtualAssociationOverrides = this.javaEntity().virtualAssociationOverrides();
        AssociationOverride virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        JavaEntityTests.assertEquals((String)"address2", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((AssociationOverride)this.javaEntity().virtualAssociationOverrides().next()).setVirtual(false);
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)this.javaEntity().specifiedAssociationOverrides().next();
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = this.javaEntity().virtualAssociationOverrides();
        virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        JavaEntityTests.assertEquals((String)"address2", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testAddNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        NamedQuery namedQuery = entity.addNamedQuery(0);
        namedQuery.setName("FOO");
        ListIterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        NamedQuery namedQuery2 = entity.addNamedQuery(0);
        namedQuery2.setName("BAR");
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        NamedQuery namedQuery3 = entity.addNamedQuery(1);
        namedQuery3.setName("BAZ");
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        ListIterator namedQueries = entity.namedQueries();
        JavaEntityTests.assertEquals((Object)namedQuery2, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedQuery3, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedQuery, namedQueries.next());
        namedQueries = entity.namedQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQuery)namedQueries.next()).getName());
        entity.addNamedNativeQuery(0).setName("foo");
    }

    public void testRemoveNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        entity.addNamedQuery(0).setName("FOO");
        entity.addNamedQuery(1).setName("BAR");
        entity.addNamedQuery(2).setName("BAZ");
        ListIterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaNamedQueries));
        entity.removeNamedQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        entity.removeNamedQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        entity.removeNamedQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)javaNamedQueries));
    }

    public void testAddNamedNativeQueryWithNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        entity.addNamedQuery(0).setName("FOO");
        NamedNativeQueryAnnotation nativeQuery = (NamedNativeQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        nativeQuery.setName("BAR");
        JavaEntityTests.assertEquals((int)1, (int)entity.namedNativeQueriesSize());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQuery)entity.namedNativeQueries().next()).getName());
    }

    public void testAddNamedQueryWithNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        entity.addNamedNativeQuery(0).setName("FOO");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQuery.setName("BAR");
        JavaEntityTests.assertEquals((int)1, (int)entity.namedQueriesSize());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQuery)entity.namedQueries().next()).getName());
    }

    public void testMoveNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        entity.addNamedQuery(0).setName("FOO");
        entity.addNamedQuery(1).setName("BAR");
        entity.addNamedQuery(2).setName("BAZ");
        ListIterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaNamedQueries));
        entity.moveNamedQuery(2, 0);
        ListIterator namedQueries = entity.namedQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQuery)namedQueries.next()).getName());
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        entity.moveNamedQuery(0, 1);
        namedQueries = entity.namedQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQuery)namedQueries.next()).getName());
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
    }

    public void testUpdateNamedQueries() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)entity.getPersistenceUnit().allQueries()));
        ((NamedQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("FOO");
        ((NamedQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("BAR");
        ((NamedQueryAnnotation)typeResource.addAnnotation(2, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("BAZ");
        ListIterator namedQueries = entity.namedQueries();
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)entity.getPersistenceUnit().allQueries()));
        typeResource.move(2, 0, "javax.persistence.NamedQueries");
        namedQueries = entity.namedQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        typeResource.move(0, 1, "javax.persistence.NamedQueries");
        namedQueries = entity.namedQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQueries = entity.namedQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)entity.getPersistenceUnit().allQueries()));
        typeResource.removeAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQueries = entity.namedQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)entity.getPersistenceUnit().allQueries()));
        typeResource.removeAnnotation(0, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQueries = entity.namedQueries();
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)entity.getPersistenceUnit().allQueries()));
    }

    public void testNamedQueriesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)entity.namedQueriesSize());
        ((NamedQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("FOO");
        ((NamedQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("BAR");
        ((NamedQueryAnnotation)typeResource.addAnnotation(2, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)entity.namedQueriesSize());
    }

    public void testAddNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        NamedNativeQuery namedNativeQuery = entity.addNamedNativeQuery(0);
        namedNativeQuery.setName("FOO");
        ListIterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        NamedNativeQuery namedNativeQuery2 = entity.addNamedNativeQuery(0);
        namedNativeQuery2.setName("BAR");
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        NamedNativeQuery namedNativeQuery3 = entity.addNamedNativeQuery(1);
        namedNativeQuery3.setName("BAZ");
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        ListIterator namedQueries = entity.namedNativeQueries();
        JavaEntityTests.assertEquals((Object)namedNativeQuery2, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedNativeQuery3, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedNativeQuery, namedQueries.next());
        namedQueries = entity.namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQuery)namedQueries.next()).getName());
    }

    public void testRemoveNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        entity.addNamedNativeQuery(0).setName("FOO");
        entity.addNamedNativeQuery(1).setName("BAR");
        entity.addNamedNativeQuery(2).setName("BAZ");
        ListIterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaNamedQueries));
        entity.removeNamedNativeQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        entity.removeNamedNativeQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        entity.removeNamedNativeQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)javaNamedQueries));
    }

    public void testMoveNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        entity.addNamedNativeQuery(0).setName("FOO");
        entity.addNamedNativeQuery(1).setName("BAR");
        entity.addNamedNativeQuery(2).setName("BAZ");
        ListIterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaNamedQueries));
        entity.moveNamedNativeQuery(2, 0);
        ListIterator namedQueries = entity.namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQuery)namedQueries.next()).getName());
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        entity.moveNamedNativeQuery(0, 1);
        namedQueries = entity.namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQuery)namedQueries.next()).getName());
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
    }

    public void testUpdateNamedNativeQueries() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)entity.getPersistenceUnit().allQueries()));
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("FOO");
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("BAR");
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(2, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("BAZ");
        ListIterator namedQueries = entity.namedNativeQueries();
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)entity.getPersistenceUnit().allQueries()));
        typeResource.move(2, 0, "javax.persistence.NamedNativeQueries");
        namedQueries = entity.namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        typeResource.move(0, 1, "javax.persistence.NamedNativeQueries");
        namedQueries = entity.namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        namedQueries = entity.namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)entity.getPersistenceUnit().allQueries()));
        typeResource.removeAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        namedQueries = entity.namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)entity.getPersistenceUnit().allQueries()));
        typeResource.removeAnnotation(0, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        namedQueries = entity.namedNativeQueries();
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)entity.getPersistenceUnit().allQueries()));
    }

    public void testNamedNativeQueriesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)entity.namedNativeQueriesSize());
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("FOO");
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("BAR");
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(2, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)entity.namedNativeQueriesSize());
    }

    public void testUpdateIdClass() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.javaEntity().getIdClass());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        IdClassAnnotation idClass = (IdClassAnnotation)typeResource.addAnnotation("javax.persistence.IdClass");
        JavaEntityTests.assertNull((Object)this.javaEntity().getIdClass());
        JavaEntityTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        idClass.setValue("model.Foo");
        JavaEntityTests.assertEquals((String)"model.Foo", (String)this.javaEntity().getIdClass());
        JavaEntityTests.assertEquals((String)"model.Foo", (String)((IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass")).getValue());
        idClass.setValue(null);
        JavaEntityTests.assertNull((Object)this.javaEntity().getIdClass());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        idClass = (IdClassAnnotation)typeResource.addAnnotation("javax.persistence.IdClass");
        idClass.setValue("model.Foo");
        typeResource.removeAnnotation("javax.persistence.IdClass");
        JavaEntityTests.assertNull((Object)this.javaEntity().getIdClass());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
    }

    public void testModifyIdClass() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.javaEntity().getIdClass());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        this.javaEntity().setIdClass("model.Foo");
        JavaEntityTests.assertEquals((String)"model.Foo", (String)((IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaEntityTests.assertEquals((String)"model.Foo", (String)this.javaEntity().getIdClass());
        this.javaEntity().setIdClass(null);
        JavaEntityTests.assertNull((Object)this.javaEntity().getIdClass());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
    }

    public void testGetPrimaryKeyColumnNameWithAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        JavaPersistentType entityPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaEntity javaEntity = (JavaEntity)entityPersistentType.getMapping();
        JavaPersistentType mappedSuperclassPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaEntityTests.assertNull((Object)javaEntity.getPrimaryKeyColumnName());
        mappedSuperclassPersistentType.getAttributeNamed("id").setSpecifiedMappingKey("id");
        JavaEntityTests.assertEquals((String)"id", (String)javaEntity.getPrimaryKeyColumnName());
        ((JavaIdMapping)mappedSuperclassPersistentType.getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("MY_ID");
        JavaEntityTests.assertEquals((String)"MY_ID", (String)javaEntity.getPrimaryKeyColumnName());
        JavaAttributeOverride javaAttributeOverride = (JavaAttributeOverride)javaEntity.virtualAttributeOverrides().next();
        JavaEntityTests.assertEquals((String)"id", (String)javaAttributeOverride.getName());
        javaAttributeOverride = (JavaAttributeOverride)javaAttributeOverride.setVirtual(false);
        javaAttributeOverride.getColumn().setSpecifiedName("ID");
        JavaEntityTests.assertEquals((String)"ID", (String)javaEntity.getPrimaryKeyColumnName());
    }

    public void testDiscriminatorValueIsAllowedConcreteClass() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertTrue((boolean)this.javaEntity().isDiscriminatorValueAllowed());
    }

    public void testDiscriminatorValueIsAllowedAbstractClass() throws Exception {
        this.createTestAbstractEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertFalse((boolean)this.javaEntity().isDiscriminatorValueAllowed());
    }
}

