/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.resource.java.EmbeddableAnnotation;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaPersistentTypeTests
extends ContextModelTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private ICompilationUnit createTestEntity() throws Exception {
        this.createEntityAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedField() throws Exception {
        this.createEntityAnnotation();
        this.createAnnotationAndMembers("Id", "");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedMethod() throws Exception {
        this.createEntityAnnotation();
        this.createAnnotationAndMembers("Id", "");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedFieldAndMethod() throws Exception {
        this.createEntityAnnotation();
        this.createAnnotationAndMembers("Id", "");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestSubType() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestSubTypeWithFieldAnnotation() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestSubTypeWithMethodAnnotation() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestSubTypeNonPersistent() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }
        });
    }

    private ICompilationUnit createTestSubTypePersistentExtendsNonPersistent() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild2.java", "AnnotationTestTypeChild2", new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestTypeChild ");
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public JavaPersistentTypeTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestType", (String)this.javaPersistentType().getName());
    }

    public void testGetAccessNothingAnnotated() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)this.javaPersistentType().getAccess());
    }

    public void testAccessField() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)this.javaPersistentType().getAccess());
    }

    public void testAccessProperty() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.javaPersistentType().getAccess());
    }

    public void testAccessFieldAndMethodAnnotated() throws Exception {
        this.createTestEntityAnnotatedFieldAndMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)this.javaPersistentType().getAccess());
    }

    public void testAccessInheritance() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        JavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        JavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritance2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        JavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritance3() throws Exception {
        this.createTestEntityAnnotatedField();
        this.createTestSubTypeWithMethodAnnotation();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        JavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        JavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritance4() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeWithFieldAnnotation();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        JavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritancePersistenceUnitDefaultAccess() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.FIELD);
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        JavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        JavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlNoAccessNoAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntity();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityAccessNoAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntity();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        entityPersistentType.getMapping().setSpecifiedAccess(AccessType.FIELD);
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        entityPersistentType.getMapping().setSpecifiedAccess(AccessType.PROPERTY);
        JavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlPersistenceUnitDefaultsAccessNoAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntity();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.FIELD);
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        JavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityPropertyAccessAndFieldAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedField();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        entityPersistentType.getMapping().setSpecifiedAccess(AccessType.PROPERTY);
        JavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityFieldAccessAndPropertyAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedMethod();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        entityPersistentType.getMapping().setSpecifiedAccess(AccessType.FIELD);
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlPersistenceUnitDefaultsAccessFieldAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedField();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityMappingsAccessWithInheritance() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType childEntityPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestTypeChild");
        this.createTestEntityAnnotatedMethod();
        this.createTestSubType();
        JavaPersistentType childJavaPersistentType = childEntityPersistentType.getJavaPersistentType();
        this.entityMappings().setSpecifiedAccess(AccessType.FIELD);
        JavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)entityPersistentType.getJavaPersistentType().getAccess());
        JavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)childJavaPersistentType.getAccess());
    }

    public void testAccessXmlMetadataCompleteFieldAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedField();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        JavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessNoXmlAccessXmlMetdataCompletePropertyAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedMethod();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        JavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testParentPersistentType() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeWithFieldAnnotation();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType rootJavaPersistentType = classRef.getJavaPersistentType();
        classRef = (ClassRef)classRefs.next();
        JavaPersistentType childJavaPersistentType = classRef.getJavaPersistentType();
        JavaPersistentTypeTests.assertEquals((Object)rootJavaPersistentType, (Object)childJavaPersistentType.getParentPersistentType());
        JavaPersistentTypeTests.assertNull((Object)rootJavaPersistentType.getParentPersistentType());
    }

    public void testParentPersistentType2() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeWithFieldAnnotation();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        JavaPersistentType javaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaPersistentTypeTests.assertNotNull((Object)javaPersistentType.getParentPersistentType());
    }

    public void testParentPersistentType3() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeNonPersistent();
        this.createTestSubTypePersistentExtendsNonPersistent();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild2");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType rootJavaPersistentType = classRef.getJavaPersistentType();
        classRef = (ClassRef)classRefs.next();
        JavaPersistentType childJavaPersistentType = classRef.getJavaPersistentType();
        JavaPersistentTypeTests.assertEquals((Object)rootJavaPersistentType, (Object)childJavaPersistentType.getParentPersistentType());
        JavaPersistentTypeTests.assertNull((Object)rootJavaPersistentType.getParentPersistentType());
    }

    public void testInheritanceHierarchy() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeNonPersistent();
        this.createTestSubTypePersistentExtendsNonPersistent();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild2");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        JavaPersistentType rootJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaPersistentType childJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        Iterator inheritanceHierarchy = childJavaPersistentType.inheritanceHierarchy();
        JavaPersistentTypeTests.assertEquals((Object)childJavaPersistentType, inheritanceHierarchy.next());
        JavaPersistentTypeTests.assertEquals((Object)rootJavaPersistentType, inheritanceHierarchy.next());
    }

    public void testInheritanceHierarchy2() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeNonPersistent();
        this.createTestSubTypePersistentExtendsNonPersistent();
        this.addXmlClassRef("test.AnnotationTestTypeChild2");
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        JavaPersistentType childJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaPersistentType rootJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        Iterator inheritanceHierarchy = childJavaPersistentType.inheritanceHierarchy();
        JavaPersistentTypeTests.assertEquals((Object)childJavaPersistentType, inheritanceHierarchy.next());
        JavaPersistentTypeTests.assertEquals((Object)rootJavaPersistentType, inheritanceHierarchy.next());
    }

    public void testGetMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((String)"entity", (String)this.javaPersistentType().getMapping().getKey());
    }

    public void testGetMappingNull() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.javaPersistentType().getMapping().getKey());
    }

    public void testMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((String)"entity", (String)this.javaPersistentType().getMappingKey());
    }

    public void testMappingKeyNull() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.javaPersistentType().getMappingKey());
    }

    public void testSetMappingKey() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.javaPersistentType().getMappingKey());
        this.javaPersistentType().setMappingKey("entity");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaPersistentTypeTests.assertNotNull((Object)typeResource.getMappingAnnotation());
        JavaPersistentTypeTests.assertTrue((boolean)(typeResource.getMappingAnnotation() instanceof EntityAnnotation));
        JavaPersistentTypeTests.assertEquals((String)"entity", (String)this.javaPersistentType().getMappingKey());
    }

    public void testSetMappingKey2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((String)"entity", (String)this.javaPersistentType().getMappingKey());
        this.javaPersistentType().setMappingKey("embeddable");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaPersistentTypeTests.assertNotNull((Object)typeResource.getMappingAnnotation());
        JavaPersistentTypeTests.assertTrue((boolean)(typeResource.getMappingAnnotation() instanceof EmbeddableAnnotation));
        JavaPersistentTypeTests.assertEquals((String)"embeddable", (String)this.javaPersistentType().getMappingKey());
    }

    public void testSetMappingKeyNull() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((String)"entity", (String)this.javaPersistentType().getMappingKey());
        this.javaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaPersistentTypeTests.assertNull((Object)typeResource.getMappingAnnotation());
        JavaPersistentTypeTests.assertNull((Object)typeResource.getMappingAnnotation("javax.persistence.Entity"));
        JavaPersistentTypeTests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.javaPersistentType().getMappingKey());
    }

    public void testGetMappingKeyMappingChangeInResourceModel() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((String)"entity", (String)this.javaPersistentType().getMappingKey());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        typeResource.setMappingAnnotation("javax.persistence.Embeddable");
        JavaPersistentTypeTests.assertEquals((String)"embeddable", (String)this.javaPersistentType().getMappingKey());
    }

    public void testGetMappingKeyMappingChangeInResourceModel2() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.javaPersistentType().getMappingKey());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        typeResource.setMappingAnnotation("javax.persistence.Entity");
        JavaPersistentTypeTests.assertEquals((String)"entity", (String)this.javaPersistentType().getMappingKey());
    }

    public void testIsMapped() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertTrue((boolean)this.javaPersistentType().isMapped());
        this.javaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaPersistentTypeTests.assertFalse((boolean)this.javaPersistentType().isMapped());
    }

    public void testAttributes() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentTypeTests.assertEquals((String)"id", (String)((JavaPersistentAttribute)attributes.next()).getName());
        JavaPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
    }

    public void testAttributes2() throws Exception {
        this.createTestEntityAnnotatedFieldAndMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentTypeTests.assertEquals((String)"id", (String)((JavaPersistentAttribute)attributes.next()).getName());
        JavaPersistentTypeTests.assertEquals((String)"name", (String)((JavaPersistentAttribute)attributes.next()).getName());
        JavaPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
    }

    public void testAttributesSize() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((int)1, (int)this.javaPersistentType().attributesSize());
    }

    public void testAttributesSize2() throws Exception {
        this.createTestEntityAnnotatedFieldAndMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentTypeTests.assertEquals((int)2, (int)this.javaPersistentType().attributesSize());
    }

    public void testAttributeNamed() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute attribute = this.javaPersistentType().getAttributeNamed("id");
        JavaPersistentTypeTests.assertEquals((String)"id", (String)attribute.getName());
        JavaPersistentTypeTests.assertNull((Object)this.javaPersistentType().getAttributeNamed("name"));
        JavaPersistentTypeTests.assertNull((Object)this.javaPersistentType().getAttributeNamed("foo"));
    }

    public void testAttributeNamed2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute attribute = this.javaPersistentType().getAttributeNamed("name");
        JavaPersistentTypeTests.assertEquals((String)"name", (String)attribute.getName());
        JavaPersistentTypeTests.assertNull((Object)this.javaPersistentType().getAttributeNamed("foo"));
    }

    public void testParentPersistentTypeGeneric() throws Exception {
        this.createTestGenericEntity();
        this.createTestGenericMappedSuperclass();
        this.addXmlClassRef("test.Entity1");
        this.addXmlClassRef("test.Entity2");
        JavaPersistentType javaPersistentType = this.javaPersistentType();
        JavaPersistentTypeTests.assertEquals((String)"test.Entity1", (String)javaPersistentType.getName());
        JavaPersistentTypeTests.assertNotNull((Object)javaPersistentType.getParentPersistentType());
        JavaPersistentTypeTests.assertEquals((String)"test.Entity2", (String)javaPersistentType.getParentPersistentType().getName());
    }

    private void createTestGenericEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Entity1 ");
                sb.append("extends Entity2<Integer> {}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Entity1.java", sourceWriter);
    }

    private void createTestGenericMappedSuperclass() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class Entity2<K> {}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Entity2.java", sourceWriter);
    }
}

