/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.orm.OrmEmbeddable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmMappedSuperclass;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmMappedSuperclassTests
extends ContextModelTestCase {
    public OrmMappedSuperclassTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    public void testUpdateClass() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)mappedSuperclassResource.getClassName());
        mappedSuperclassResource.setClassName("com.Bar");
        OrmMappedSuperclassTests.assertEquals((String)"com.Bar", (String)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertEquals((String)"com.Bar", (String)mappedSuperclassResource.getClassName());
        mappedSuperclassResource.setClassName(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getClassName());
    }

    public void testModifyClass() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)mappedSuperclassResource.getClassName());
        ormMappedSuperclass.setClass("com.Bar");
        OrmMappedSuperclassTests.assertEquals((String)"com.Bar", (String)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertEquals((String)"com.Bar", (String)mappedSuperclassResource.getClassName());
        ormMappedSuperclass.setClass(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getClassName());
    }

    public void testUpdateSpecifiedAccess() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getAccess());
        mappedSuperclassResource.setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.FIELD, (Object)ormMappedSuperclass.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)mappedSuperclassResource.getAccess());
        mappedSuperclassResource.setAccess(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getAccess());
    }

    public void testModifySpecifiedAccess() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getAccess());
        ormMappedSuperclass.setSpecifiedAccess(AccessType.PROPERTY);
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormMappedSuperclass.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)mappedSuperclassResource.getAccess());
        ormMappedSuperclass.setSpecifiedAccess(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getAccess());
    }

    public void testUpdateSpecifiedMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        mappedSuperclassResource.setMetadataComplete(Boolean.valueOf(true));
        OrmMappedSuperclassTests.assertTrue((boolean)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertTrue((boolean)mappedSuperclassResource.getMetadataComplete());
        mappedSuperclassResource.setMetadataComplete(Boolean.valueOf(false));
        OrmMappedSuperclassTests.assertFalse((boolean)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertFalse((boolean)mappedSuperclassResource.getMetadataComplete());
        mappedSuperclassResource.setMetadataComplete(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
    }

    public void testModifySpecifiedMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        ormMappedSuperclass.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmMappedSuperclassTests.assertTrue((boolean)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertTrue((boolean)mappedSuperclassResource.getMetadataComplete());
        ormMappedSuperclass.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmMappedSuperclassTests.assertFalse((boolean)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertFalse((boolean)mappedSuperclassResource.getMetadataComplete());
        ormMappedSuperclass.setSpecifiedMetadataComplete(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
    }

    public void testUpdateDefaultMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertFalse((boolean)ormMappedSuperclass.isDefaultMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmMappedSuperclassTests.assertTrue((boolean)ormMappedSuperclass.isDefaultMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertFalse((boolean)ormMappedSuperclass.isDefaultMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
    }

    public void testUpdateMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertFalse((boolean)ormMappedSuperclass.isMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmMappedSuperclassTests.assertTrue((boolean)ormMappedSuperclass.isMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmMappedSuperclassTests.assertFalse((boolean)ormMappedSuperclass.isMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
    }

    public void testMakeMappedSuperclassEntity() throws Exception {
        OrmPersistentType mappedSuperclassPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass mappedSuperclass = (OrmMappedSuperclass)mappedSuperclassPersistentType.getMapping();
        mappedSuperclass.setSpecifiedAccess(AccessType.PROPERTY);
        mappedSuperclass.setSpecifiedMetadataComplete(Boolean.TRUE);
        mappedSuperclassPersistentType.setMappingKey("entity");
        XmlEntity entity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)entity.getClassName());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)entity.getAccess());
        OrmMappedSuperclassTests.assertNull((Object)entity.getDiscriminatorValue());
        OrmMappedSuperclassTests.assertNull((Object)entity.getName());
        OrmEntity ormEntity = (OrmEntity)mappedSuperclassPersistentType.getMapping();
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormEntity.getClass_());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)ormEntity.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormEntity.getSpecifiedAccess());
    }

    public void testMakeMappedSuperclassEntity2() throws Exception {
        OrmPersistentType mappedSuperclassPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo2");
        OrmMappedSuperclass mappedSuperclass = (OrmMappedSuperclass)mappedSuperclassPersistentType.getMapping();
        mappedSuperclass.setSpecifiedAccess(AccessType.PROPERTY);
        mappedSuperclass.setSpecifiedMetadataComplete(Boolean.TRUE);
        mappedSuperclassPersistentType.setMappingKey("entity");
        XmlEntity entity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)entity.getClassName());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)entity.getAccess());
        OrmMappedSuperclassTests.assertNull((Object)entity.getDiscriminatorValue());
        OrmMappedSuperclassTests.assertNull((Object)entity.getName());
        OrmEntity ormEntity = (OrmEntity)mappedSuperclassPersistentType.getMapping();
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormEntity.getClass_());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)ormEntity.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormEntity.getSpecifiedAccess());
        ListIterator persistentTypes = this.entityMappings().ormPersistentTypes();
        OrmMappedSuperclassTests.assertEquals((String)"mappedSuperclass", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
        OrmMappedSuperclassTests.assertEquals((String)"entity", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
    }

    public void testMakeMappedSuperclassEmbeddable() throws Exception {
        OrmPersistentType mappedSuperclassPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass mappedSuperclass = (OrmMappedSuperclass)mappedSuperclassPersistentType.getMapping();
        mappedSuperclass.setSpecifiedAccess(AccessType.PROPERTY);
        mappedSuperclass.setSpecifiedMetadataComplete(Boolean.TRUE);
        mappedSuperclassPersistentType.setMappingKey("embeddable");
        XmlEmbeddable embeddable = (XmlEmbeddable)this.ormResource().getEntityMappings().getEmbeddables().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)embeddable.getClassName());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)embeddable.getMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)embeddable.getAccess());
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)mappedSuperclassPersistentType.getMapping();
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormEmbeddable.getClass_());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormEmbeddable.getSpecifiedAccess());
    }

    public void testMakeMappedSuperclassEmbeddable2() throws Exception {
        OrmPersistentType mappedSuperclassPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo2");
        OrmMappedSuperclass mappedSuperclass = (OrmMappedSuperclass)mappedSuperclassPersistentType.getMapping();
        mappedSuperclass.setSpecifiedAccess(AccessType.PROPERTY);
        mappedSuperclass.setSpecifiedMetadataComplete(Boolean.TRUE);
        mappedSuperclassPersistentType.setMappingKey("embeddable");
        XmlEmbeddable embeddable = (XmlEmbeddable)this.ormResource().getEntityMappings().getEmbeddables().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)embeddable.getClassName());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)embeddable.getMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)embeddable.getAccess());
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)mappedSuperclassPersistentType.getMapping();
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormEmbeddable.getClass_());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormEmbeddable.getSpecifiedAccess());
        ListIterator persistentTypes = this.entityMappings().ormPersistentTypes();
        OrmMappedSuperclassTests.assertEquals((String)"mappedSuperclass", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
        OrmMappedSuperclassTests.assertEquals((String)"embeddable", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
    }

    public void testUpdateIdClass() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getIdClass());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getIdClass());
        mappedSuperclassResource.setIdClass(OrmFactory.eINSTANCE.createXmlIdClass());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getIdClass());
        OrmMappedSuperclassTests.assertNotNull((Object)mappedSuperclassResource.getIdClass());
        mappedSuperclassResource.getIdClass().setClassName("model.Foo");
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormMappedSuperclass.getIdClass());
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)mappedSuperclassResource.getIdClass().getClassName());
        mappedSuperclassResource.getIdClass().setClassName(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getIdClass());
        OrmMappedSuperclassTests.assertNotNull((Object)mappedSuperclassResource.getIdClass());
        mappedSuperclassResource.setIdClass(OrmFactory.eINSTANCE.createXmlIdClass());
        mappedSuperclassResource.getIdClass().setClassName("model.Foo");
        mappedSuperclassResource.setIdClass(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getIdClass());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getIdClass());
    }

    public void testModifyIdClass() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getIdClass());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getIdClass());
        ormMappedSuperclass.setIdClass("model.Foo");
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)mappedSuperclassResource.getIdClass().getClassName());
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormMappedSuperclass.getIdClass());
        ormMappedSuperclass.setIdClass(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getIdClass());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getIdClass());
    }
}

