/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.core.resource.orm.TemporalType;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlVersion;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmVersionMappingTests
extends ContextModelTestCase {
    public OrmVersionMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createVersionAnnotation() throws Exception {
        this.createAnnotationAndMembers("Version", "");
    }

    private void createColumnAnnotation() throws Exception {
        this.createAnnotationAndMembers("Column", "String name() default \"\";boolean unique() default false;boolean nullable() default true;boolean insertable() default true;boolean updatable() default true;String columnDefinition() default \"\";String table() default \"\";int length() default 255;int precision() default 0;int scale() default 0;");
    }

    private void createTemporalAnnotation() throws Exception {
        this.createAnnotationAndMembers("Temporal", "TemporalType value();");
    }

    private ICompilationUnit createTestEntityVersionMapping() throws Exception {
        this.createEntityAnnotation();
        this.createVersionAnnotation();
        this.createColumnAnnotation();
        this.createTemporalAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "javax.persistence.Column", "javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version");
                sb.append(CR);
                sb.append("    @Column(name=\"MY_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\", length=5, precision=6, scale=7)");
                sb.append(CR);
                sb.append("    @Temporal(TemporalType.TIMESTAMP)");
            }
        });
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "versionMapping");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion versionResource = (XmlVersion)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        OrmVersionMappingTests.assertEquals((String)"versionMapping", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertEquals((String)"versionMapping", (String)versionResource.getName());
        versionResource.setName("newName");
        OrmVersionMappingTests.assertEquals((String)"newName", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertEquals((String)"newName", (String)versionResource.getName());
        versionResource.setName(null);
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getName());
        OrmVersionMappingTests.assertNull((Object)versionResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "versionMapping");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion versionResource = (XmlVersion)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        OrmVersionMappingTests.assertEquals((String)"versionMapping", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertEquals((String)"versionMapping", (String)versionResource.getName());
        ormVersionMapping.setName("newName");
        OrmVersionMappingTests.assertEquals((String)"newName", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertEquals((String)"newName", (String)versionResource.getName());
        ormVersionMapping.setName(null);
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getName());
        OrmVersionMappingTests.assertNull((Object)versionResource.getName());
    }

    public void testUpdateTemporal() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "versionMapping");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion versionResource = (XmlVersion)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getTemporal());
        OrmVersionMappingTests.assertNull((Object)versionResource.getTemporal());
        versionResource.setTemporal(TemporalType.DATE);
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.DATE, (Object)ormVersionMapping.getTemporal());
        OrmVersionMappingTests.assertEquals((Object)TemporalType.DATE, (Object)versionResource.getTemporal());
        versionResource.setTemporal(TemporalType.TIME);
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)ormVersionMapping.getTemporal());
        OrmVersionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)versionResource.getTemporal());
        versionResource.setTemporal(TemporalType.TIMESTAMP);
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)ormVersionMapping.getTemporal());
        OrmVersionMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)versionResource.getTemporal());
        versionResource.setTemporal(null);
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getTemporal());
        OrmVersionMappingTests.assertNull((Object)versionResource.getTemporal());
    }

    public void testModifyTemporal() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "versionMapping");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion versionResource = (XmlVersion)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getTemporal());
        OrmVersionMappingTests.assertNull((Object)versionResource.getTemporal());
        ormVersionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.DATE);
        OrmVersionMappingTests.assertEquals((Object)TemporalType.DATE, (Object)versionResource.getTemporal());
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.DATE, (Object)ormVersionMapping.getTemporal());
        ormVersionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)versionResource.getTemporal());
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)ormVersionMapping.getTemporal());
        ormVersionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIMESTAMP);
        OrmVersionMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)versionResource.getTemporal());
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)ormVersionMapping.getTemporal());
        ormVersionMapping.setTemporal(null);
        OrmVersionMappingTests.assertNull((Object)versionResource.getTemporal());
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getTemporal());
    }

    public void testVersionMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedPersistentAttribute("version", "foo");
        OrmVersionMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertEquals((String)"foo", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getTemporal());
        OrmColumn ormColumn = ormVersionMapping.getColumn();
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmVersionMappingTests.assertEquals((String)"foo", (String)ormColumn.getDefaultName());
        OrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getDefaultUnique());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultNullable());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultInsertable());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultUpdatable());
        OrmVersionMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmVersionMappingTests.assertEquals((Object)255, (Object)ormColumn.getDefaultLength());
        OrmVersionMappingTests.assertEquals((Object)0, (Object)ormColumn.getDefaultPrecision());
        OrmVersionMappingTests.assertEquals((Object)0, (Object)ormColumn.getDefaultScale());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmVersionMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertEquals((String)"id", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)ormVersionMapping.getTemporal());
        OrmColumn ormColumn = ormVersionMapping.getColumn();
        OrmVersionMappingTests.assertEquals((String)"MY_COLUMN", (String)ormColumn.getSpecifiedName());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        OrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        OrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        OrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmVersionMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertEquals((String)"MY_TABLE", (String)ormColumn.getSpecifiedTable());
        OrmVersionMappingTests.assertEquals((Object)5, (Object)ormColumn.getSpecifiedLength());
        OrmVersionMappingTests.assertEquals((Object)6, (Object)ormColumn.getSpecifiedPrecision());
        OrmVersionMappingTests.assertEquals((Object)7, (Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmVersionMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmVersionMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentAttribute.makeSpecified("version");
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertEquals((String)"id", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getTemporal());
        OrmColumn ormColumn = ormVersionMapping.getColumn();
        OrmVersionMappingTests.assertEquals((String)"id", (String)ormColumn.getName());
        OrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getUnique());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getNullable());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getInsertable());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getUpdatable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getTable());
        OrmVersionMappingTests.assertEquals((Object)255, (Object)ormColumn.getLength());
        OrmVersionMappingTests.assertEquals((Object)0, (Object)ormColumn.getPrecision());
        OrmVersionMappingTests.assertEquals((Object)0, (Object)ormColumn.getScale());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedPersistentAttribute("version", "id");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertEquals((String)"id", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getTemporal());
        OrmColumn ormColumn = ormVersionMapping.getColumn();
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmVersionMappingTests.assertEquals((String)"id", (String)ormColumn.getDefaultName());
        OrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getDefaultUnique());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultNullable());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultInsertable());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultUpdatable());
        OrmVersionMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmVersionMappingTests.assertEquals((Object)255, (Object)ormColumn.getDefaultLength());
        OrmVersionMappingTests.assertEquals((Object)0, (Object)ormColumn.getDefaultPrecision());
        OrmVersionMappingTests.assertEquals((Object)0, (Object)ormColumn.getDefaultScale());
    }

    public void testVersionMorphToIdMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((IdMapping)ormPersistentAttribute.getMapping()).getTemporal());
        OrmVersionMappingTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testVersionMorphToBasicMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((BasicMapping)ormPersistentAttribute.getMapping()).getTemporal());
        OrmVersionMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testVersionMorphToTransientMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embedded");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToOneToOneMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToOne");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToOneToManyMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToMany");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToManyToOneMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToManyToManyMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToMany");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }
}

