/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.projects;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.SynchronousJpaProjectUpdater;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class TestJpaProject
extends TestJavaProject {
    private final JpaProject jpaProject;
    public static final String JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.jpa.jar";

    public static TestJpaProject buildJpaProject(String baseProjectName, boolean autoBuild, IDataModel jpaConfig) throws CoreException {
        return new TestJpaProject(TestJpaProject.uniqueProjectName(baseProjectName), autoBuild, jpaConfig);
    }

    public static TestJpaProject buildJpaProject(String baseProjectName, boolean autoBuild) throws CoreException {
        return TestJpaProject.buildJpaProject(baseProjectName, autoBuild, null);
    }

    public TestJpaProject(String projectName) throws CoreException {
        this(projectName, false);
    }

    public TestJpaProject(String projectName, boolean autoBuild) throws CoreException {
        this(projectName, autoBuild, null);
    }

    public TestJpaProject(String projectName, boolean autoBuild, IDataModel jpaConfig) throws CoreException {
        super(projectName, autoBuild);
        this.installFacet("jst.utility", "1.0");
        this.installFacet("jpt.jpa", "1.0", jpaConfig);
        this.addJar(this.jarName());
        this.jpaProject = JptCorePlugin.getJpaProject((IProject)this.getProject());
        this.jpaProject.setUpdater((JpaProject.Updater)new SynchronousJpaProjectUpdater(this.jpaProject));
    }

    protected String jarName() {
        String jarName = System.getProperty(JAR_NAME_SYSTEM_PROPERTY);
        if (jarName == null) {
            throw new RuntimeException("missing Java system property: \"org.eclipse.jpt.jpa.jar\"");
        }
        return jarName;
    }

    public JpaProject getJpaProject() {
        return this.jpaProject;
    }
}

