/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.EnumType;
import org.eclipse.jpt.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EnumeratedTests
extends JavaResourceModelTestCase {
    public EnumeratedTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEnumerated() throws Exception {
        this.createAnnotationAndMembers("Enumerated", "EnumType value();");
        this.createEnumAndMembers("EnumType", "ORDINAL, STRING");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Enumerated"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Enumerated");
            }
        });
    }

    private ICompilationUnit createTestEnumeratedWithValue() throws Exception {
        this.createAnnotationAndMembers("Enumerated", "EnumType value();");
        this.createEnumAndMembers("EnumType", "ORDINAL, STRING");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Enumerated", "javax.persistence.EnumType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Enumerated(EnumType.ORDINAL)");
            }
        });
    }

    public void testEnumerated() throws Exception {
        ICompilationUnit cu = this.createTestEnumerated();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.getAnnotation("javax.persistence.Enumerated");
        EnumeratedTests.assertNotNull((Object)enumerated);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestEnumeratedWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.getAnnotation("javax.persistence.Enumerated");
        EnumeratedTests.assertEquals((Object)EnumType.ORDINAL, (Object)enumerated.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestEnumerated();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.getAnnotation("javax.persistence.Enumerated");
        enumerated.setValue(EnumType.STRING);
        this.assertSourceContains("@Enumerated(STRING)", cu);
        enumerated.setValue(null);
        this.assertSourceDoesNotContain("@Enumerated", cu);
    }
}

