/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.MappedSuperclassAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class MappedSuperclassTests
extends JavaResourceModelTestCase {
    public MappedSuperclassTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        this.createAnnotationAndMembers("MappedSuperclass", "");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassAndEntity() throws Exception {
        this.createAnnotationAndMembers("MappedSuperclass", "");
        this.createAnnotationAndMembers("Entity", "");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
                sb.append("@Entity");
            }
        });
    }

    public void testMappedSuperclass() throws Exception {
        ICompilationUnit cu = this.createTestMappedSuperclass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourceNode mappingAnnotation = typeResource.getMappingAnnotation();
        MappedSuperclassTests.assertTrue((boolean)(mappingAnnotation instanceof MappedSuperclassAnnotation));
    }

    public void testMappedSuperclassAndEntity() throws Exception {
        ICompilationUnit cu = this.createTestMappedSuperclassAndEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourceNode mappingAnnotation = typeResource.getMappingAnnotation();
        MappedSuperclassTests.assertTrue((boolean)(mappingAnnotation instanceof EntityAnnotation));
        MappedSuperclassAnnotation mappedSuperclass = (MappedSuperclassAnnotation)typeResource.getMappingAnnotation("javax.persistence.MappedSuperclass");
        MappedSuperclassTests.assertNotNull((Object)mappedSuperclass);
    }
}

