/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TestDesignTimeApplicationManager
extends TestCase {
    private IFile _testJSP;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;
    private WebProjectTestEnvironment _webProjectTestEnv;
    private JDTTestEnvironment _jdtTestEnv;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this._webProjectTestEnv = new WebProjectTestEnvironment("TestDesignTimeApplicationManager" + this.getName());
        this._webProjectTestEnv.createProject(false);
        this._jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._webProjectTestEnv);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle1.resources.data");
        this._jdtTestEnv.addResourceFile("src", (InputStream)new ByteArrayInputStream(input.toBytes()), "bundles", "bundle1.properties");
        IResource res = this._webProjectTestEnv.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", "testdata1.jsp");
        this._testJSP = (IFile)res;
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(this._webProjectTestEnv);
        this._jsfFactedTestEnvironment.initialize("1.1");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetFacesContext() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        DTFacesContext facesContext = manager.getFacesContext(this._testJSP);
        TestDesignTimeApplicationManager.assertNotNull((Object)facesContext);
    }

    public void testBug147729() throws Exception {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._webProjectTestEnv.getTestProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager.getPropertyResolver());
        manager.setPropertyResolverProvider("my.test.blah");
        TestDesignTimeApplicationManager.assertEquals((String)"my.test.blah", (String)manager.getPropertyResolverProvider());
        RenameSupport renameSupport = RenameSupport.create((IJavaProject)this._jdtTestEnv.getJavaProject(), (String)("RenamedProject" + this.getName()), (int)1);
        renameSupport.perform(new Shell(), (IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        TestDesignTimeApplicationManager.assertFalse((boolean)this._jdtTestEnv.getJavaProject().getProject().isAccessible());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("RenamedProject" + this.getName());
        TestDesignTimeApplicationManager.assertTrue((boolean)project.isAccessible());
        manager = DesignTimeApplicationManager.getInstance((IProject)project);
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        TestDesignTimeApplicationManager.assertEquals((String)"my.test.blah", (String)manager.getPropertyResolverProvider());
    }
}

