/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class ArithmeticDivideTestCase
extends SingleJSPTestCase {
    public ArithmeticDivideTestCase() {
        super("/testdata/jsps/arithmeticDivide.jsp.data", "/WEB-INF/arithmeticDivide.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSanity() {
        super.testSanity();
        ArithmeticDivideTestCase.assertEquals((String)"myBean.integerProperty / 3", (String)this.getELText(this._structuredDocument, 828));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.integerProperty div 3", (String)this.getELText(this._structuredDocument, 887));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.stringProperty / 3", (String)this.getELText(this._structuredDocument, 948));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.stringProperty div 3", (String)this.getELText(this._structuredDocument, 1006));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.integerProperty / myBean.integerProperty", (String)this.getELText(this._structuredDocument, 1066));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.integerProperty div myBean.integerProperty", (String)this.getELText(this._structuredDocument, 1146));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.bigIntegerProperty / 4", (String)this.getELText(this._structuredDocument, 1228));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.bigIntegerProperty / 5.5", (String)this.getELText(this._structuredDocument, 1290));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.bigDoubleProperty / 5.5", (String)this.getELText(this._structuredDocument, 1354));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.doubleProperty / 5", (String)this.getELText(this._structuredDocument, 1417));
        ArithmeticDivideTestCase.assertEquals((String)"5 / 3", (String)this.getELText(this._structuredDocument, 1505));
        ArithmeticDivideTestCase.assertEquals((String)"5 div 3", (String)this.getELText(this._structuredDocument, 1540));
        ArithmeticDivideTestCase.assertEquals((String)"5.5 / 4", (String)this.getELText(this._structuredDocument, 1577));
        ArithmeticDivideTestCase.assertEquals((String)"5.5 div 4", (String)this.getELText(this._structuredDocument, 1614));
        ArithmeticDivideTestCase.assertEquals((String)"'5' / '4'", (String)this.getELText(this._structuredDocument, 1656));
        ArithmeticDivideTestCase.assertEquals((String)"'5' div '4'", (String)this.getELText(this._structuredDocument, 1698));
        ArithmeticDivideTestCase.assertEquals((String)"null / null", (String)this.getELText(this._structuredDocument, 1742));
        ArithmeticDivideTestCase.assertEquals((String)"null div null", (String)this.getELText(this._structuredDocument, 1786));
        ArithmeticDivideTestCase.assertEquals((String)"5.5 / 3.5", (String)this.getELText(this._structuredDocument, 1832));
        ArithmeticDivideTestCase.assertEquals((String)"5 / true", (String)this.getELText(this._structuredDocument, 1897));
        ArithmeticDivideTestCase.assertEquals((String)"5 div true", (String)this.getELText(this._structuredDocument, 1935));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.integerProperty / myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1975));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.integerProperty div myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 2052));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.stringArrayProperty / myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 2131));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.integerProperty div myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 2212));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.integerProperty / true ", (String)this.getELText(this._structuredDocument, 2294));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.integerProperty div true ", (String)this.getELText(this._structuredDocument, 2357));
        ArithmeticDivideTestCase.assertEquals((String)"'a' / 'b'", (String)this.getELText(this._structuredDocument, 2422));
        ArithmeticDivideTestCase.assertEquals((String)"'a' div 'b'", (String)this.getELText(this._structuredDocument, 2464));
        ArithmeticDivideTestCase.assertEquals((String)"5.5 / null", (String)this.getELText(this._structuredDocument, 2505));
        ArithmeticDivideTestCase.assertEquals((String)"5.5 div null", (String)this.getELText(this._structuredDocument, 2545));
        ArithmeticDivideTestCase.assertEquals((String)"5/0", (String)this.getELText(this._structuredDocument, 2587));
        ArithmeticDivideTestCase.assertEquals((String)"5 div 0", (String)this.getELText(this._structuredDocument, 2620));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.bigIntegerProperty + true", (String)this.getELText(this._structuredDocument, 2657));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.bigDoubleProperty / null", (String)this.getELText(this._structuredDocument, 2719));
        ArithmeticDivideTestCase.assertEquals((String)"myBean.bigDoubleProperty div true", (String)this.getELText(this._structuredDocument, 2780));
    }

    public void testNoErrorExprs() {
        this.assertNoError(828, "D");
        this.assertNoError(887, "D");
        this.assertNoError(948, "D");
        this.assertNoError(1006, "D");
        this.assertNoError(1066, "D");
        this.assertNoError(1146, "D");
        this.assertNoError(1228, "Ljava.math.BigDecimal;");
        this.assertNoError(1290, "Ljava.math.BigDecimal;");
        this.assertNoError(1354, "Ljava.math.BigDecimal;");
        this.assertNoError(1417, "D");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(1505, "D", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1540, "D", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1577, "D", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1614, "D", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1656, "D", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1698, "D", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1742, "J", 1);
        this.assertContainsProblem(list, 0);
        list = this.assertSemanticWarning(1786, "J", 1);
        this.assertContainsProblem(list, 0);
        list = this.assertSemanticWarning(1832, "D", 1);
        this.assertContainsProblem(list, 3);
    }

    public void testErrorExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticError(1897, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1935, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1975, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2052, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2131, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2212, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2294, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2357, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2422, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2464, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2505, null, 1);
        this.assertContainsProblem(list, 1);
        list = this.assertSemanticError(2545, null, 1);
        this.assertContainsProblem(list, 1);
        list = this.assertSemanticError(2587, null, 1);
        this.assertContainsProblem(list, 1);
        list = this.assertSemanticError(2620, null, 1);
        this.assertContainsProblem(list, 1);
        list = this.assertSemanticError(2657, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2719, null, 1);
        this.assertContainsProblem(list, 1);
        list = this.assertSemanticError(2780, null, 1);
        this.assertContainsProblem(list, 2);
    }
}

