/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.preferences;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.JSPTestCase;
import org.eclipse.jst.jsf.validation.el.tests.base.MockELValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.preferences.PrefTestUtil;
import org.eclipse.jst.jsf.validation.internal.ELValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.Severity;
import org.eclipse.jst.jsf.validation.internal.el.ELExpressionValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class EndToEndTestCase
extends JSPTestCase {
    protected IFile _testJSP;
    private IStructuredModel _structuredModel;
    private IStructuredDocument _structuredDocument;
    private ELValidationPreferences _prefs;

    public EndToEndTestCase() {
        super(JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._testJSP = this.loadJSP("/testdata/jsps/preferenceTest1.jsp.data", "/preferenceTest1.jsp");
        this._structuredModel = StructuredModelManager.getModelManager().getModelForRead(this._testJSP);
        this._structuredDocument = this._structuredModel.getStructuredDocument();
        this._prefs = new ELValidationPreferences();
        this._prefs.load(JSFCorePlugin.getDefault().getPreferenceStore());
        PrefTestUtil.assertExpectedDefaults(this._prefs);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this._structuredModel != null) {
            this._structuredModel.releaseFromRead();
        }
        this._prefs.setDefaults();
        PrefTestUtil.assertExpectedDefaults(this._prefs);
        this._prefs.commit(JSFCorePlugin.getDefault().getPreferenceStore());
        ((IPersistentPreferenceStore)JSFCorePlugin.getDefault().getPreferenceStore()).save();
    }

    public void testSanity() {
        EndToEndTestCase.assertEquals((String)"5+3", (String)this.getELText(this._structuredDocument, 799));
        EndToEndTestCase.assertEquals((String)"null+null", (String)this.getELText(this._structuredDocument, 831));
        EndToEndTestCase.assertEquals((String)"5 + true", (String)this.getELText(this._structuredDocument, 876));
        EndToEndTestCase.assertEquals((String)"'a' + 'b'", (String)this.getELText(this._structuredDocument, 920));
        EndToEndTestCase.assertEquals((String)"5 / 0", (String)this.getELText(this._structuredDocument, 958));
        EndToEndTestCase.assertEquals((String)"myBean.subClassStringProperty", (String)this.getELText(this._structuredDocument, 1028));
        EndToEndTestCase.assertEquals((String)"myBean1", (String)this.getELText(this._structuredDocument, 1093));
        EndToEndTestCase.assertEquals((String)"listBean[-1]", (String)this.getELText(this._structuredDocument, 1129));
        EndToEndTestCase.assertEquals((String)"myBean.stringArrayProperty > myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1177));
        EndToEndTestCase.assertEquals((String)"myBean.coins > myBean.colors", (String)this.getELText(this._structuredDocument, 1264));
        EndToEndTestCase.assertEquals((String)"false && myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1328));
        EndToEndTestCase.assertEquals((String)"myBean.booleanProperty && false", (String)this.getELText(this._structuredDocument, 1395));
        EndToEndTestCase.assertEquals((String)"5 == true", (String)this.getELText(this._structuredDocument, 1462));
        EndToEndTestCase.assertEquals((String)"!false", (String)this.getELText(this._structuredDocument, 1507));
        EndToEndTestCase.assertEquals((String)"!5", (String)this.getELText(this._structuredDocument, 1549));
        EndToEndTestCase.assertEquals((String)"myBean.doubleProperty + myBean.getIntegerProperty", (String)this.getELText(this._structuredDocument, 1587));
    }

    public void testIgnoreAll() throws Exception {
        this.testSeverityAll(0, 0);
    }

    public void testWarningsAll() throws Exception {
        this.testSeverityAll(2, 2);
    }

    public void testErrorAll() throws Exception {
        this.testSeverityAll(4, 1);
    }

    private void testSeverityAll(int diagSeverity, int messageSeverity) throws Exception {
        Severity severity = ELValidationPreferences.mapDiagToSeverity((int)diagSeverity);
        PrefTestUtil.setByKey(severity, this._prefs);
        PrefTestUtil.assertSetByKey(severity, this._prefs);
        IPreferenceStore prefStore = JSFCorePlugin.getDefault().getPreferenceStore();
        this._prefs.commit(prefStore);
        ((IPersistentPreferenceStore)prefStore).save();
        this._prefs.load(prefStore);
        this.assertErrorLevel(799, messageSeverity);
        this.assertErrorLevel(831, messageSeverity);
        this.assertErrorLevel(876, messageSeverity);
        this.assertErrorLevel(920, messageSeverity);
        this.assertErrorLevel(958, messageSeverity);
        this.assertErrorLevel(1028, messageSeverity);
        this.assertErrorLevel(1093, messageSeverity);
        this.assertErrorLevel(1129, messageSeverity);
        this.assertErrorLevel(1177, messageSeverity);
        this.assertErrorLevel(1264, messageSeverity);
        this.assertErrorLevel(1328, messageSeverity);
        this.assertErrorLevel(1395, messageSeverity);
        this.assertErrorLevel(1462, messageSeverity);
        this.assertErrorLevel(1507, messageSeverity);
        this.assertErrorLevel(1549, messageSeverity);
        this.assertErrorLevel(1587, messageSeverity);
    }

    private void assertErrorLevel(int docPos, int severity) {
        MyMockValidationReporter reporter = new MyMockValidationReporter();
        ELExpressionValidator validator = this.createELValidator(this._structuredDocument, docPos, this._testJSP, reporter);
        validator.validateXMLNode();
        List<MockValidationReporter.ReportedProblem> syntaxProblems = reporter.getSyntaxProblems();
        for (MockValidationReporter.ReportedProblem message : syntaxProblems) {
            EndToEndTestCase.assertEquals((int)severity, (int)message.getSeverity());
        }
        List<MockValidationReporter.ReportedProblem> semanticProblems = reporter.getSemanticProblems();
        for (MockValidationReporter.ReportedProblem message : semanticProblems) {
            EndToEndTestCase.assertEquals((int)severity, (int)message.getSeverity());
        }
    }

    private class MyMockValidationReporter
    extends MockELValidationReporter {
        private MyMockValidationReporter() {
        }

        public void report(Diagnostic problem, int start, int length) {
            SeverityModifiableDiagnostic modifiedProblem = new SeverityModifiableDiagnostic(problem);
            super.report((Diagnostic)modifiedProblem, start, length);
        }

        private class SeverityModifiableDiagnostic
        extends BasicDiagnostic {
            private SeverityModifiableDiagnostic(Diagnostic sourceDiag) {
                super(EndToEndTestCase.this._prefs.getDiagnosticSeverity(sourceDiag.getCode()), sourceDiag.getSource(), sourceDiag.getCode(), sourceDiag.getMessage(), sourceDiag.getData().toArray());
            }
        }
    }
}

