/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.core.command;

import java.io.File;
import java.io.InputStream;
import org.apache.axis.client.AdminClient;
import org.apache.axis.tools.ant.axis.AdminClientTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.filters.StringInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.command.AxisDeployCommand;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AxisDeployCommand
extends AbstractDataModelOperation {
    protected static final String SERVICE_EXT = "/services/AdminService";
    protected static final String SERVER_CONFIG = "server-config.wsdd";
    private JavaWSDLParameter javaWSDLParam;
    private String project_;

    public AxisDeployCommand() {
    }

    public AxisDeployCommand(String project) {
        this.project_ = project;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        if (this.javaWSDLParam.getProjectURL() == null || this.javaWSDLParam.getProjectURL().equals("")) {
            return StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_PROJECT_URL_PARAM_NOT_SET);
        }
        if (this.javaWSDLParam.getDeploymentFiles() == null || this.javaWSDLParam.getDeploymentFiles().length == 0) {
            return StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_DEPLOY_FILE_PARAM_NOT_SET);
        }
        ProgressUtils.report((IProgressMonitor)monitor, (String)AxisConsumptionCoreMessages.MSG_AXIS_DEPLOY);
        IStatus status = this.executeAntTask(monitor);
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }

    protected IStatus executeAntTask(IProgressMonitor monitor) {
        final class DeployTask
        extends AdminClientTask {
            final /* synthetic */ AxisDeployCommand this$0;

            public DeployTask(AxisDeployCommand axisDeployCommand) {
                this.this$0 = axisDeployCommand;
                super.setProject(new Project());
                super.getProject().init();
                super.setTaskType("axis");
                super.setTaskName("axis-admin");
                super.setOwningTarget(new Target());
            }
        }
        DeployTask adminClient = new DeployTask(this);
        String url = String.valueOf(this.javaWSDLParam.getProjectURL()) + SERVICE_EXT;
        adminClient.setUrl(url);
        adminClient.setXmlFile(new File(this.javaWSDLParam.getDeploymentFiles()[0]));
        try {
            BuildException lastException = null;
            int index = 0;
            while (index < 20) {
                try {
                    lastException = null;
                    adminClient.execute();
                }
                catch (BuildException exc) {
                    lastException = exc;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (lastException == null) break;
                ++index;
            }
            if (lastException != null) {
                throw lastException;
            }
            return this.createConfigFile(monitor, url);
        }
        catch (BuildException e) {
            e.printStackTrace();
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().toString();
            }
            Status[] childStatus = new Status[]{StatusUtils.errorStatus((String)message)};
            return StatusUtils.multiStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_AXIS_DEPLOY, (IStatus[])childStatus);
        }
    }

    private IStatus createConfigFile(IProgressMonitor monitor, String url) {
        AdminClient listAdmin = new AdminClient();
        String config = "";
        try {
            config = listAdmin.process(new String[]{"-l" + url, "list"});
            IPath webInfPath = J2EEUtils.getWebInfPath((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(this.project_));
            IPath relativeServerConfigPath = webInfPath.append(SERVER_CONFIG);
            IStatusHandler statusHandler = this.getEnvironment().getStatusHandler();
            ResourceContext context = WebServicePlugin.getInstance().getResourceContext();
            FileResourceUtils.createFile((ResourceContext)context, (IPath)relativeServerConfigPath, (InputStream)new StringInputStream(config), (IProgressMonitor)monitor, (IStatusHandler)statusHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().toString();
            }
            Status[] childStatus = new Status[]{StatusUtils.errorStatus((String)message)};
            return StatusUtils.multiStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_AXIS_DEPLOY, (IStatus[])childStatus);
        }
        return Status.OK_STATUS;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }
}

