/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.creation.core.command;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.consumption.core.utils.ContentCopyUtils;
import org.eclipse.jst.ws.axis2.consumption.core.utils.WSDL2JavaGenerator;
import org.eclipse.jst.ws.axis2.consumption.core.utils.WSDLPropertyReader;
import org.eclipse.jst.ws.axis2.core.utils.ClassLoadingUtil;
import org.eclipse.jst.ws.axis2.core.utils.FacetContainerUtils;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.eclipse.jst.ws.axis2.creation.core.data.DataModel;
import org.eclipse.jst.ws.axis2.creation.core.messages.Axis2CreationUIMessages;
import org.eclipse.jst.ws.axis2.creation.core.utils.PathLoadingUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class Axis2WSDL2JavaCommand
extends AbstractDataModelOperation {
    private DataModel model;

    public Axis2WSDL2JavaCommand(DataModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status;
        block15: {
            status = Status.OK_STATUS;
            IEnvironment environment = this.getEnvironment();
            IStatusHandler statusHandler = environment.getStatusHandler();
            PathLoadingUtil.init(this.model);
            String tempCodegenOutputLocation = PathLoadingUtil.getTempCodegenOutputLocation();
            String currentDynamicWebProjectDir = FacetContainerUtils.getProjectRoot((String)this.model.getWebProjectName()).toOSString();
            File tempCodegenLocationFile = new File(tempCodegenOutputLocation);
            if (tempCodegenLocationFile.exists()) {
                FileUtils.deleteDirectories((String)tempCodegenOutputLocation);
            }
            FileUtils.createDirectorys((String)tempCodegenOutputLocation);
            WSDL2JavaGenerator generator = new WSDL2JavaGenerator();
            String transformerFactory = null;
            boolean transformerFactoryModified = false;
            try {
                try {
                    try {
                        transformerFactory = System.getProperty("javax.xml.transform.TransformerFactory");
                        Class.forName("org.apache.xalan.processor.TransformerFactoryImpl");
                        String modifiedTransformerFactory = "org.apache.xalan.processor.TransformerFactoryImpl";
                        if (!modifiedTransformerFactory.equals(transformerFactory)) {
                            System.setProperty("javax.xml.transform.TransformerFactory", modifiedTransformerFactory);
                            transformerFactoryModified = true;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    ClassLoadingUtil.init((String)this.model.getWebProjectName());
                    Object axisServiceInstance = generator.getAxisService(this.model.getWsdlURI());
                    Map optionsMap = generator.fillOptionMap(false, false, true, this.model.isServerXMLCheck(), false, this.model.isGenerateAllCheck(), this.model.getServiceName() != null ? this.model.getServiceName() : null, this.model.getPortName() != null ? this.model.getPortName() : null, this.model.getDatabindingType().toLowerCase() != null ? this.model.getDatabindingType().toLowerCase() : null, this.model.getWsdlURI() != null ? this.model.getWsdlURI() : null, this.model.getPackageText() != null ? this.model.getPackageText() : null, "java", tempCodegenOutputLocation, this.model.getNamespaseToPackageMapping(), this.model.isGenerateServerSideInterface());
                    Class CodeGenConfigurationClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.wsdl.codegen.CodeGenConfiguration");
                    Constructor CodeGenConfigurationConstructor = CodeGenConfigurationClass.getConstructor(Map.class);
                    Object CodeGenConfigurationInstance = CodeGenConfigurationConstructor.newInstance(optionsMap);
                    Method addAxisServiceMethod = CodeGenConfigurationClass.getMethod("addAxisService", axisServiceInstance.getClass());
                    addAxisServiceMethod.invoke(CodeGenConfigurationInstance, axisServiceInstance);
                    WSDLPropertyReader reader = new WSDLPropertyReader();
                    reader.readWSDL(this.model.getWebProjectName(), this.model.getWsdlURI());
                    Object wsdlDefinitionInstance = reader.getWsdlDefinitionInstance();
                    Method setWsdlDefinitionMethod = CodeGenConfigurationClass.getMethod("setWsdlDefinition", reader.getWsdlDefinitionClass());
                    setWsdlDefinitionMethod.invoke(CodeGenConfigurationInstance, wsdlDefinitionInstance);
                    Method setBaseURIMethod = CodeGenConfigurationClass.getMethod("setBaseURI", String.class);
                    setBaseURIMethod.invoke(CodeGenConfigurationInstance, generator.getBaseUri(this.model.getWsdlURI()));
                    Class AxisServiceClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.description.AxisService");
                    Method getTargetNamespaceMethod = AxisServiceClass.getMethod("getTargetNamespace", null);
                    Object targetNamespace = getTargetNamespaceMethod.invoke(axisServiceInstance, null);
                    Object stringReturn = null;
                    if (this.model.getPackageText() != null) {
                        stringReturn = this.model.getPackageText();
                    } else {
                        Class URLProcessorClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.util.URLProcessor");
                        Method makePackageNameMethod = URLProcessorClass.getMethod("makePackageName", String.class);
                        stringReturn = makePackageNameMethod.invoke(null, targetNamespace);
                    }
                    this.model.setPackageText(stringReturn.toString());
                    Method setPackageNameMethod = CodeGenConfigurationClass.getMethod("setPackageName", String.class);
                    setPackageNameMethod.invoke(CodeGenConfigurationInstance, stringReturn);
                    Class CodeGenerationEngineClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.wsdl.codegen.CodeGenerationEngine");
                    Constructor CodeGenerationEngineConstructor = CodeGenerationEngineClass.getConstructor(CodeGenConfigurationInstance.getClass());
                    Object CodeGenerationEngineInstance = CodeGenerationEngineConstructor.newInstance(CodeGenConfigurationInstance);
                    Method generateMethod = CodeGenerationEngineClass.getMethod("generate", null);
                    generateMethod.invoke(CodeGenerationEngineInstance, null);
                    ContentCopyUtils contentCopyUtils = new ContentCopyUtils();
                    status = contentCopyUtils.copyDirectoryRecursivelyIntoWorkspace(tempCodegenOutputLocation, currentDynamicWebProjectDir, monitor, statusHandler);
                }
                catch (Exception e) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2CreationUIMessages.ERROR_CODEGEN_EXCEPTION, (Object[])new String[]{" : " + e.getCause()}), (Throwable)e);
                    e.printStackTrace();
                    environment.getStatusHandler().reportError(status);
                    if (!transformerFactoryModified) break block15;
                    if (transformerFactory == null) {
                        System.clearProperty("javax.xml.transform.TransformerFactory");
                        break block15;
                    }
                    System.setProperty("javax.xml.transform.TransformerFactory", transformerFactory);
                }
            }
            finally {
                if (transformerFactoryModified) {
                    if (transformerFactory == null) {
                        System.clearProperty("javax.xml.transform.TransformerFactory");
                    } else {
                        System.setProperty("javax.xml.transform.TransformerFactory", transformerFactory);
                    }
                }
            }
        }
        return status;
    }
}

