/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.HashMap;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataReader;

public class OaaMetadataTests
extends AbstractRegressionTest {
    static final String LIB1 = "<api xmlns=\"http://ns.openajax.org/api\" version=\"...\" apiType=\"JavaScript\">   <class type=\"libraryname.ClassName\" superclass=\"Object\">      <constructors>          <constructor scope=\"instance\">              <description>Constructor description</description>              <parameters>                  <parameter name=\"message\" required=\"true\" type=\"String\">                      <description>Parameter description</description>                  </parameter>              </parameters>              <returns type=\"Object\">                <description>...</description>              </returns>          </constructor>       </constructors>      <fields>          <field name=\"propertyInstance\" readonly=\"false\" scope=\"instance\" type=\"String\">              <description>Property description</description>          </field>          <field name=\"propertyStatic\" readonly=\"false\" scope=\"static\" type=\"String\">              <description>Property description</description>          </field>      </fields>      <methods>          <method name=\"functionInstance\" scope=\"instance\">              <description>Method description</description>              <parameters>                  <parameter name=\"param\" required=\"true\" type=\"String\">                      <description>Parameter description</description>                  </parameter>              </parameters>              <returns type=\"String\">                <description>...</description>              </returns>          </method>          <method name=\"functionStatic\" scope=\"static\">              <description>Method description</description>              <parameters/>              <returns type=\"String\">                <description>...</description>              </returns>          </method>      </methods>  </class></api>";

    public OaaMetadataTests(String name) {
        super(name);
    }

    protected void runNegativeTest(String[] testFiles, String[] classLib, String expectedProblemLog) {
        HashMap options = new HashMap();
        String[] defaultClassPaths = this.getDefaultClassPaths();
        String[] classLibs = new String[classLib.length + defaultClassPaths.length];
        System.arraycopy(classLib, 0, classLibs, 0, classLib.length);
        System.arraycopy(defaultClassPaths, 0, classLibs, classLib.length, defaultClassPaths.length);
        this.runNegativeTest(testFiles, expectedProblemLog, classLibs, false, options, false, false, false, false, false, null);
    }

    public void test001() {
        LibraryAPIs apis = MetadataReader.readAPIsFromString((String)LIB1);
        OaaMetadataTests.assertTrue((apis.classes != null && apis.classes.length == 1 ? 1 : 0) != 0);
    }

    public void test003() {
        String libDir = Util.copyToOutput("libDir/OpenAjaxAPI.xml", LIB1);
        this.runNegativeTest(new String[]{"X.js", "var i=new libraryname.ClassName(1);\nvar d=i.propertyInstance;\nvar e=i.functionInstance(1);\n\n"}, new String[]{libDir}, "");
    }
}

