/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.wst.jsdt.ui.IDocumentationReader;

public class JSdocContentAccess {
    public static final String EXTENSION_POINT = "documentationProvider";
    protected static final String TAG_DOCUMENTATIONPROVIDER = "documentationProvider";
    protected static final String ATTR_DOCUMENTATIONPROVIDER_CLASS = "class";
    private static IDocumentationReader[] docReaders;

    private JSdocContentAccess() {
    }

    public static Reader getContentReader(IMember member, boolean allowInherited) throws JavaScriptModelException {
        JavaDocCommentReader reader;
        IDocumentationReader docReader = JSdocContentAccess.getDocReader(member);
        if (docReader != null) {
            return docReader.getContentReader(member, allowInherited);
        }
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJSdocRange();
        if (javadocRange != null && !JSdocContentAccess.containsOnlyInheritDoc(reader = new JavaDocCommentReader(buf, javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength() - 1), javadocRange.getLength())) {
            reader.reset();
            return reader;
        }
        if (allowInherited && member.getElementType() == 9) {
            return JSdocContentAccess.findDocInHierarchy((IFunction)member);
        }
        return null;
    }

    private static boolean containsOnlyInheritDoc(Reader reader, int length) {
        char[] content = new char[length];
        try {
            reader.read(content, 0, length);
        }
        catch (IOException iOException) {
            return false;
        }
        return new String(content).trim().equals("{@inheritDoc}");
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited, boolean useAttachedJavadoc) throws JavaScriptModelException {
        String s;
        Reader contentReader = JSdocContentAccess.getContentReader(member, allowInherited);
        if (contentReader != null) {
            IDocumentationReader docReader = JSdocContentAccess.getDocReader(member);
            if (docReader != null) {
                return docReader.getDocumentation2HTMLReader(contentReader);
            }
            return new JavaDoc2HTMLTextReader(contentReader);
        }
        if (useAttachedJavadoc && member.getOpenable().getBuffer() == null && (s = member.getAttachedJavadoc(null)) != null) {
            return new StringReader(s);
        }
        return null;
    }

    private static Reader findDocInHierarchy(IFunction method) throws JavaScriptModelException {
        IType type = method.getDeclaringType();
        if (type == null) {
            return null;
        }
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        MethodOverrideTester tester = new MethodOverrideTester(type, hierarchy);
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            Reader reader;
            IType curr = superTypes[i];
            IFunction overridden = tester.findOverriddenMethodInType(curr, method);
            if (overridden != null && (reader = JSdocContentAccess.getContentReader((IMember)overridden, false)) != null) {
                return reader;
            }
            ++i;
        }
        return null;
    }

    private static IDocumentationReader getDocReader(IMember member) {
        if (docReaders == null) {
            JSdocContentAccess.loadExtensions();
        }
        int i = 0;
        while (i < docReaders.length) {
            if (docReaders[i].appliesTo(member)) {
                return docReaders[i];
            }
            ++i;
        }
        return null;
    }

    private static void loadExtensions() {
        IExtensionPoint point;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IDocumentationReader> extList = new ArrayList<IDocumentationReader>();
        if (registry != null && (point = registry.getExtensionPoint(JavaScriptPlugin.getPluginId(), "documentationProvider")) != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        IDocumentationReader docProvider = null;
                        if (elements[j].getName().equals("documentationProvider")) {
                            docProvider = (IDocumentationReader)elements[j].createExecutableExtension(ATTR_DOCUMENTATIONPROVIDER_CLASS);
                        }
                        extList.add(docProvider);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                ++i;
            }
        }
        docReaders = extList.toArray(new IDocumentationReader[extList.size()]);
    }
}

