/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.ui.internal;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationRunner;
import org.eclipse.wst.validation.ui.internal.ValUIMessages;
import org.eclipse.wst.validation.ui.internal.dialog.ResultsDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualValidationRunner
extends WorkspaceJob {
    private Map<IProject, Set<IResource>> _projects;
    private ValType _valType;
    private boolean _showResults;

    public static void validate(Map<IProject, Set<IResource>> projects, ValType valType, boolean showResults) {
        ManualValidationRunner me = new ManualValidationRunner(projects, valType, showResults);
        Set<IProject> keys = projects.keySet();
        IProject[] projectArray = new IProject[keys.size()];
        keys.toArray(projectArray);
        if (projectArray.length == 1) {
            me.setRule((ISchedulingRule)projectArray[0]);
        } else {
            me.setRule(MultiRule.combine((ISchedulingRule[])projectArray));
        }
        me.schedule();
    }

    private ManualValidationRunner(Map<IProject, Set<IResource>> projects, ValType valType, boolean showResults) {
        super(ValUIMessages.Validation);
        this._projects = projects;
        this._valType = valType;
        this._showResults = showResults;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        final ValOperation vo = ValidationRunner.validate(this._projects, (ValType)this._valType, (IProgressMonitor)monitor, (boolean)false);
        final long time = System.currentTimeMillis() - start;
        int resourceCount = 0;
        for (Set<IResource> s : this._projects.values()) {
            resourceCount += s.size();
        }
        final int finalResourceCount = resourceCount;
        if (vo.getResult().isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this._showResults) {
            Display display = Display.getDefault();
            Runnable run = new Runnable(){

                public void run() {
                    ValidationResult vr = vo.getResult();
                    ResultsDialog rd = new ResultsDialog(null, vr, time, finalResourceCount);
                    rd.open();
                }
            };
            display.asyncExec(run);
        }
        return Status.OK_STATUS;
    }
}

