/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.service.internal.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyActivator;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyStateChangeListener;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyStateImpl
implements IPolicyState {
    private List<IPolicyStateChangeListener> stateChangeListeners;
    private List<IPolicyStateChangeListener> stateChangeListenersOnlyOnCommit;
    private IPreferencesService service = Platform.getPreferencesService();
    private IProject project;
    private boolean mutable;
    private IServicePolicy policy;
    private Map<String, TableEntry> table;
    private ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();

    public PolicyStateImpl(IServicePolicy policy, IProject project) {
        this.project = project;
        this.policy = policy;
        this.mutable = !policy.isPredefined();
        this.table = new HashMap<String, TableEntry>();
    }

    public void commitChanges() {
        if (!this.mutable) {
            return;
        }
        IEclipsePreferences preferences = null;
        preferences = this.project == null ? new InstanceScope().getNode("org.eclipse.wst.ws.service.policy") : new ProjectScope(this.project).getNode("org.eclipse.wst.ws.service.policy");
        for (Map.Entry<String, TableEntry> entry : this.table.entrySet()) {
            String key = entry.getKey();
            String storeKey = this.makeStoreKey(key);
            TableEntry tableEntry = entry.getValue();
            String value = tableEntry.value;
            if (value == null) continue;
            String oldValue = tableEntry.lastCommittedValue;
            preferences.put(storeKey, value);
            tableEntry.lastCommittedValue = value;
            if (oldValue == null) {
                tableEntry.value = null;
                oldValue = this.getValue(key);
                tableEntry.value = value;
            }
            if (value.equals(oldValue)) continue;
            this.firePolicyStateChange(this.stateChangeListenersOnlyOnCommit, key, oldValue, value);
        }
    }

    private IEclipsePreferences[] getNodes() {
        IEclipsePreferences[] result = null;
        result = this.project != null && this.platform.isProjectPreferencesEnabled(this.project) ? new IEclipsePreferences[]{new ProjectScope(this.project).getNode("org.eclipse.wst.ws.service.policy"), new InstanceScope().getNode("org.eclipse.wst.ws.service.policy")} : new IEclipsePreferences[]{new InstanceScope().getNode("org.eclipse.wst.ws.service.policy")};
        return result;
    }

    public void discardChanges() {
        if (!this.mutable) {
            return;
        }
        for (TableEntry entry : this.table.values()) {
            entry.value = null;
        }
    }

    public void restoreDefaults() {
        if (this.project == null) {
            for (TableEntry entry : this.table.values()) {
                entry.value = entry.defaultValue;
            }
        } else {
            IEclipsePreferences[] nodes = new IEclipsePreferences[]{new InstanceScope().getNode("org.eclipse.wst.ws.service.policy")};
            for (Map.Entry<String, TableEntry> entry : this.table.entrySet()) {
                String storeKey = this.makeStoreKey(entry.getKey());
                TableEntry tableEntry = entry.getValue();
                String defaultValue = "";
                if (tableEntry.defaultValue != null) {
                    defaultValue = tableEntry.defaultValue;
                }
                tableEntry.value = this.service.get(storeKey, defaultValue, (Preferences[])nodes);
            }
        }
    }

    @Override
    public String getValue(String key) {
        String result = null;
        TableEntry entry = this.table.get(key);
        if (entry == null) {
            entry = new TableEntry();
            this.table.put(key, entry);
        }
        if (this.project == null || this.project != null && this.platform.isProjectPreferencesEnabled(this.project)) {
            result = entry.value;
        }
        if (result == null) {
            String defaultValue = "";
            String storeKey = this.makeStoreKey(key);
            if (entry.defaultValue != null) {
                defaultValue = entry.defaultValue;
            }
            result = this.service.get(storeKey, defaultValue, (Preferences[])this.getNodes());
        }
        return result;
    }

    private String makeStoreKey(String key) {
        return String.valueOf(this.policy.getId()) + "." + key;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public void putDefaultValue(String key, String defaultValue, boolean overrideExisting) {
        if (!this.mutable) {
            return;
        }
        TableEntry entry = this.table.get(key);
        if (entry == null) {
            entry = new TableEntry();
            this.table.put(key, entry);
        }
        if (entry.defaultValue == null || overrideExisting) {
            entry.defaultValue = defaultValue;
        }
    }

    @Override
    public void putValue(String key, String value) {
        if (!this.mutable) {
            return;
        }
        TableEntry entry = this.table.get(key);
        if (entry == null) {
            entry = new TableEntry();
            this.table.put(key, entry);
        }
        String oldValue = this.getValue(key);
        entry.value = value;
        this.firePolicyStateChange(this.stateChangeListeners, key, oldValue, value);
    }

    public void internalSetMutable(boolean mutable) {
        this.mutable = mutable;
    }

    @Override
    public void setMutable(boolean mutable) {
        if (this.policy.isPredefined()) {
            ServicePolicyActivator.logError("Attempt to set mutability on a predefined service policy.", null);
        } else {
            this.mutable = mutable;
        }
    }

    @Override
    public void addPolicyStateChangeListener(IPolicyStateChangeListener listener, boolean notifyOnCommitOnly) {
        if (notifyOnCommitOnly) {
            if (this.stateChangeListenersOnlyOnCommit == null) {
                this.stateChangeListenersOnlyOnCommit = new Vector<IPolicyStateChangeListener>();
            }
            this.stateChangeListenersOnlyOnCommit.add(listener);
        } else {
            if (this.stateChangeListeners == null) {
                this.stateChangeListeners = new Vector<IPolicyStateChangeListener>();
            }
            this.stateChangeListeners.add(listener);
        }
    }

    @Override
    public void removePolicyStateChangeListener(IPolicyStateChangeListener listener) {
        if (this.stateChangeListeners != null) {
            this.stateChangeListeners.remove(listener);
        }
        if (this.stateChangeListenersOnlyOnCommit != null) {
            this.stateChangeListenersOnlyOnCommit.remove(listener);
        }
    }

    private void firePolicyStateChange(List<IPolicyStateChangeListener> listeners, String key, String oldValue, String newValue) {
        if (listeners != null) {
            for (IPolicyStateChangeListener listener : listeners) {
                listener.policyStateChange(this.policy, key, oldValue, newValue);
            }
        }
    }

    private class TableEntry {
        String value;
        String lastCommittedValue;
        String defaultValue;

        private TableEntry() {
        }
    }
}

