/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.service.internal.policy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.ws.service.internal.policy.DescriptorImpl;
import org.eclipse.wst.ws.service.internal.policy.EnumerationStateImpl;
import org.eclipse.wst.ws.service.internal.policy.PolicyStateImpl;
import org.eclipse.wst.ws.service.internal.policy.ServicePolicyPlatformImpl;
import org.eclipse.wst.ws.service.internal.policy.UnresolvedPolicyRelationship;
import org.eclipse.wst.ws.service.internal.policy.UnresolvedRelationship;
import org.eclipse.wst.ws.service.policy.IDescriptor;
import org.eclipse.wst.ws.service.policy.IPolicyEnumerationList;
import org.eclipse.wst.ws.service.policy.IPolicyRelationship;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IPolicyStateEnum;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.IStateEnumerationItem;
import org.eclipse.wst.ws.service.policy.PolicyEnumerationListImpl;
import org.eclipse.wst.ws.service.policy.PolicyRelationshipImpl;
import org.eclipse.wst.ws.service.policy.ServicePolicyActivator;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyChildChangeListener;
import org.eclipse.wst.ws.service.policy.listeners.IStatusChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicePolicyImpl
implements IServicePolicy {
    private boolean predefined;
    private String id;
    private ServicePolicyImpl parent;
    private DescriptorImpl descriptor;
    private List<IServicePolicy> committedChildren;
    private List<IServicePolicy> children;
    private PolicyStateImpl policyState;
    private Map<IProject, PolicyStateImpl> projectPolicyStates;
    private List<IPolicyRelationship> relationshipList;
    private List<IPolicyChildChangeListener> childChangeListeners;
    private ServicePolicyPlatformImpl platform;
    private String enumListId;
    private String defaultEnumId;
    private List<IStatusChangeListener> statusChangeListeners;
    private IStatus status;
    private String unresolvedParent;
    private List<UnresolvedRelationship> unresolvedRelationshipList;

    public ServicePolicyImpl(boolean isPredefined, String id, ServicePolicyPlatformImpl platform) {
        this.predefined = isPredefined;
        this.id = id;
        this.children = new Vector<IServicePolicy>();
        this.relationshipList = new Vector<IPolicyRelationship>();
        this.unresolvedRelationshipList = new Vector<UnresolvedRelationship>();
        this.policyState = new PolicyStateImpl(this, null);
        this.platform = platform;
        this.childChangeListeners = new Vector<IPolicyChildChangeListener>();
        this.projectPolicyStates = new HashMap<IProject, PolicyStateImpl>();
        this.status = Status.OK_STATUS;
    }

    @Override
    public boolean isPredefined() {
        return this.predefined;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setParent(ServicePolicyImpl parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this, false);
        }
    }

    public void commitChanges() {
        this.policyState.commitChanges();
        this.committedChildren = new Vector<IServicePolicy>(this.children);
    }

    public void discardChanges() {
        this.policyState.discardChanges();
        this.fireChildChangesDuetoDiscard();
        this.children = new Vector<IServicePolicy>(this.committedChildren);
    }

    @Override
    public List<IServicePolicy> getChildren() {
        return this.children;
    }

    private void addChild(ServicePolicyImpl child, boolean fireEvent) {
        this.children.add(child);
        if (fireEvent) {
            this.fireChildChangeEvent(child, true);
        }
    }

    @Override
    public void removeChild(IServicePolicy policyToRemove) {
        if (!policyToRemove.isPredefined()) {
            Vector<IServicePolicy> childPolicies = new Vector<IServicePolicy>(policyToRemove.getChildren());
            for (IServicePolicy childPolicy : childPolicies) {
                policyToRemove.removeChild(childPolicy);
            }
            boolean removed = this.children.remove(policyToRemove);
            if (removed) {
                this.platform.removePolicy(policyToRemove);
                this.fireChildChangeEvent(policyToRemove, false);
            }
        }
    }

    @Override
    public IDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new DescriptorImpl();
        }
        return this.descriptor;
    }

    public void setDescriptor(DescriptorImpl descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public IServicePolicy getParentPolicy() {
        return this.parent;
    }

    @Override
    public IPolicyState getPolicyState() {
        return this.policyState;
    }

    @Override
    public IPolicyState getPolicyState(IProject project) {
        PolicyStateImpl projectPolicyState = this.projectPolicyStates.get(project);
        if (projectPolicyState == null) {
            projectPolicyState = new PolicyStateImpl(this, project);
            projectPolicyState.internalSetMutable(this.policyState.isMutable());
            this.projectPolicyStates.put(project, projectPolicyState);
        }
        return projectPolicyState;
    }

    @Override
    public IPolicyStateEnum getPolicyStateEnum() {
        EnumerationStateImpl newEnum = null;
        if (this.enumListId != null) {
            newEnum = new EnumerationStateImpl(this.enumListId, this.defaultEnumId, this.policyState);
        }
        return newEnum;
    }

    @Override
    public IPolicyStateEnum getPolicyStateEnum(IProject project) {
        EnumerationStateImpl newEnum = null;
        if (this.enumListId != null) {
            newEnum = new EnumerationStateImpl(this.enumListId, this.defaultEnumId, this.getPolicyState(project));
        }
        return newEnum;
    }

    public void setPolicyState(PolicyStateImpl policyState) {
        this.policyState = policyState;
    }

    @Override
    public void restoreDefaults() {
        Vector<IServicePolicy> tempChildren = new Vector<IServicePolicy>(this.children);
        for (IServicePolicy child : tempChildren) {
            if (child.isPredefined()) continue;
            this.removeChild(child);
        }
        this.policyState.restoreDefaults();
    }

    @Override
    public void restoreDefaults(IProject project) {
        PolicyStateImpl stateImpl = this.projectPolicyStates.get(project);
        if (stateImpl != null) {
            stateImpl.restoreDefaults();
        }
    }

    @Override
    public List<IPolicyRelationship> getRelationships() {
        return this.relationshipList;
    }

    @Override
    public void setRelationships(List<IPolicyRelationship> relationships) {
        if (!this.predefined) {
            this.relationshipList = relationships;
        }
    }

    public String getEnumListId() {
        return this.enumListId;
    }

    public void setEnumListId(String enumListId) {
        this.enumListId = enumListId;
    }

    public String getDefaultEnumId() {
        return this.defaultEnumId;
    }

    public void setDefaultEnumId(String defaultEnumValue) {
        this.defaultEnumId = defaultEnumValue;
    }

    public void setUnresolvedParent(String parentId) {
        this.unresolvedParent = parentId;
    }

    public void setUnresolvedRelationships(List<UnresolvedRelationship> relationships) {
        this.unresolvedRelationshipList = relationships;
    }

    public void resolve() {
        this.setParent(this.platform.getServicePolicy(this.unresolvedParent));
        for (UnresolvedRelationship relationship : this.unresolvedRelationshipList) {
            List<String> sourceEnumIdList = relationship.getSourceEnumerationList();
            List<UnresolvedPolicyRelationship> targetEnumIdList = relationship.getTargetEnumerationList();
            List<IStateEnumerationItem> sourceEnumList = this.getResolvedEnumList(sourceEnumIdList);
            PolicyEnumerationListImpl sourcePolicyList = new PolicyEnumerationListImpl(sourceEnumList, this);
            Vector<IPolicyEnumerationList> targetPolicyList = new Vector<IPolicyEnumerationList>();
            for (UnresolvedPolicyRelationship targetEnum : targetEnumIdList) {
                ServicePolicyImpl targetPolicy = this.platform.getServicePolicy(targetEnum.getPolicyId());
                List<IStateEnumerationItem> targetList = this.getResolvedEnumList(targetEnum.getEnumList());
                PolicyEnumerationListImpl targetEnumPolicyList = new PolicyEnumerationListImpl(targetList, targetPolicy);
                targetPolicyList.add(targetEnumPolicyList);
                if (targetPolicy != null) continue;
                ServicePolicyActivator.logError("Policy id, " + targetEnum.getPolicyId() + " not found.", null);
            }
            PolicyRelationshipImpl policyRelationship = new PolicyRelationshipImpl(sourcePolicyList, targetPolicyList);
            this.relationshipList.add(policyRelationship);
        }
        this.unresolvedParent = null;
        this.unresolvedRelationshipList = null;
    }

    private List<IStateEnumerationItem> getResolvedEnumList(List<String> enumIdList) {
        Vector<IStateEnumerationItem> enumList = new Vector<IStateEnumerationItem>();
        for (String enumId : enumIdList) {
            enumList.add(this.platform.getStateItemEnumeration(enumId));
        }
        return enumList;
    }

    @Override
    public void addPolicyChildChangeListener(IPolicyChildChangeListener listener) {
        this.childChangeListeners.add(listener);
    }

    @Override
    public void removePolicyChildChangeListener(IPolicyChildChangeListener listener) {
        this.childChangeListeners.remove(listener);
    }

    @Override
    public void addStatusChangeListener(IStatusChangeListener listener) {
        if (this.statusChangeListeners == null) {
            this.statusChangeListeners = new Vector<IStatusChangeListener>();
        }
        this.statusChangeListeners.add(listener);
    }

    @Override
    public void removeStatusChangeListener(IStatusChangeListener listener) {
        if (this.statusChangeListeners != null) {
            this.statusChangeListeners.remove(listener);
        }
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(IStatus status) {
        IStatus oldStatus = this.status;
        this.status = status;
        this.fireStatusChangeEvent(oldStatus, status);
    }

    private void fireStatusChangeEvent(IStatus oldStatus, IStatus newStatus) {
        if (this.statusChangeListeners != null) {
            for (IStatusChangeListener listener : this.statusChangeListeners) {
                listener.statusChange(this, oldStatus, newStatus);
            }
        }
    }

    private void fireChildChangesDuetoDiscard() {
        HashSet<IServicePolicy> childSet = new HashSet<IServicePolicy>(this.children);
        HashSet<IServicePolicy> committedChildSet = new HashSet<IServicePolicy>(this.committedChildren);
        for (IServicePolicy child : childSet) {
            if (committedChildSet.contains(child)) {
                committedChildSet.remove(child);
                continue;
            }
            this.fireChildChangeEvent(child, false);
            this.platform.fireChildChangeEvent(child, false);
        }
        for (IServicePolicy child : committedChildSet) {
            this.fireChildChangeEvent(child, true);
            this.platform.fireChildChangeEvent(child, true);
        }
    }

    private void fireChildChangeEvent(IServicePolicy policy, boolean isAdd) {
        for (IPolicyChildChangeListener listener : this.childChangeListeners) {
            Vector<IServicePolicy> policyList = new Vector<IServicePolicy>(1);
            Vector<Boolean> addedList = new Vector<Boolean>(1);
            policyList.add(policy);
            addedList.add(isAdd);
            listener.childChange(policyList, addedList);
        }
    }
}

