/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xsl.internal.launching.LaunchingPlugin;
import org.eclipse.wst.xsl.internal.launching.Utils;
import org.eclipse.wst.xsl.launching.IProcessorInvoker;

public class ProcessorInvokerDescriptor
implements IProcessorInvoker {
    private final String invokerClass;
    private final String[] classpath;
    private final String id;
    private final String bundleId;

    public ProcessorInvokerDescriptor(String id, String bundleId, String invokerClass, String[] classpath) {
        this.id = id;
        this.bundleId = bundleId;
        this.invokerClass = invokerClass;
        this.classpath = classpath;
    }

    public String[] getClasspathEntries() {
        return ProcessorInvokerDescriptor.createEntries(this.bundleId, this.classpath);
    }

    public static String[] createEntries(String bundleId, String[] classpath) {
        ArrayList<String> entries = new ArrayList<String>();
        try {
            if (Platform.inDevelopmentMode()) {
                entries.add(Utils.getFileLocation(bundleId, "/bin"));
            }
            String[] stringArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                String entry;
                String jar = stringArray[n2];
                if (jar.startsWith("${eclipse_orbit:") && jar.endsWith("}")) {
                    jar = jar.substring("${eclipse_orbit:".length());
                    jar = jar.substring(0, jar.length() - 1);
                    entry = Utils.getPluginLocation(jar);
                } else {
                    entry = Utils.getFileLocation(bundleId, jar);
                }
                if (entry != null) {
                    entries.add(entry);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LaunchingPlugin.log(e);
        }
        return entries.toArray(new String[0]);
    }

    public String getInvokerClassName() {
        return this.invokerClass;
    }

    public String getId() {
        return this.id;
    }
}

