/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.tomcat.tests;

import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentExportDataModelProvider;
import org.eclipse.jst.servlet.tomcat.tests.WebImportOperationTomcatTest;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleImportOperationTest;

public class WebExportOperationTomcatTest
extends ModuleExportOperationTest {
    protected boolean excludeCompileJsp = false;
    protected boolean exportSourceFiles = false;
    protected boolean overwriteExisting = false;
    protected boolean dataModelShouldBeValid = true;
    static /* synthetic */ Class class$0;

    public WebExportOperationTomcatTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.servlet.tomcat.tests.WebExportOperationTomcatTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SimpleTestSuite((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.excludeCompileJsp = false;
    }

    public void testExcludeCompileJspOn() throws Exception {
        this.excludeCompileJsp = true;
        this.testAllExportTestCases();
    }

    protected IDataModel getModelInstance() {
        return DataModelFactory.createDataModel((IDataModelProvider)new WebComponentExportDataModelProvider());
    }

    protected IProject[] getExportableProjects() throws Exception {
        WebExportOperationTomcatTest.deleteAllProjects();
        WebImportOperationTomcatTest importTestCase = (WebImportOperationTomcatTest)this.getImportTestCase();
        importTestCase.testAllImportTestCases();
        IProject[] projs = ProjectUtility.getAllProjects();
        ArrayList<IProject> filteredProjs = new ArrayList<IProject>();
        int i = 0;
        while (i < projs.length) {
            IProject project = projs[i];
            if (J2EEProjectUtilities.isDynamicWebProject((IProject)project)) {
                filteredProjs.add(project);
            }
            ++i;
        }
        return filteredProjs.toArray(new IProject[filteredProjs.size()]);
    }

    public void testAllExportTestCases() throws Exception {
        int i;
        File exportDirectory = new File(BASE_DATA_DIR);
        if (exportDirectory.isDirectory()) {
            File[] contents = exportDirectory.listFiles();
            i = 0;
            while (i < contents.length) {
                if (!contents[i].isDirectory()) {
                    contents[i].delete();
                }
                ++i;
            }
        }
        IProject[] projects = this.getExportableProjects();
        i = 0;
        while (i < projects.length) {
            this.testExport(ComponentCore.createComponent((IProject)projects[i]), this.getFileName(projects[i].getName()));
            ++i;
        }
    }

    public String getFileName(String baseName) {
        StringBuffer result = new StringBuffer(baseName);
        result.append(this.exportSourceFiles ? "_withSource" : "_withoutSource").append(this.getModuleExtension());
        return result.toString();
    }

    public void testExport(IVirtualComponent component, String filename) throws Exception {
        IDataModel dataModel = this.getModelInstance();
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)(String.valueOf(BASE_DATA_DIR) + filename));
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", (Object)component);
        dataModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", this.exportSourceFiles);
        dataModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", this.overwriteExisting);
        if (this.dataModelShouldBeValid) {
            WebExportOperationTomcatTest.runAndVerify((IDataModel)dataModel);
        } else {
            WebExportOperationTomcatTest.verifyInvalidDataModel((IDataModel)dataModel);
        }
    }

    protected ModuleImportOperationTest getImportTestCase() {
        return new WebImportOperationTomcatTest("");
    }

    protected void addJavaFilesToProject(String projectName, String[] classNames, String prackageName) throws Exception {
    }

    protected void verifyJavaFilesExported(String archivePath, String[] classNames, String packageName, boolean withClassFiles, boolean withSource) throws Exception {
    }

    protected IDataModel getExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        return null;
    }

    protected String getModuleExtension() {
        return ".war";
    }
}

