/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.performance;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter;
import org.eclipse.jst.jsp.core.internal.util.DocumentProvider;
import org.eclipse.jst.jsp.ui.tests.performance.util.DateUtil;
import org.eclipse.jst.jsp.ui.tests.performance.util.FileUtil;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AbstractTestPerformance
extends PerformanceTestCase {
    protected boolean testStructuredModel = true;
    protected boolean collectGarbage = false;
    protected Vector fileDataVector = new Vector();
    protected Runtime fRuntime = Runtime.getRuntime();
    protected int fTrials = 3;
    protected String nl = System.getProperty("line.separator");
    protected double PERCENT_DEVIATION = 0.05;
    protected boolean runOnce;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void collectGarbage() {
        this.fRuntime.gc();
    }

    protected void compareResults(String filename, long time, long memory) {
        FileData prev = this.getPreviousResultsForFile(filename);
    }

    protected int countEmbeddedFactories(Document document) {
        int result = 0;
        if (document instanceof IDOMDocument) {
            EmbeddedTypeHandler embeddedHandler;
            PageDirectiveAdapter pageDirectiveAdapter;
            IDOMDocument xmlDocument = (IDOMDocument)document;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((pageDirectiveAdapter = (PageDirectiveAdapter)xmlDocument.getExistingAdapter((Object)clazz)) != null && (embeddedHandler = pageDirectiveAdapter.getEmbeddedType()) != null) {
                result = embeddedHandler.getAdapterFactories().size();
            }
        }
        return result;
    }

    protected int countFactories(IStructuredModel model) {
        int result = 0;
        if (model != null) {
            FactoryRegistry reg = model.getFactoryRegistry();
            result = reg.getFactories().size();
        }
        return result;
    }

    protected int countNodes(Node node) {
        int count = 1;
        Node child = node.getFirstChild();
        while (child != null) {
            count += this.countNodes(child);
            child = child.getNextSibling();
        }
        return count;
    }

    protected int countPropatingFactories(Document document) {
        int result = 0;
        if (document instanceof IDOMDocument) {
            IDOMDocument iDOMDocument = (IDOMDocument)document;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.PropagatingAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PropagatingAdapter pAdapter = (PropagatingAdapter)iDOMDocument.getAdapterFor((Object)clazz);
            result = pAdapter.getAdaptOnCreateFactories().size();
        }
        return result;
    }

    protected void doStructuredModelTest(String filename) throws IOException {
        int nodeCount = 0;
        int nFactories = 0;
        int nPropagatingFactories = 0;
        int nEmbeddedFactories = 0;
        IStructuredModel model = null;
        Object document = null;
        long thisMem = 0L;
        double thisTime = 0.0;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        System.out.println();
        double totalTime = 0.0;
        long totalMem = 0L;
        int i = 0;
        while (i < this.fTrials) {
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            if (this.collectGarbage) {
                this.collectGarbage();
            }
            long startMem = 0L;
            if (this.collectGarbage) {
                startMem = this.fRuntime.totalMemory() - this.fRuntime.freeMemory();
            }
            long startTime = System.currentTimeMillis();
            this.startMeasuring();
            if (this.testStructuredModel) {
                model = modelManager.getModelForEdit(filename, inStream, null);
                document = ((IDOMModel)model).getDocument();
            } else {
                DocumentProvider provider = new DocumentProvider();
                provider.setInputStream(inStream);
                document = provider.getDocument();
            }
            this.stopMeasuring();
            this.commitMeasurements();
            this.assertPerformance();
            long endTime = System.currentTimeMillis();
            long endMem = 0L;
            if (this.collectGarbage) {
                endMem = this.fRuntime.totalMemory() - this.fRuntime.freeMemory();
            }
            thisTime = endTime - startTime;
            if (this.collectGarbage) {
                thisMem = endMem - startMem;
            }
            if (i > 0) {
                totalTime += thisTime;
                if (this.collectGarbage) {
                    totalMem += thisMem;
                }
            } else {
                nodeCount = this.countNodes((Node)document);
                if (this.testStructuredModel) {
                    nFactories = this.countFactories(model);
                    nPropagatingFactories = this.countPropatingFactories((Document)document);
                    nEmbeddedFactories = this.countEmbeddedFactories((Document)document);
                }
            }
            this.markModel(model);
            if (model != null) {
                model.releaseFromEdit();
            }
            if (inStream != null) {
                inStream.close();
            }
            ++i;
        }
        if (this.fTrials > 1) {
            double aveTime = totalTime / (double)(this.fTrials - 1);
            long aveMem = totalMem / (long)(this.fTrials - 1);
            this.printResults(filename, aveTime, aveMem, this.fTrials, nodeCount, nFactories, nPropagatingFactories, nEmbeddedFactories);
        } else {
            this.printResults(filename, thisTime, thisMem, this.fTrials, nodeCount, nFactories, nPropagatingFactories, nEmbeddedFactories);
        }
    }

    protected void markModel(IStructuredModel model) {
    }

    protected FileData getPreviousResultsForFile(String filename) {
        FileData results = null;
        if (this.fileDataVector != null) {
            FileData temp = null;
            int i = this.fileDataVector.size() - 1;
            while (i >= 0) {
                temp = (FileData)this.fileDataVector.get(i);
                if (temp.fFilename.indexOf(filename) > 0) {
                    results = temp;
                    break;
                }
                --i;
            }
        }
        return results;
    }

    protected void printResults(String filename, double aveTime, long aveMem, int nTrials, int nodeCount, int nFactories, int nPropagatingFactories, int nEmbeddedFactories) {
        System.out.println();
        System.out.println("          Model for " + filename);
        System.out.println();
        System.out.println("          Average Time: " + aveTime);
        if (this.collectGarbage) {
            System.out.println();
            System.out.println("          Average Heap Memory: " + aveMem);
        }
        System.out.println();
        System.out.println("          (used " + (nTrials - 1) + " trials)");
        System.out.println("          (N Nodes == " + nodeCount + ")");
        System.out.println("          (N Factories == " + nFactories + ")");
        System.out.println("          (N PropagatingFactories == " + nPropagatingFactories + ")");
        System.out.println("          (N EmbeddedFactories == " + nEmbeddedFactories + ")");
    }

    protected FileData readBlock(BufferedReader br) throws IOException {
        String filename = br.readLine();
        String time = br.readLine();
        String memory = br.readLine();
        return new FileData(filename, time, memory);
    }

    protected void readPreviousResults() throws IOException {
        File rFile = FileUtil.makeFileFor("PerformanceResults", "results.txt", null);
        BufferedReader bReader = new BufferedReader(new FileReader(rFile));
        while (bReader.readLine() != null) {
            this.fileDataVector.add(this.readBlock(bReader));
        }
    }

    protected void saveNewResults(String filename, String time, String memory) throws FileNotFoundException, IOException {
        File fileout = FileUtil.makeFileFor("PerformanceResults", "results.txt", null);
        if (!fileout.isFile()) {
            fileout.createNewFile();
        }
        BufferedWriter bWriter = new BufferedWriter(new FileWriter(fileout.getAbsolutePath(), true));
        bWriter.write("---" + this.nl);
        bWriter.write(String.valueOf(DateUtil.now()) + "-" + filename + this.nl);
        bWriter.write(String.valueOf(time) + this.nl);
        bWriter.write(String.valueOf(memory) + this.nl);
        bWriter.close();
    }

    class FileData {
        public String fFilename;
        public long fMemory;
        public long fType;

        public FileData(String filename, String time, String memory) {
            if (filename != null && time != null && memory != null) {
                this.fType = Long.parseLong(time.trim());
                this.fMemory = Long.parseLong(memory.trim());
                this.fFilename = filename;
            }
        }
    }
}

