/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.tests.unittest;

import java.io.File;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.ws.internal.model.v10.registry.Name;
import org.eclipse.wst.ws.internal.model.v10.registry.Registry;
import org.eclipse.wst.ws.internal.model.v10.registry.RegistryFactory;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.Category;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.Taxonomy;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.TaxonomyFactory;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.Taxonomies;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.UDDIRegistry;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.UDDIRegistryFactory;
import org.eclipse.wst.ws.internal.registry.IRegistryManager;
import org.eclipse.wst.ws.internal.registry.RegistryService;
import org.eclipse.wst.ws.internal.registry.UDDIRegistryService;

public class RegistryTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.ws.tests.unittest.RegistryTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_RegistryService_saveTaxonomy() {
        System.out.println("STARTING test_RegistryService_saveTaxonomy");
        try {
            try {
                System.out.println("Creating RegistryService and Taxonomy");
                RegistryService registryService = RegistryService.instance();
                Taxonomy taxonomy = registryService.newTaxonomy();
                System.out.println("Building a simple Taxonomy model");
                taxonomy.setId("my.taxonomy");
                taxonomy.setName("My Taxonomy");
                EList list = taxonomy.getCategory();
                Category category1 = TaxonomyFactory.eINSTANCE.createCategory();
                category1.setName("My first category");
                category1.setCode("1");
                Category category2 = TaxonomyFactory.eINSTANCE.createCategory();
                category2.setName("My second category");
                category2.setCode("2");
                Category category3 = TaxonomyFactory.eINSTANCE.createCategory();
                category3.setName("My third category");
                category3.setCode("2.1");
                category2.getCategory().add((Object)category3);
                list.add((Object)category1);
                list.add((Object)category2);
                File file = File.createTempFile("taxonomy.", ".xml");
                System.out.println("Saving the Taxonomy model to " + file.getCanonicalPath());
                registryService.saveTaxonomy(file.toURL(), taxonomy);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                RegistryTests.fail((String)("Unexpected Throwable [" + exc.getMessage() + "]"));
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            System.out.println("FINISHED test_RegistryService_saveTaxonomy\n");
            throw throwable;
        }
        {
            Object var8_11 = null;
            System.out.println("FINISHED test_RegistryService_saveTaxonomy\n");
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_RegistryService_saveRegistry() {
        System.out.println("STARTING test_RegistryService_saveRegistry");
        try {
            try {
                System.out.println("Creating RegistryService, UDDIRegistryService and Registry");
                RegistryService registryService = RegistryService.instance();
                UDDIRegistryService uddiRegistryService = UDDIRegistryService.instance();
                UDDIRegistry uddiRegistry = uddiRegistryService.newUDDIRegistry();
                System.out.println("Building a simple Registry model");
                uddiRegistry.setId("my.registry");
                uddiRegistry.setVersion("2.0");
                uddiRegistry.setDiscoveryURL("http://some.discovery.url");
                uddiRegistry.setPublicationURL("http://some.publication.url");
                uddiRegistry.setDefaultLogin("hockeyfanatic");
                Name name = RegistryFactory.eINSTANCE.createName();
                name.setValue("My Registry");
                uddiRegistry.getName().add((Object)name);
                Taxonomy taxonomyRef = registryService.newTaxonomy();
                taxonomyRef.setRef("my.taxonomy");
                Taxonomies t = uddiRegistry.getTaxonomies();
                if (t == null) {
                    t = UDDIRegistryFactory.eINSTANCE.createTaxonomies();
                    uddiRegistry.setTaxonomies(t);
                }
                EList e = t.getTaxonomy();
                e.add((Object)taxonomyRef);
                File file = File.createTempFile("registry.", ".xml");
                System.out.println("Saving the Registry model to " + file.getCanonicalPath());
                registryService.saveRegistry(file.toURL(), (Registry)uddiRegistry);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                RegistryTests.fail((String)("Unexpected Throwable [" + exc.getMessage() + "]"));
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            System.out.println("FINISHED test_RegistryService_saveRegistry\n");
            throw throwable;
        }
        {
            Object var9_12 = null;
            System.out.println("FINISHED test_RegistryService_saveRegistry\n");
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_RegistryManager_saveRegistry() {
        System.out.println("STARTING test_RegistryManager_saveRegistry");
        try {
            try {
                System.out.println("Creating RegistryService and Getting RegistryManager");
                RegistryService registryService = RegistryService.instance();
                IRegistryManager regManager = registryService.getDefaultRegistryManager();
                System.out.println("The location of the default index is " + regManager.getURL());
                System.out.println("Building the hockey Taxonomy model");
                Taxonomy hockeyTaxonomy = registryService.newTaxonomy();
                hockeyTaxonomy.setId("hockey.taxonomy");
                hockeyTaxonomy.setName("hockey Taxonomy");
                EList list = hockeyTaxonomy.getCategory();
                Category category1 = TaxonomyFactory.eINSTANCE.createCategory();
                Category category4 = TaxonomyFactory.eINSTANCE.createCategory();
                category4.setName("Pro");
                category4.setCode("4");
                Category category5 = TaxonomyFactory.eINSTANCE.createCategory();
                category5.setName("AHL");
                category5.setCode("4.1");
                Category category6 = TaxonomyFactory.eINSTANCE.createCategory();
                category6.setName("NHL");
                category6.setCode("4.2");
                category1.setName("Junior");
                category1.setCode("1");
                Category category2 = TaxonomyFactory.eINSTANCE.createCategory();
                category2.setName("Midget");
                category2.setCode("2");
                Category category3 = TaxonomyFactory.eINSTANCE.createCategory();
                category3.setName("Bantam");
                category3.setCode("3");
                category4.getCategory().add((Object)category5);
                category4.getCategory().add((Object)category6);
                list.add((Object)category1);
                list.add((Object)category2);
                list.add((Object)category3);
                list.add((Object)category4);
                Taxonomy hockeyTaxonomyRef = regManager.saveTaxonomy(hockeyTaxonomy);
                System.out.println("Building the hockey Registry model");
                UDDIRegistryService uddiRegistryService = UDDIRegistryService.instance();
                UDDIRegistry uddiRegistry = uddiRegistryService.newUDDIRegistry();
                uddiRegistry.setId("hockey.registry");
                uddiRegistry.setVersion("2.0");
                uddiRegistry.setDefaultLogin("hockeyfanatic");
                uddiRegistry.setDiscoveryURL("http://some.discovery.url");
                uddiRegistry.setPublicationURL("http://some.publication.url");
                Name name = RegistryFactory.eINSTANCE.createName();
                name.setValue("Hockey Registry");
                uddiRegistry.getName().add((Object)name);
                uddiRegistryService.addTaxonomy(uddiRegistry, hockeyTaxonomyRef);
                System.out.println("Saving the hockey Registry model");
                regManager.saveRegistry((Registry)uddiRegistry);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                RegistryTests.fail((String)("Unexpected Throwable [" + exc.getMessage() + "]"));
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            System.out.println("FINISHED test_RegistryManager_saveRegistry\n");
            throw throwable;
        }
        {
            Object var15_18 = null;
            System.out.println("FINISHED test_RegistryManager_saveRegistry\n");
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_RegistryManager_loadRegistry() {
        System.out.println("STARTING test_RegistryManager_loadRegistry");
        try {
            try {
                System.out.println("Creating RegistryService and Getting RegistryManager");
                RegistryService registryService = RegistryService.instance();
                IRegistryManager regManager = registryService.getDefaultRegistryManager();
                String[] registries = regManager.getRegistryURIs();
                RegistryTests.assertEquals((String)("Unexpected number of registries " + registries.length), (int)registries.length, (int)1);
                String uri = registries[0];
                System.out.println("Loading registry " + uri);
                Registry registry = regManager.loadRegistry(uri);
                System.out.println("Found registry " + registry.getId());
                RegistryTests.assertEquals((String)"Did not find hockey registry", (String)"hockey.registry", (String)registry.getId());
                RegistryTests.assertTrue((String)"Registry is not a UDDIRegistry", (boolean)(registry instanceof UDDIRegistry));
                UDDIRegistry uddiRegistry = (UDDIRegistry)registry;
                RegistryTests.assertEquals((String)uddiRegistry.getVersion(), (String)"2.0");
                RegistryTests.assertEquals((String)uddiRegistry.getDefaultLogin(), (String)"hockeyfanatic");
                RegistryTests.assertEquals((String)uddiRegistry.getDiscoveryURL(), (String)"http://some.discovery.url");
                RegistryTests.assertEquals((String)uddiRegistry.getPublicationURL(), (String)"http://some.publication.url");
                UDDIRegistryService uddiRegistryService = UDDIRegistryService.instance();
                Taxonomy[] taxonomies = regManager.loadTaxonomies(uddiRegistryService.getTaxonomyURIs(uddiRegistry));
                RegistryTests.assertEquals((String)("Unexpected number of taxonomies " + taxonomies.length), (int)taxonomies.length, (int)1);
                Taxonomy taxonomy = taxonomies[0];
                System.out.println("Found taxonomy " + taxonomy.getId());
                Assert.assertEquals((String)"Did not find hockey taxonomy", (String)"hockey.taxonomy", (String)taxonomy.getId());
                EList cList = taxonomy.getCategory();
                int i = 0;
                block5: while (i < cList.size()) {
                    Category category = (Category)cList.get(i);
                    System.out.println("Found category " + category.getName());
                    EList c2List = category.getCategory();
                    int j = 0;
                    while (true) {
                        if (j >= c2List.size()) {
                            ++i;
                            continue block5;
                        }
                        Category iCategory = (Category)c2List.get(j);
                        System.out.println("Found subcategory " + iCategory.getName());
                        ++j;
                    }
                }
            }
            catch (Exception t) {
                t.printStackTrace();
                RegistryTests.fail((String)("Unexpected Throwable [" + t.getMessage() + "]"));
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            System.out.println("FINISHED test_RegistryManager_loadRegistry\n");
            throw throwable;
        }
        {
            Object var16_19 = null;
            System.out.println("FINISHED test_RegistryManager_loadRegistry\n");
            return;
        }
    }
}

