/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.contenttypeidentifier.contentspecific;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;

public class TestModelHandlers
extends TestCase {
    private static ModelHandlerRegistry getModelHandlerRegistry() {
        ModelHandlerRegistry registry = ModelHandlerRegistry.getInstance();
        return registry;
    }

    public void testCreation() {
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        TestModelHandlers.assertTrue((String)"model handler registry must exist", (registry != null ? 1 : 0) != 0);
    }

    public void testCSSExists() {
        String id = ContentTypeIdForCSS.ContentTypeID_CSS;
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerForContentTypeId(id);
        TestModelHandlers.assertTrue((String)"model handler registry does not have CSS type ", (handler != null && handler.getAssociatedContentTypeId().equals(id) ? 1 : 0) != 0);
    }

    public void testCSSExistsFromFilename() throws IOException {
        String filename = "test.css";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerFor(filename, null);
        TestModelHandlers.assertTrue((String)"model handler registry does not have CSS type ", (handler != null && handler.getAssociatedContentTypeId().equals(ContentTypeIdForCSS.ContentTypeID_CSS) ? 1 : 0) != 0);
    }

    public void testDTDExists() {
        String id = "org.eclipse.wst.dtd.core.dtdsource";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerForContentTypeId(id);
        TestModelHandlers.assertTrue((String)"model handler registry does not have DTD type ", (handler != null && handler.getAssociatedContentTypeId().equals(id) ? 1 : 0) != 0);
    }

    public void testDTDExistsFromFilename() throws IOException {
        String filename = "test.dtd";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerFor(filename, null);
        TestModelHandlers.assertTrue((String)"model handler registry does not have DTD type ", (handler != null && handler.getAssociatedContentTypeId().equals("org.eclipse.wst.dtd.core.dtdsource") ? 1 : 0) != 0);
    }

    public void testHTMLExists() {
        String id = ContentTypeIdForHTML.ContentTypeID_HTML;
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerForContentTypeId(id);
        TestModelHandlers.assertTrue((String)"model handler registry does not have HTML type ", (handler != null && handler.getAssociatedContentTypeId().equals(id) ? 1 : 0) != 0);
    }

    public void testHTMLExistsFromFilename() throws IOException {
        String filename = "test.html";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerFor(filename, null);
        TestModelHandlers.assertTrue((String)"model handler registry does not have HTML type ", (handler != null && handler.getAssociatedContentTypeId().equals(ContentTypeIdForHTML.ContentTypeID_HTML) ? 1 : 0) != 0);
    }

    public void testJSPExists() {
        String id = ContentTypeIdForJSP.ContentTypeID_JSP;
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerForContentTypeId(id);
        TestModelHandlers.assertTrue((String)"model handler registry does not have JSP type ", (handler != null && handler.getAssociatedContentTypeId().equals(id) ? 1 : 0) != 0);
    }

    public void testJSPExistsFromFilename() throws IOException {
        String filename = "test.jsp";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerFor(filename, null);
        TestModelHandlers.assertTrue((String)"model handler registry does not have JSP type ", (handler != null && handler.getAssociatedContentTypeId().equals(ContentTypeIdForJSP.ContentTypeID_JSP) ? 1 : 0) != 0);
    }

    public void testXMLExists() {
        String id = ContentTypeIdForXML.ContentTypeID_XML;
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerForContentTypeId(id);
        TestModelHandlers.assertEquals((String)"model handler registry does not have XML type ", (String)id, (String)handler.getAssociatedContentTypeId());
    }

    public void testXMLExistsFromFilename() throws IOException {
        String filename = "test.xml";
        ModelHandlerRegistry registry = TestModelHandlers.getModelHandlerRegistry();
        IModelHandler handler = registry.getHandlerFor(filename, null);
        TestModelHandlers.assertEquals((String)"model handler registry does not have XML type ", (String)ContentTypeIdForXML.ContentTypeID_XML, (String)handler.getAssociatedContentTypeId());
    }
}

