/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.web.tests;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.internal.web.operations.AddServletOperation;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassDataModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.SynchronousModelChangedListener;
import org.eclipse.jst.jee.model.tests.TestUtils;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class Web25MergedModelProviderTest
extends TestCase {
    private static IFacetedProject facetedProject;
    private IModelProvider fixture;

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(Web25MergedModelProviderTest.class);
        Web25MergedModelProviderTest.setUpProject();
        return suite;
    }

    protected void setUp() throws Exception {
        Web25MergedModelProviderTest.setUpProject();
        this.fixture = ModelProviderManager.getModelProvider((IProject)facetedProject.getProject());
    }

    public static void setUpProject() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(Web25MergedModelProviderTest.class.getSimpleName());
        if (!project.exists()) {
            facetedProject = AbstractTest.createWebProject(Web25MergedModelProviderTest.class.getSimpleName());
            Web25MergedModelProviderTest.createProjectContent();
        }
    }

    public static void tearDownAfterClass() throws InterruptedException {
        AbstractTest.deleteProject(Web25MergedModelProviderTest.class.getSimpleName());
    }

    private static void createProjectContent() throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)facetedProject.getProject());
        IFolder comFolder = javaProject.getProject().getFolder("src/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testAddServletWithOperation() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new NewServletClassDataModelProvider());
        dataModel.setStringProperty("NewJavaClassDataModel.CLASS_NAME", "testAddServletWithOperation");
        dataModel.setStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", facetedProject.getProject().getName());
        dataModel.setBooleanProperty("NewServletClassDataModel.IS_SERVLET_TYPE", Boolean.TRUE.booleanValue());
        dataModel.setStringProperty("NewJavaClassDataModel.JAVA_PACKAGE", "org.eclipse");
        AddServletOperation operation = new AddServletOperation(dataModel);
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        this.fixture.addListener((IModelProviderListener)listener);
        operation.execute(null, null);
        listener.waitForEvents();
        this.fixture.removeListener((IModelProviderListener)listener);
        WebApp app = (WebApp)this.fixture.getModelObject();
        Web25MergedModelProviderTest.assertEquals((Object)new Integer(1), (Object)new Integer(app.getServlets().size()));
        Web25MergedModelProviderTest.assertNotNull((Object)TestUtils.findServletByName(app, "testAddServletWithOperation"));
    }
}

