/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.jca.operations;

import junit.framework.Test;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentImportDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleImportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.jca.operations.JCAExportOperationTest;

public class JCAImportOperationTest
extends ModuleImportOperationTest {
    public JCAImportOperationTest() {
        super("JCAImportOperationTests");
    }

    public JCAImportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(JCAImportOperationTest.class);
    }

    public void testConnectorImport10_Defaults() throws Exception {
        this.runImportTests_All("Connector10_Defaults");
    }

    public void testConnectorImport15_Defaults() throws Exception {
        this.runImportTests_All("Connector15_Defaults");
    }

    public void testConnectorImport10_WithEAR() throws Exception {
        this.runImportTests_All("Connector10_WithEAR");
    }

    public void testConnectorImport15_WithEAR() throws Exception {
        this.runImportTests_All("Connector15_WithEAR");
    }

    public void testConnectorImport10_DiffSourceFolder() throws Exception {
        this.runImportTests_All("Connector10_DiffSourceFolder");
    }

    public void testConnectorImport15_DiffSourceFolder() throws Exception {
        this.runImportTests_All("Connector15_DiffSourceFolder");
    }

    public void testConnectorImport10_DiffSourceFolder_WithEAR() throws Exception {
        this.runImportTests_All("Connector10_DiffSourceFolder_WithEAR");
    }

    public void testConnectorImport15_DiffSourceFolder_WithEAR() throws Exception {
        this.runImportTests_All("Connector15_DiffSourceFolder_WithEAR");
    }

    protected String getModuleExtension() {
        return ".rar";
    }

    protected IDataModel getImportDataModel(String filePath, String projectName, IOverwriteHandler overwriteHandler, IDataModel creationModel, boolean closeArchiveOnDispose) {
        return JCAImportOperationTest.getJCAImportDataModel(filePath, projectName, overwriteHandler, creationModel, closeArchiveOnDispose);
    }

    public static IDataModel getJCAImportDataModel(String filePath, String projectName, IOverwriteHandler overwriteHandler, IDataModel creationModel, boolean closeArchiveOnDispose) {
        IDataModel importModel = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorComponentImportDataModelProvider());
        importModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)filePath);
        importModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)projectName);
        importModel.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", (Object)closeArchiveOnDispose);
        if (overwriteHandler != null) {
            importModel.setProperty("IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER", (Object)overwriteHandler);
        }
        if (creationModel != null) {
            importModel.setProperty("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION", (Object)creationModel);
        }
        return importModel;
    }

    protected IDataModel getExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        return JCAExportOperationTest.getRARExportDataModel(projectName, destination, exportSource, runBuild, overwriteExisting);
    }
}

