/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.internal.registry;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.internal.registry.MessageMetaData;
import org.eclipse.wst.validation.internal.ValidatorMetaData;

public class TestcaseMetaData {
    private String _pluginId = null;
    private ValidatorMetaData _vmd = null;
    private MessageMetaData[] _messages = null;
    private String _project = null;
    private String[] _resourceNames = null;
    private String _inputFileName = null;
    private String _name = null;

    public TestcaseMetaData(String pluginName, String project, ValidatorMetaData vmd, String inputFileName) {
        this._pluginId = pluginName;
        this._project = project;
        this._vmd = vmd;
        this._inputFileName = inputFileName;
    }

    public String getDeclaringPluginId() {
        return this._pluginId;
    }

    public String getProject() {
        return this._project;
    }

    public IProject findProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this._project);
    }

    public String getInputFileName() {
        return this._inputFileName;
    }

    public int getNumMessages() {
        return this.getMessages().size();
    }

    public List getMessages() {
        ArrayList<MessageMetaData> copy = new ArrayList<MessageMetaData>();
        int i = 0;
        while (i < this._messages.length) {
            copy.add(this._messages[i]);
            ++i;
        }
        return copy;
    }

    public IResource[] getResources(IProject project) {
        HashSet<IResource> temp = new HashSet<IResource>();
        String[] resourceNames = this.getResourceNames();
        int i = 0;
        while (i < resourceNames.length) {
            String resourceName = resourceNames[i];
            IResource resource = project.findMember(resourceName);
            if (resource != null) {
                temp.add(resource);
            }
            ++i;
        }
        IResource[] result = new IResource[temp.size()];
        temp.toArray(result);
        return result;
    }

    public String[] getResourceNames() {
        if (this._resourceNames == null) {
            this._resourceNames = new String[this._messages.length];
            int i = 0;
            while (i < this._messages.length) {
                this._resourceNames[i] = this._messages[i].getResource();
                ++i;
            }
        }
        return this._resourceNames;
    }

    public void setResourceNames(String[] resourceNames) {
        this._resourceNames = resourceNames;
    }

    public void setMessages(MessageMetaData[] messages) {
        this._messages = messages == null ? new MessageMetaData[]{} : messages;
    }

    public ValidatorMetaData getValidatorMetaData() {
        return this._vmd;
    }

    public String getValidatorClass() {
        return this.getValidatorMetaData().getValidatorUniqueName();
    }

    public String getName() {
        if (this._name == null) {
            this._name = String.valueOf(this._vmd.getValidatorDisplayName()) + "::" + this.getProject();
        }
        return this._name;
    }

    public String getInputDir() {
        block4: {
            IPluginRegistry registry = Platform.getPluginRegistry();
            IPluginDescriptor descriptor = registry.getPluginDescriptor(this.getDeclaringPluginId());
            if (descriptor != null) {
                try {
                    File inputDir;
                    String pluginXmlPath = Platform.asLocalURL((URL)new URL(descriptor.getInstallURL(), "plugin.xml")).getPath();
                    File pluginXml = new File(pluginXmlPath);
                    if (pluginXml.exists() && (inputDir = new File(pluginXml.getParent(), "testInput")).exists() && inputDir.isDirectory()) {
                        return inputDir.getPath();
                    }
                }
                catch (IOException exc) {
                    Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.getLevel() != Level.SEVERE) break block4;
                    logger.write(Level.SEVERE, (Exception)exc);
                }
            }
        }
        return System.getProperty("user.dir");
    }
}

