/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.Assert;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockValidationReporter
extends IJSFViewValidator.ReporterAdapter {
    private final List<ReportedProblem> _reportedProblems;
    private Map<Integer, List<ReportedProblem>> _messagesByOffset = new TreeMap<Integer, List<ReportedProblem>>();

    public MockValidationReporter() {
        this._reportedProblems = new ArrayList<ReportedProblem>();
    }

    public void report(Diagnostic diagnostic, int start, int length) {
        ReportedProblem problem = new ReportedProblem(diagnostic, start, length);
        this._reportedProblems.add(problem);
        this.getMessageListForOffset(start).add(problem);
    }

    public void report(IMessage message) {
        ReportedProblem problem = new ReportedProblem(message);
        this._reportedProblems.add(problem);
        this.getMessageListForOffset(message.getOffset()).add(problem);
    }

    public void reset() {
        this._reportedProblems.clear();
        this._messagesByOffset.clear();
    }

    public List<ReportedProblem> getReportedProblems() {
        return Collections.unmodifiableList(this._reportedProblems);
    }

    public List<ReportedProblem> getMessageListForOffset(int offset) {
        List<ReportedProblem> messages = this._messagesByOffset.get(offset);
        if (messages == null) {
            messages = new ArrayList<ReportedProblem>();
            this._messagesByOffset.put(offset, messages);
        }
        return messages;
    }

    public void assertExpectedMessage(int offset, int length, int severity) {
        List<ReportedProblem> reportedProblems = this.getMessageListForOffset(offset);
        ArrayList<ReportedProblem> reportedProblemsNotMatching = new ArrayList<ReportedProblem>();
        Assert.assertTrue((reportedProblems.size() > 0 ? 1 : 0) != 0);
        for (ReportedProblem problem : reportedProblems) {
            if (problem.getLength() == length && problem.getSeverity() == severity) {
                return;
            }
            reportedProblemsNotMatching.add(problem);
        }
        String failMessage = "";
        for (ReportedProblem problem : reportedProblems) {
            failMessage = String.valueOf(failMessage) + "\n" + problem.getText();
        }
        Assert.fail((String)String.format("Failed to find expected message at offset %d, found instead %s", offset, failMessage));
    }

    public static class ReportedProblem {
        private final int _offset;
        private final int _length;
        private final int _severity;
        private final String _text;
        private final int _errorCode;

        public ReportedProblem(Diagnostic problem, int start, int length) {
            this._severity = ReportedProblem.convertSeverity(problem);
            this._offset = start;
            this._length = length;
            this._text = problem.getMessage();
            this._errorCode = problem.getCode();
        }

        private ReportedProblem(IMessage message) {
            this._severity = message.getSeverity();
            this._offset = message.getOffset();
            this._length = message.getLength();
            this._text = message.getText();
            this._errorCode = -1;
        }

        private static int convertSeverity(Diagnostic problem) {
            switch (problem.getSeverity()) {
                case 4: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 1: {
                    return 4;
                }
            }
            return 0;
        }

        public int getOffset() {
            return this._offset;
        }

        public int getLength() {
            return this._length;
        }

        public int getSeverity() {
            return this._severity;
        }

        public String getText() {
            return this._text;
        }

        public int getErrorCode() {
            return this._errorCode;
        }
    }
}

