/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.upload.MultipartRequestWrapper;

public class ActionComponentServlet
extends ActionServlet {
    private DefinitionsFactory definitionsFactory;

    public void init() throws ServletException {
        super.init();
        this.initComponentDefinitionsMapping();
    }

    public void initComponentDefinitionsMapping() throws ServletException {
        try {
            Class plugInClass = TilesUtil.applicationClass("org.apache.struts.action.PlugIn");
            this.log("Warning - ActionComponentServlet class: This class is to be used with Struts1.0.x only. Please modify web.xml to use regular ActionServlet class instead in conjugaison with appropriate plugin declared in struts-config.xml.");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            this.definitionsFactory = DefinitionsUtil.createDefinitionsFactory(this.getServletContext(), this.getServletConfig(), true);
        }
        catch (DefinitionsFactoryException ex) {
            this.log("Fail to load Tiles definition factory from ActionComponentServlet", ex);
            throw new ServletException(ex.getMessage(), (Throwable)ex);
        }
        this.log("Tiles definition factory loaded from ActionComponentServlet");
    }

    protected void processActionForward(ActionForward forward, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (forward != null) {
            String path = forward.getPath();
            if (forward.getRedirect()) {
                if (path.startsWith("/")) {
                    path = request.getContextPath() + path;
                }
                response.sendRedirect(response.encodeRedirectURL(path));
            } else {
                this.doForward(path, request, response);
            }
        }
    }

    protected boolean processValidate(ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String uri;
        if (formInstance == null) {
            return true;
        }
        if (this.debug >= 1) {
            this.log(" Validating input form properties");
        }
        if (request.getParameter("org.apache.struts.taglib.html.CANCEL") != null || request.getParameter("org.apache.struts.taglib.html.CANCEL.x") != null) {
            if (this.debug >= 1) {
                this.log("  Cancelled transaction, no validation");
            }
            return true;
        }
        if (!mapping.getValidate()) {
            return true;
        }
        ActionErrors errors = formInstance.validate(mapping, request);
        if (errors == null || errors.empty()) {
            if (this.debug >= 1) {
                this.log("  No errors detected, accepting input");
            }
            return true;
        }
        if (formInstance.getMultipartRequestHandler() != null) {
            if (this.debug > 1) {
                this.log("  Rolling back the multipart request");
            }
            formInstance.getMultipartRequestHandler().rollback();
        }
        if ((uri = mapping.getInput()) == null) {
            if (this.debug >= 1) {
                this.log("  No input form, but validation returned errors");
            }
            response.sendError(500, this.internal.getMessage("noInput", (Object)mapping.getPath()));
            return false;
        }
        if (this.debug >= 1) {
            this.log("  Validation error(s), redirecting to: " + uri);
        }
        request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        this.doForward(uri, request, response);
        return false;
    }

    protected boolean processForward(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String forward = mapping.getForward();
        if (forward == null) {
            return true;
        }
        this.doForward(forward, request, response);
        return false;
    }

    protected boolean processInclude(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String include = mapping.getInclude();
        if (include == null) {
            return true;
        }
        this.doForward(include, request, response);
        return false;
    }

    protected void processForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doForward(uri, request, response);
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd;
        boolean doInclude = false;
        Controller controller = null;
        ComponentContext tileContext = null;
        try {
            ComponentDefinition definition;
            tileContext = ComponentContext.getContext((ServletRequest)request);
            boolean bl = doInclude = tileContext != null;
            if (this.definitionsFactory != null && (definition = this.definitionsFactory.getDefinition(uri, (ServletRequest)request, this.getServletContext())) != null) {
                uri = definition.getPath();
                controller = definition.getOrCreateController();
                if (tileContext == null) {
                    tileContext = new ComponentContext(definition.getAttributes());
                    ComponentContext.setContext(tileContext, (ServletRequest)request);
                } else {
                    tileContext.addMissing(definition.getAttributes());
                }
            }
            if ((definition = DefinitionsUtil.getActionDefinition((ServletRequest)request)) != null) {
                if (definition.getPath() != null) {
                    uri = definition.getPath();
                }
                if (definition.getOrCreateController() != null) {
                    controller = definition.getOrCreateController();
                }
                if (tileContext == null) {
                    tileContext = new ComponentContext(definition.getAttributes());
                    ComponentContext.setContext(tileContext, (ServletRequest)request);
                } else {
                    tileContext.addMissing(definition.getAttributes());
                }
            }
        }
        catch (InstantiationException ex) {
            throw new ServletException("Can't create associated controller", (Throwable)ex);
        }
        catch (DefinitionsFactoryException ex) {
            throw new ServletException((Throwable)ex);
        }
        if (controller != null) {
            controller.perform(tileContext, request, response, this.getServletContext());
        }
        if ((rd = this.getServletContext().getRequestDispatcher(uri)) == null) {
            response.sendError(500, this.internal.getMessage("requestDispatcher", (Object)uri));
            return;
        }
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        if (doInclude) {
            rd.include((ServletRequest)request, (ServletResponse)response);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

