/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.performance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.wsdl.WSDLException;
import junit.framework.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenEditorOAGISWSDLTestcase
extends PerformanceTestCase {
    public void testReadWSDL() throws MalformedURLException, WSDLException, CoreException, FileNotFoundException {
        File dir;
        String oagis80Dir = System.getProperty("oagis80Dir");
        Assert.assertNotNull((Object)oagis80Dir);
        if (!oagis80Dir.endsWith("/") && !oagis80Dir.endsWith("\\")) {
            oagis80Dir = String.valueOf(oagis80Dir) + "/";
        }
        if ((dir = new File(String.valueOf(oagis80Dir) + "OAGIS8.0")).exists() && dir.isDirectory()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("sp");
            project.create(null);
            project.open(null);
            this.copy(dir, (IContainer)project);
            this.joinBackgroundJobs();
            final ArrayList wsdls = new ArrayList();
            project.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getName().endsWith(".wsdl")) {
                        wsdls.add(proxy.requestResource());
                    }
                    return true;
                }
            }, 1);
            this.tagAsSummary("Open OAGIS WSDL", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
            this.startMeasuring();
            Iterator it = wsdls.iterator();
            while (it.hasNext()) {
                this.openWSDL((IFile)it.next());
            }
            this.stopMeasuring();
            this.commitMeasurements();
            this.assertPerformance();
        } else {
            OpenEditorOAGISWSDLTestcase.fail((String)dir.toString());
        }
    }

    private void copy(File src, IContainer dest) throws CoreException, FileNotFoundException {
        File[] children = src.listFiles();
        int i = 0;
        while (i < children.length) {
            String name = children[i].getName();
            if (children[i].isDirectory()) {
                IFolder folder = dest.getFolder((IPath)new Path(name));
                folder.create(true, true, null);
                this.copy(children[i], (IContainer)folder);
            } else if (name.endsWith(".wsdl") || name.endsWith(".xsd")) {
                IFile file = dest.getFile((IPath)new Path(name));
                file.create((InputStream)new FileInputStream(children[i]), true, null);
            }
            ++i;
        }
    }

    private void joinBackgroundJobs() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    Platform.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                }
                catch (InterruptedException interruptedException) {}
                long start = System.currentTimeMillis();
                Display display = Display.getDefault();
                while (System.currentTimeMillis() - start < 5000L) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    private void openWSDL(IFile file) throws PartInitException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart editor = workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.wst.wsdl.ui.internal.WSDLEditor", true);
        workbenchWindow.getActivePage().closeEditor(editor, false);
    }
}

