package oracle.adfdemo.view.faces.email;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

import oracle.adf.view.faces.context.AdfFacesContext;

/**
 * Backing bean for the "reply-to message" page.
 * @todo For now, the original contents are not included in the reply
 * We could add a preference so the user can choose to include
 * the original contents in replies
 */
public class ReplyToMessageBackingBean extends NewMessageBackingBean
{
  public ReplyToMessageBackingBean()
  {
    // if the user pressed the Reply button, then the processScope's
    // replyToAll value will be false. If the user pressed the 
    // Reply to All button, then the processScope's replyToAll value
    // will be true. We set this in the showMessage.jspx page.
    AdfFacesContext afContext = AdfFacesContext.getCurrentInstance(); 
    
    Object replyToAll = afContext.getProcessScope().get("replyToAll");

    _setUpReplyToMessage("true".equals(replyToAll));
  }
  
  private void _setUpReplyToMessage(boolean replyToAll)
  {
    AdfFacesContext afContext = AdfFacesContext.getCurrentInstance();
      
    MessageData message = 
      (MessageData) afContext.getProcessScope().get("message");
      
    if (message == null) return;
    Message msg = message.getMessage();

    try
    {
        msg.getFolder().open(Folder.READ_ONLY);
        Message replyMessage = msg.reply(replyToAll);
        
        setSubject(replyMessage.getSubject());
        Address[] replyToAddresses = replyMessage.getAllRecipients();
        setTo(_getAddressString(replyToAddresses));

    }
    catch (MessagingException e)
    {
      _LOG.log(Level.WARNING, "Couldn't create reply-to message", e);      
    }
    finally
    {
      
        try
        {
          msg.getFolder().close(false);
        }
        catch (Exception e)
        {
          
        }

    }
  }
  
  /**
   * Given Address[], return a comma-separated string of the email addresses.
   * @param replyToAddresses
   * @return return a comma-separated string of the email addresses.
   */
  private String _getAddressString(Address[] replyToAddresses)
  {

    StringBuffer to = new StringBuffer(100);
    
    for (int i = 0; i < replyToAddresses.length; i++)
    {
      if (i > 0)
        to.append(",");
      to.append(((InternetAddress)replyToAddresses[i]).getAddress());
    }
  
    return to.toString();      

  }

  static private final Logger _LOG =
    Logger.getLogger(ReplyToMessageBackingBean.class.getName());

}
