/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public abstract class NewEnterpriseBeanWizard
extends DataModelWizard
implements INewWizard {
    public NewEnterpriseBeanWizard(IDataModel model) {
        super(model);
    }

    public NewEnterpriseBeanWizard() {
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.getDataModel();
    }

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = J2EEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected void postPerformFinish() throws InvocationTargetException {
        String className = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
        IProject p = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
        IJavaProject javaProject = J2EEEditorUtility.getJavaProject((IProject)p);
        try {
            IFile file = (IFile)javaProject.findType(className).getResource();
            this.openEditor(file);
        }
        catch (JavaModelException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    private void openEditor(final IFile file) {
        if (this.getDataModel().getBooleanProperty("NewJavaClassDataModel.OPEN_IN_EDITOR") && file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        Logger.getLogger().log((Throwable)e);
                    }
                }
            });
        }
    }

    public boolean canFinish() {
        return this.getDataModel().isValid();
    }
}

