/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.runtime.events.IRuntimeLifecycleEvent;
import org.eclipse.wst.common.project.facet.core.runtime.events.IRuntimeLifecycleListener;
import org.eclipse.wst.common.project.facet.core.runtime.events.IValidationStatusChangedEvent;
import org.eclipse.wst.common.project.facet.ui.IDecorationsProvider;
import org.eclipse.wst.common.project.facet.ui.IRuntimeComponentLabelProvider;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.util.BasicToolTip;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;
import org.eclipse.wst.common.project.facet.ui.internal.util.SwtUtil;
import org.osgi.framework.Bundle;

public final class RuntimesPanel
extends Composite {
    private static final Object NO_RUNTIME_SELECTED_PLACEHOLDER = new Object();
    private final IFacetedProjectWorkingCopy fpjwc;
    private boolean showAllRuntimesSetting;
    private final CheckboxTableViewer runtimes;
    private final Button showAllRuntimesCheckbox;
    private final Button makePrimaryButton;
    private final Button newRuntimeButton;
    private final Label runtimeComponentsLabel;
    private final TableViewer runtimeComponents;
    private IRuntime currentPrimaryRuntime;
    private final List<IFacetedProjectListener> listeners = new ArrayList<IFacetedProjectListener>();
    private Color colorGray;
    private final RuntimeValidationAssistant runtimeValidationAssistant;

    public RuntimesPanel(Composite parent, IFacetedProjectWorkingCopy fpjwc) {
        super(parent, 0);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RuntimesPanel.this.handleWidgetDisposed();
            }
        });
        this.runtimeValidationAssistant = new RuntimeValidationAssistant();
        this.fpjwc = fpjwc;
        this.addDataModelListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                RuntimesPanel.this.handleAvailableRuntimesChanged();
            }
        }, IFacetedProjectEvent.Type.AVAILABLE_RUNTIMES_CHANGED);
        this.addDataModelListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                RuntimesPanel.this.handleTargetableRuntimesChanged();
            }
        }, IFacetedProjectEvent.Type.TARGETABLE_RUNTIMES_CHANGED);
        this.addDataModelListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                RuntimesPanel.this.handleTargetedRuntimesChanged();
            }
        }, IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED);
        this.addDataModelListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                RuntimesPanel.this.handlePrimaryRuntimeChanged();
            }
        }, IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED);
        this.showAllRuntimesSetting = false;
        this.colorGray = new Color(null, 160, 160, 164);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.setLayout((Layout)layout);
        this.runtimes = CheckboxTableViewer.newCheckList((Composite)this, (int)2048);
        this.runtimes.getTable().setLayoutData((Object)GridLayoutUtil.gdfill());
        this.runtimes.setContentProvider((IContentProvider)new ContentProvider());
        this.runtimes.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.runtimes.setSorter((ViewerSorter)new Sorter());
        this.runtimes.setInput(new Object());
        new ValidationProblemToolTip((Control)this.runtimes.getTable());
        this.runtimes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                RuntimesPanel.this.handleRuntimeSelectionChanged();
            }
        });
        this.runtimes.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                RuntimesPanel.this.handleCheckStateChanged(e);
            }
        });
        this.showAllRuntimesCheckbox = new Button((Composite)this, 32);
        this.showAllRuntimesCheckbox.setText(Resources.showAllRuntimes);
        this.showAllRuntimesCheckbox.setSelection(this.showAllRuntimesSetting);
        this.showAllRuntimesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimesPanel.this.handleShowAllRuntimesSelected();
            }
        });
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayoutData((Object)GridLayoutUtil.gdhalign(GridLayoutUtil.gd(), 3));
        buttons.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(2), 0, 0));
        this.makePrimaryButton = new Button(buttons, 8);
        this.makePrimaryButton.setText(Resources.makePrimaryLabel);
        GridData gd = GridLayoutUtil.gdwhint(GridLayoutUtil.gd(), SwtUtil.getPreferredWidth((Control)this.makePrimaryButton) + 15);
        this.makePrimaryButton.setLayoutData((Object)gd);
        this.makePrimaryButton.setEnabled(false);
        this.makePrimaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimesPanel.this.handleMakePrimarySelected();
            }
        });
        this.newRuntimeButton = new Button(buttons, 8);
        this.newRuntimeButton.setText(Resources.newRuntimeButtonLabel);
        gd = GridLayoutUtil.gdwhint(GridLayoutUtil.gd(), SwtUtil.getPreferredWidth((Control)this.newRuntimeButton) + 15);
        this.newRuntimeButton.setLayoutData((Object)gd);
        this.newRuntimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimesPanel.this.handleNewRuntimeButtonSelected();
            }
        });
        this.runtimeComponentsLabel = new Label((Composite)this, 0);
        this.runtimeComponentsLabel.setText(Resources.runtimeCompositionLabel);
        this.runtimeComponentsLabel.setLayoutData((Object)GridLayoutUtil.gdhfill());
        Color infoBackgroundColor = parent.getDisplay().getSystemColor(29);
        this.runtimeComponents = new TableViewer((Composite)this, 2048);
        this.runtimeComponents.getTable().setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gdhfill(), 50));
        this.runtimeComponents.getTable().setBackground(infoBackgroundColor);
        this.runtimeComponents.setContentProvider((IContentProvider)new RuntimeComponentsContentProvider());
        this.runtimeComponents.setLabelProvider((IBaseLabelProvider)new RuntimeComponentsLabelProvider());
        this.runtimeComponents.setInput(NO_RUNTIME_SELECTED_PLACEHOLDER);
        this.runtimeComponents.getTable().setEnabled(false);
        this.runtimeComponentsLabel.setEnabled(false);
        this.refresh();
        this.currentPrimaryRuntime = this.fpjwc.getPrimaryRuntime();
        Dialog.applyDialogFont((Control)parent);
    }

    public IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return this.fpjwc;
    }

    private void handleAvailableRuntimesChanged() {
        if (!Thread.currentThread().equals(this.getDisplay().getThread())) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RuntimesPanel.this.handleAvailableRuntimesChanged();
                }
            });
            return;
        }
        if (this.showAllRuntimesSetting) {
            this.refresh();
        }
    }

    private void handleTargetableRuntimesChanged() {
        if (!Thread.currentThread().equals(this.getDisplay().getThread())) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RuntimesPanel.this.handleTargetableRuntimesChanged();
                }
            });
            return;
        }
        this.refresh();
    }

    private void handleTargetedRuntimesChanged() {
        if (!Thread.currentThread().equals(this.getDisplay().getThread())) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RuntimesPanel.this.handleTargetedRuntimesChanged();
                }
            });
            return;
        }
        Set targeted = this.fpjwc.getTargetedRuntimes();
        for (IRuntime r : this.fpjwc.getTargetableRuntimes()) {
            if (targeted.contains(r)) {
                if (this.runtimes.getChecked((Object)r)) continue;
                this.runtimes.setChecked((Object)r, true);
                continue;
            }
            if (!this.runtimes.getChecked((Object)r)) continue;
            this.runtimes.setChecked((Object)r, false);
        }
    }

    private void handlePrimaryRuntimeChanged() {
        if (!Thread.currentThread().equals(this.getDisplay().getThread())) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RuntimesPanel.this.handlePrimaryRuntimeChanged();
                }
            });
            return;
        }
        if (this.currentPrimaryRuntime != null) {
            this.runtimes.update((Object)this.currentPrimaryRuntime, null);
        }
        this.currentPrimaryRuntime = this.fpjwc.getPrimaryRuntime();
        if (this.currentPrimaryRuntime != null) {
            this.runtimes.update((Object)this.currentPrimaryRuntime, null);
        }
    }

    private void handleCheckStateChanged(CheckStateChangedEvent e) {
        IRuntime runtime = (IRuntime)e.getElement();
        if (!this.fpjwc.getTargetableRuntimes().contains(runtime) && e.getChecked()) {
            this.runtimes.setChecked((Object)runtime, false);
            return;
        }
        if (e.getChecked()) {
            this.fpjwc.addTargetedRuntime(runtime);
        } else {
            this.fpjwc.removeTargetedRuntime(runtime);
        }
    }

    private void handleRuntimeSelectionChanged() {
        IRuntime r = this.getSelection();
        if (r == null) {
            if (this.runtimeComponents.getInput() != null) {
                this.runtimeComponentsLabel.setEnabled(false);
                this.runtimeComponents.getTable().setEnabled(false);
                this.runtimeComponents.setInput(NO_RUNTIME_SELECTED_PLACEHOLDER);
            }
        } else {
            if (this.runtimeComponents.getInput() == null || !this.runtimeComponents.getInput().equals(r)) {
                this.runtimeComponentsLabel.setEnabled(true);
                this.runtimeComponents.getTable().setEnabled(true);
                this.runtimeComponents.setInput((Object)r);
            }
            if (this.runtimes.getChecked((Object)r) && this.fpjwc.getPrimaryRuntime() != null && !this.fpjwc.getPrimaryRuntime().equals(r) && this.fpjwc.getTargetableRuntimes().contains(r)) {
                this.makePrimaryButton.setEnabled(true);
            } else {
                this.makePrimaryButton.setEnabled(false);
            }
        }
    }

    private void handleShowAllRuntimesSelected() {
        this.showAllRuntimesSetting = this.showAllRuntimesCheckbox.getSelection();
        this.refresh();
    }

    private void handleMakePrimarySelected() {
        this.fpjwc.setPrimaryRuntime(this.getSelection());
    }

    private void handleNewRuntimeButtonSelected() {
        Bundle serverUiBundle = Platform.getBundle((String)"org.eclipse.wst.server.ui");
        if (serverUiBundle == null) {
            this.newRuntimeButton.setEnabled(false);
            return;
        }
        try {
            Class serverUiPluginClass = serverUiBundle.loadClass("org.eclipse.wst.server.ui.internal.ServerUIPlugin");
            Method method = serverUiPluginClass.getMethod("showNewRuntimeWizard", Shell.class, String.class);
            Object result = method.invoke(null, this.getShell(), null);
            if (result.equals(true)) {
                Thread refreshThread = new Thread(){

                    public void run() {
                        RuntimesPanel.this.getFacetedProjectWorkingCopy().refreshTargetableRuntimes();
                    }
                };
                refreshThread.start();
            }
        }
        catch (Exception e) {
            FacetUiPlugin.log(e);
        }
    }

    private void handleWidgetDisposed() {
        this.removeDataModelListeners();
        this.colorGray.dispose();
        this.runtimeValidationAssistant.dispose();
    }

    private void handleRuntimeValidationResultChanged() {
        Runnable uiRunnable = new Runnable(){

            public void run() {
                TableItem[] tableItemArray = RuntimesPanel.this.runtimes.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    RuntimesPanel.this.runtimes.update(item.getData(), null);
                    ++n2;
                }
            }
        };
        this.getDisplay().syncExec(uiRunnable);
    }

    private void refresh() {
        this.runtimes.refresh();
        HashSet untargetable = new HashSet(RuntimeManager.getRuntimes());
        untargetable.removeAll(this.fpjwc.getTargetableRuntimes());
        this.runtimes.setCheckedElements(this.fpjwc.getTargetedRuntimes().toArray());
    }

    private IRuntime getSelection() {
        IStructuredSelection ssel = (IStructuredSelection)this.runtimes.getSelection();
        if (ssel.isEmpty()) {
            return null;
        }
        return (IRuntime)ssel.getFirstElement();
    }

    private void addDataModelListener(IFacetedProjectListener listener, IFacetedProjectEvent.Type ... types) {
        this.fpjwc.addListener(listener, types);
        this.listeners.add(listener);
    }

    private void removeDataModelListeners() {
        for (IFacetedProjectListener listener : this.listeners) {
            this.fpjwc.removeListener(listener);
        }
    }

    private TableItem getTableItem(int x, int y) {
        TableItem[] tableItemArray = this.runtimes.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getBounds().contains(x, y)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private RuntimeValidationAssistant getRuntimeValidationAssistant() {
        return this.runtimeValidationAssistant;
    }

    private final class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (RuntimesPanel.this.showAllRuntimesSetting) {
                return RuntimeManager.getRuntimes().toArray();
            }
            return RuntimesPanel.this.getFacetedProjectWorkingCopy().getTargetableRuntimes().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private static final class DecoratedRuntimeImageDescriptor
    extends CompositeImageDescriptor {
        private static final String PRIMARY_RUNTIME_OVERLAY_IMG_LOCATION = "images/primary-runtime-overlay.gif";
        private static final ImageData PRIMARY_RUNTIME_OVERLAY = FacetUiPlugin.getImageDescriptor("images/primary-runtime-overlay.gif").getImageData();
        private static final String ERROR_OVERLAY_IMG_LOCATION = "images/error-overlay.gif";
        private static final ImageData ERROR_OVERLAY = FacetUiPlugin.getImageDescriptor("images/error-overlay.gif").getImageData();
        private static final String WARNING_OVERLAY_IMG_LOCATION = "images/warning-overlay.gif";
        private static final ImageData WARNING_OVERLAY = FacetUiPlugin.getImageDescriptor("images/warning-overlay.gif").getImageData();
        private final ImageData base;
        private final Point size;
        private boolean isPrimary;
        private IStatus valResult;

        public DecoratedRuntimeImageDescriptor(ImageDescriptor base, boolean isPrimary, IStatus valResult) {
            this.base = base.getImageData();
            this.size = new Point(this.base.width, this.base.height);
            this.isPrimary = isPrimary;
            this.valResult = valResult;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.base, 0, 0);
            if (this.isPrimary) {
                this.drawImage(PRIMARY_RUNTIME_OVERLAY, width - DecoratedRuntimeImageDescriptor.PRIMARY_RUNTIME_OVERLAY.width, height - DecoratedRuntimeImageDescriptor.PRIMARY_RUNTIME_OVERLAY.height);
            }
            if (this.valResult != null && !this.valResult.isOK()) {
                ImageData valOverlay = this.valResult.getSeverity() == 4 ? ERROR_OVERLAY : WARNING_OVERLAY;
                this.drawImage(valOverlay, 0, height - valOverlay.height);
            }
        }

        protected Point getSize() {
            return this.size;
        }
    }

    private final class LabelProvider
    implements ILabelProvider,
    IColorProvider {
        private final ImageRegistry imageRegistry = new ImageRegistry();

        public String getText(Object element) {
            return ((IRuntime)element).getLocalizedName();
        }

        private String getImageRegistryKey(IRuntime runtime, boolean isPrimary, IStatus validationResult) {
            StringBuilder buf = new StringBuilder();
            buf.append(runtime.getName());
            if (isPrimary) {
                buf.append(",##primary##");
            }
            if (validationResult != null && validationResult.getSeverity() == 4) {
                buf.append(",##error##");
            }
            return buf.toString();
        }

        public Image getImage(Object element) {
            IStatus valResult;
            IRuntime r = (IRuntime)element;
            IRuntimeComponent rc = (IRuntimeComponent)r.getRuntimeComponents().get(0);
            IRuntimeComponentType rct = rc.getRuntimeComponentType();
            IRuntime primary = RuntimesPanel.this.getFacetedProjectWorkingCopy().getPrimaryRuntime();
            boolean isPrimary = primary != null && primary.equals(r);
            String imgid = this.getImageRegistryKey(r, isPrimary, valResult = RuntimesPanel.this.getRuntimeValidationAssistant().getValidationResult(r));
            Image image = this.imageRegistry.get(imgid);
            if (image == null) {
                IDecorationsProvider decprov = (IDecorationsProvider)rct.getAdapter(IDecorationsProvider.class);
                DecoratedRuntimeImageDescriptor imgdesc = new DecoratedRuntimeImageDescriptor(decprov.getIcon(), isPrimary, valResult);
                this.imageRegistry.put(imgid, (ImageDescriptor)imgdesc);
                image = this.imageRegistry.get(imgid);
            }
            if (RuntimesPanel.this.getFacetedProjectWorkingCopy().getTargetableRuntimes().contains(r)) {
                if (RuntimesPanel.this.fpjwc.getTargetedRuntimes().contains(r)) {
                    RuntimesPanel.this.runtimes.setChecked((Object)r, true);
                } else {
                    RuntimesPanel.this.runtimes.setChecked((Object)r, false);
                }
                return image;
            }
            RuntimesPanel.this.runtimes.setChecked((Object)r, false);
            String greyedId = String.valueOf(rct.getId()) + "##greyed##";
            Image greyed = this.imageRegistry.get(greyedId);
            if (greyed == null) {
                greyed = new Image(null, image, 2);
                this.imageRegistry.put(greyedId, greyed);
            }
            return greyed;
        }

        public Color getForeground(Object element) {
            if (!RuntimesPanel.this.getFacetedProjectWorkingCopy().getTargetableRuntimes().contains(element)) {
                return RuntimesPanel.this.colorGray;
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public void dispose() {
            this.imageRegistry.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class Resources
    extends NLS {
        public static String runtimeCompositionLabel;
        public static String makePrimaryLabel;
        public static String newRuntimeButtonLabel;
        public static String showAllRuntimes;
        public static String noRuntimeSelectedLabel;

        static {
            Resources.initializeMessages((String)RuntimesPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private final class RuntimeComponentsContentProvider
    implements IStructuredContentProvider {
        private RuntimeComponentsContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element == NO_RUNTIME_SELECTED_PLACEHOLDER) {
                return new Object[]{NO_RUNTIME_SELECTED_PLACEHOLDER};
            }
            IRuntime r = (IRuntime)element;
            return r.getRuntimeComponents().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class RuntimeComponentsLabelProvider
    implements ILabelProvider {
        private final ImageRegistry imageRegistry = new ImageRegistry();

        private RuntimeComponentsLabelProvider() {
        }

        public String getText(Object element) {
            if (element == NO_RUNTIME_SELECTED_PLACEHOLDER) {
                return Resources.noRuntimeSelectedLabel;
            }
            IRuntimeComponent comp = (IRuntimeComponent)element;
            IRuntimeComponentLabelProvider provider = (IRuntimeComponentLabelProvider)comp.getAdapter(IRuntimeComponentLabelProvider.class);
            if (provider == null) {
                StringBuffer label = new StringBuffer();
                label.append(comp.getRuntimeComponentType().getId());
                label.append(' ');
                label.append(comp.getRuntimeComponentVersion().getVersionString());
                return label.toString();
            }
            return provider.getLabel();
        }

        public Image getImage(Object element) {
            if (element == NO_RUNTIME_SELECTED_PLACEHOLDER) {
                return null;
            }
            IRuntimeComponent rc = (IRuntimeComponent)element;
            IRuntimeComponentType rct = rc.getRuntimeComponentType();
            Image image = this.imageRegistry.get(rct.getId());
            if (image == null) {
                IDecorationsProvider decprov = (IDecorationsProvider)rct.getAdapter(IDecorationsProvider.class);
                this.imageRegistry.put(rct.getId(), decprov.getIcon());
                image = this.imageRegistry.get(rct.getId());
            }
            return image;
        }

        public void dispose() {
            this.imageRegistry.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class RuntimeValidationAssistant {
        private final Map<String, IStatus> validationResults = new HashMap<String, IStatus>();
        private final IRuntimeLifecycleListener runtimeLifecycleListener = new IRuntimeLifecycleListener(){

            public void handleEvent(IRuntimeLifecycleEvent event) {
                IValidationStatusChangedEvent evt = (IValidationStatusChangedEvent)event;
                RuntimeValidationAssistant.this.setValidationResult(evt.getRuntime(), evt.getNewValidationStatus());
                RuntimesPanel.this.handleRuntimeValidationResultChanged();
            }
        };

        public RuntimeValidationAssistant() {
            Thread initialValidationThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    for (IRuntime runtime : RuntimeManager.getRuntimes()) {
                        IStatus result = runtime.validate((IProgressMonitor)new NullProgressMonitor());
                        Map map = RuntimeValidationAssistant.this.validationResults;
                        synchronized (map) {
                            if (RuntimeValidationAssistant.this.getValidationResult(runtime) == null) {
                                RuntimeValidationAssistant.this.setValidationResult(runtime, result);
                            }
                        }
                    }
                    RuntimeManager.addListener((IRuntimeLifecycleListener)RuntimeValidationAssistant.this.runtimeLifecycleListener, (IRuntimeLifecycleEvent.Type[])new IRuntimeLifecycleEvent.Type[]{IRuntimeLifecycleEvent.Type.VALIDATION_STATUS_CHANGED});
                    RuntimesPanel.this.handleRuntimeValidationResultChanged();
                }
            };
            initialValidationThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus getValidationResult(IRuntime runtime) {
            Map<String, IStatus> map = this.validationResults;
            synchronized (map) {
                return this.validationResults.get(runtime.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setValidationResult(IRuntime runtime, IStatus validationResult) {
            Map<String, IStatus> map = this.validationResults;
            synchronized (map) {
                this.validationResults.put(runtime.getName(), validationResult);
            }
        }

        public void dispose() {
            RuntimeManager.removeListener((IRuntimeLifecycleListener)this.runtimeLifecycleListener);
        }
    }

    private final class Sorter
    extends ViewerSorter {
        private Sorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            IRuntime r1 = (IRuntime)a;
            IRuntime r2 = (IRuntime)b;
            return r1.getLocalizedName().compareToIgnoreCase(r2.getLocalizedName());
        }
    }

    private final class ValidationProblemToolTip
    extends BasicToolTip {
        public ValidationProblemToolTip(Control control) {
            super(control);
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            IStatus validationResult = this.getValidationResult(event);
            this.setMessage(validationResult.getMessage());
            return super.createToolTipContentArea(event, parent);
        }

        protected boolean shouldCreateToolTip(Event event) {
            return !this.getValidationResult(event).isOK();
        }

        private IRuntime getRuntime(Event event) {
            TableItem item = RuntimesPanel.this.getTableItem(event.x, event.y);
            return item != null ? (IRuntime)item.getData() : null;
        }

        private IStatus getValidationResult(Event event) {
            IRuntime runtime = this.getRuntime(event);
            IStatus result = null;
            if (runtime != null) {
                result = RuntimesPanel.this.runtimeValidationAssistant.getValidationResult(runtime);
            }
            if (result == null) {
                result = Status.OK_STATUS;
            }
            return result;
        }
    }
}

