/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.internal.NullDatabase;
import org.eclipse.jpt.utility.internal.ClassTools;

final class NullConnectionProfile
implements ConnectionProfile {
    private static final String EMPTY_STRING = "";
    private static final NullConnectionProfile INSTANCE = new NullConnectionProfile();

    static ConnectionProfile instance() {
        return INSTANCE;
    }

    private NullConnectionProfile() {
    }

    public void connect() {
    }

    public void disconnect() {
    }

    public IStatus saveWorkOfflineData() {
        return Status.CANCEL_STATUS;
    }

    public IStatus workOffline() {
        return Status.CANCEL_STATUS;
    }

    public Database getDatabase() {
        return NullDatabase.instance();
    }

    public String getName() {
        return ClassTools.shortClassNameForObject((Object)this);
    }

    public String getDatabaseName() {
        return EMPTY_STRING;
    }

    public String getDatabaseProduct() {
        return EMPTY_STRING;
    }

    public String getDatabaseVendor() {
        return EMPTY_STRING;
    }

    public String getDatabaseVersion() {
        return EMPTY_STRING;
    }

    public String getUserName() {
        return EMPTY_STRING;
    }

    public String getUserPassword() {
        return EMPTY_STRING;
    }

    public String getDriverClassName() {
        return EMPTY_STRING;
    }

    public String getUrl() {
        return EMPTY_STRING;
    }

    public String getInstanceID() {
        return EMPTY_STRING;
    }

    public String getProviderID() {
        return EMPTY_STRING;
    }

    public String getDriverDefinitionID() {
        return EMPTY_STRING;
    }

    public String getDriverJarList() {
        return EMPTY_STRING;
    }

    public boolean isActive() {
        return false;
    }

    public boolean isWorkingOffline() {
        return false;
    }

    public boolean isConnected() {
        return false;
    }

    public boolean supportsWorkOfflineMode() {
        return false;
    }

    public boolean canWorkOffline() {
        return false;
    }

    public void addConnectionListener(ConnectionListener listener) {
    }

    public void removeConnectionListener(ConnectionListener listener) {
    }

    public Schema getDefaultSchema() {
        return null;
    }

    public Catalog getDefaultCatalog() {
        return null;
    }

    public boolean isNull() {
        return true;
    }

    public int compareTo(ConnectionProfile o) {
        throw new UnsupportedOperationException("the \"null\" connection profile should not be in a sorted list");
    }

    public String toString() {
        return ClassTools.toStringClassNameForObject((Object)this);
    }
}

