/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.widget.AbstractWidgetProvider;

public class RadioWidgetProvider
extends AbstractWidgetProvider {
    private boolean isChecked;

    public RadioWidgetProvider(ICSSStyle style) {
        super(style);
    }

    public DimensionInfo getPreferredDimension(int width, int height) {
        if (width <= 0) {
            width = this.getDefaultWidth();
        }
        if (height <= 0) {
            height = this.getDefaultWidth();
        }
        return new DimensionInfo(width, height, height * 4 / 5);
    }

    public void paintFigure(Graphics g, Rectangle rect) {
        int centerX = rect.x + rect.width / 2;
        int centerY = rect.y + rect.height / 2;
        int width = Math.min(rect.width, rect.height);
        int cycleWidth = width * 3 / 5;
        int lineWidth = 2;
        g.setLineWidth(lineWidth);
        g.setForegroundColor(ColorConstants.buttonDarker);
        g.drawArc(centerX - cycleWidth / 2, centerY - cycleWidth + 1, cycleWidth, cycleWidth, 45, 180);
        g.setForegroundColor(ColorConstants.button);
        g.drawArc(centerX - cycleWidth / 2, centerY - cycleWidth + 1, cycleWidth, cycleWidth, 225, 180);
        cycleWidth += 2 * lineWidth - 2;
        ++lineWidth;
        if (cycleWidth < width) {
            g.setForegroundColor(ColorConstants.buttonDarkest);
            g.drawArc(centerX - cycleWidth / 2, centerY - cycleWidth + 1, cycleWidth, cycleWidth, 45, 180);
        }
        if (this.isChecked()) {
            g.setBackgroundColor(ColorConstants.black);
            g.fillArc(centerX - 1, centerY - cycleWidth / 2 - 1, 4, 4, 0, 360);
        }
    }

    public final int getDefaultWidth() {
        return 15;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }
}

