/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ResourceHandler {
    private static ResourceBundle _bundle = null;

    protected ResourceHandler() {
    }

    public static ResourceBundle getBundle() {
        block3: {
            if (_bundle == null) {
                try {
                    _bundle = ResourceBundle.getBundle(ValidationPlugin.getBundlePropertyFileName());
                }
                catch (MissingResourceException missingResourceException) {
                    _bundle = null;
                    if (!Tracing.isLogging()) break block3;
                    Tracing.log("ResourceHandler-01", "Cannot find bundle " + ValidationPlugin.getBundlePropertyFileName());
                }
            }
        }
        return _bundle;
    }

    public static String getExternalizedMessage(String key) {
        try {
            ResourceBundle bundle = ResourceHandler.getBundle();
            if (bundle == null) {
                Tracing.log("ResourceHandler-02: ", "Resource bundle is null");
                return key;
            }
            return bundle.getString(key);
        }
        catch (NullPointerException nullPointerException) {
            Tracing.log("ResourceHandler-03: ", "Cannot find message id ", key);
            return key;
        }
    }

    public static String getExternalizedMessage(String key, String[] parms) {
        String res;
        block3: {
            res = "";
            try {
                res = MessageFormat.format(ResourceHandler.getExternalizedMessage(key), parms);
            }
            catch (MissingResourceException missingResourceException) {
                Tracing.log("ResourceHandler-04: ", "Cannot find message id ", key);
            }
            catch (NullPointerException nullPointerException) {
                if (!Tracing.isLogging()) break block3;
                Tracing.log("ResourceHandler-05: Cannot format message id " + key + " with " + parms.length + " parameters.");
            }
        }
        return res;
    }
}

