/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRenderer;
import org.eclipse.wst.common.internal.emf.resource.IDTranslator;
import org.eclipse.wst.common.internal.emf.resource.LinkUpdaterTarget;
import org.eclipse.wst.common.internal.emf.resource.ReadAheadHelper;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.resource.VariableTranslatorFactory;
import org.eclipse.wst.common.internal.emf.utilities.Assert;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.common.internal.emf.utilities.FeatureValueConversionException;
import org.eclipse.wst.common.internal.emf.utilities.Revisit;
import org.eclipse.wst.common.internal.emf.utilities.StringUtil;
import org.eclipse.wst.common.internal.emf.utilities.TranslatorService;
import org.eclipse.wst.common.internal.emf.utilities.WFTUtilsResourceHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EMF2DOMAdapterImpl
extends AdapterImpl
implements EMF2DOMAdapter {
    protected static final boolean fDebug = false;
    protected boolean fNotificationEnabled = true;
    protected Node fNode;
    protected Translator fTranslator;
    protected EMF2DOMRenderer fRenderer;
    protected Translator[] childTranslators;
    protected boolean isRoot = false;
    private static final String PLATFORM = "org.eclipse.core.runtime.Platform";
    private static final String ISRUNNING = "isRunning";

    public EMF2DOMAdapterImpl(TranslatorResource resource, Document document, EMF2DOMRenderer renderer, Translator translator) {
        this((Notifier)resource, (Node)document, renderer, translator);
        this.isRoot = true;
    }

    public EMF2DOMAdapterImpl(Notifier object, Node node, EMF2DOMRenderer renderer, Translator translator) {
        this.setTarget(object);
        this.fNode = node;
        this.fRenderer = renderer;
        this.fTranslator = translator;
        this.initChildTranslators();
        this.addEMFAdapter();
        this.addDOMAdapter();
        this.addDependencyAdapterIfNecessary();
    }

    public EMF2DOMAdapterImpl(Node node, EMF2DOMRenderer renderer, Translator translator) {
        this.fNode = node;
        this.fRenderer = renderer;
        this.fTranslator = translator;
        this.setTargetFromNode();
        this.initChildTranslators();
        this.addEMFAdapter();
        this.addDOMAdapter();
        this.addDependencyAdapterIfNecessary();
    }

    protected void addDependencyAdapterIfNecessary() {
        if (!this.fTranslator.isDependencyParent()) {
            return;
        }
        EObject child = this.fTranslator.basicGetDependencyObject(this.getEObject());
        if (child != null) {
            this.addDependencyAdapter(child);
        }
    }

    protected void initChildTranslators() {
        ArrayList<Translator> children = new ArrayList<Translator>();
        boolean isRunning = false;
        try {
            Class<?> clazz = Class.forName(PLATFORM);
            Method m = clazz.getMethod(ISRUNNING, null);
            isRunning = (Boolean)m.invoke(clazz, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (isRunning) {
            Translator[] extendedChildren = TranslatorService.getInstance().getTranslators();
            int i = 0;
            while (i < extendedChildren.length) {
                if (extendedChildren[i] != null) {
                    children.add(extendedChildren[i]);
                }
                ++i;
            }
        }
        children.addAll(Arrays.asList(this.fTranslator.getChildren(this.getTarget(), this.fRenderer.getVersionID())));
        VariableTranslatorFactory factory = this.fTranslator.getVariableTranslatorFactory();
        if (factory != null) {
            List childrenFromEMF;
            String domName = null;
            NamedNodeMap map = this.fNode.getAttributes();
            if (map != null) {
                int length = map.getLength();
                int i = 0;
                while (i < length) {
                    Node attrNode = map.item(i);
                    domName = attrNode.getNodeName();
                    Translator t = this.fTranslator.findChild(domName, this.getTarget(), this.fRenderer.getVersionID());
                    if (t != null && !children.contains(t)) {
                        children.add(t);
                    }
                    ++i;
                }
            }
            if ((childrenFromEMF = factory.create(this.getTarget())) != null) {
                children.addAll(childrenFromEMF);
            }
        }
        this.childTranslators = children.toArray(new Translator[children.size()]);
    }

    public boolean isNotificationEnabled() {
        return this.fNotificationEnabled;
    }

    public void setNotificationEnabled(boolean isEnabled) {
        this.fNotificationEnabled = isEnabled;
    }

    public boolean isAdapterForType(Object type) {
        return EMF2DOMAdapter.ADAPTER_CLASS == type;
    }

    protected void addEMFAdapter() {
        this.target.eAdapters().add((Object)this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.shortClassName(this));
        sb.append('(');
        sb.append(this.getNode().getNodeName());
        sb.append(',');
        sb.append(this.shortClassName(this.getTarget()));
        sb.append(')');
        return sb.toString();
    }

    protected String shortClassName(Object o) {
        if (o != null) {
            String cn = o.getClass().getName();
            int i = cn.lastIndexOf(46);
            return cn.substring(i + 1, cn.length());
        }
        return null;
    }

    protected void debugMOFNotify(Notification msg) {
    }

    protected Translator[] getChildTranslators() {
        return this.childTranslators;
    }

    protected Translator findTranslator(Notification not) {
        if (not.getFeature() == null) {
            return null;
        }
        Translator[] maps = this.getChildTranslators();
        int i = 0;
        while (i < maps.length) {
            if (maps[i].isMapFor(not.getFeature(), not.getOldValue(), not.getNewValue())) {
                return maps[i];
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void primUpdateDOMMultiFeature(Translator map, Node node, List mofChildren, List domChildren, Notifier owner) {
        ArrayList<Element> inorderDOMChildren = null;
        if (!map.isObjectMap() || map.isManagedByParent()) {
            inorderDOMChildren = new ArrayList<Element>();
            inorderDOMChildren.addAll(domChildren);
        }
        Node parent = this.findDOMPath(node, map, false);
        int i = 0;
        while (i < mofChildren.size()) {
            block12: {
                Node newNode;
                Node insertBeforeNode;
                EMF2DOMAdapter adapter;
                EObject mofChild;
                Object child;
                block13: {
                    child = mofChildren.get(i);
                    mofChild = null;
                    adapter = null;
                    if (!map.isManagedByParent() && child instanceof EObject) {
                        mofChild = (EObject)mofChildren.get(i);
                        adapter = this.getExistingAdapter(mofChild);
                    }
                    if (adapter != null && i < domChildren.size() && domChildren.get(i) == adapter.getNode()) break block12;
                    if (adapter == null) break block13;
                    if (!domChildren.isEmpty()) {
                        Node reorderNode;
                        insertBeforeNode = reorderNode = adapter.getNode();
                        if (i < domChildren.size() && domChildren.get(i) != reorderNode) {
                            insertBeforeNode = (Node)domChildren.get(i);
                        }
                        domChildren.remove(reorderNode);
                        domChildren.add(i, reorderNode);
                        if (reorderNode != insertBeforeNode) {
                            this.reorderDOMChild(parent, reorderNode, insertBeforeNode, map);
                        }
                    }
                    break block12;
                }
                parent = this.createDOMPath(node, map);
                if (mofChild != null) {
                    Object var15_16;
                    adapter = this.createAdapter(mofChild, map);
                    newNode = adapter.getNode();
                    insertBeforeNode = this.findInsertBeforeNode(parent, map, mofChildren, i, domChildren);
                    DOMUtilities.insertBeforeNodeAndWhitespace(parent, newNode, insertBeforeNode);
                    domChildren.add(i, newNode);
                    boolean notificationFlag = adapter.isNotificationEnabled();
                    adapter.setNotificationEnabled(false);
                    try {
                        this.indent(newNode, map);
                    }
                    catch (Throwable throwable) {
                        var15_16 = null;
                        adapter.setNotificationEnabled(notificationFlag);
                        throw throwable;
                    }
                    {
                        var15_16 = null;
                        adapter.setNotificationEnabled(notificationFlag);
                        adapter.updateDOM();
                        break block12;
                    }
                }
                newNode = this.createNewNode(null, map);
                insertBeforeNode = this.findInsertBeforeNode(parent, map, mofChildren, i, inorderDOMChildren);
                DOMUtilities.insertBeforeNodeAndWhitespace(parent, newNode, insertBeforeNode);
                this.indent(newNode, map);
                this.addDOMAdapter(newNode);
                domChildren.add(i, newNode);
                inorderDOMChildren.add((Element)newNode);
                Text newText = parent.getOwnerDocument().createTextNode(map.convertValueToString(child, (EObject)owner));
                DOMUtilities.insertBeforeNode(newNode, newText, null);
            }
            ++i;
        }
        while (true) {
            if (i >= domChildren.size()) {
                if (mofChildren.size() != 0) return;
                if (!map.hasDOMPath()) return;
                if (!map.shouldRenderEmptyDOMPath((EObject)owner)) break;
                this.createDOMPath(node, map);
                return;
            }
            this.removeDOMChild(parent, (Element)domChildren.get(i));
            ++i;
        }
        this.removeDOMPath(node, map);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void primUpdateMOFMultiFeature(Translator map, Node node, List mofChildren, List domChilren) {
        Hashtable<Node, EMF2DOMAdapter> nodeToAdapter = new Hashtable<Node, EMF2DOMAdapter>();
        int i = 0;
        while (true) {
            if (i >= mofChildren.size()) break;
            EMF2DOMAdapter adapter = this.getExistingAdapter((EObject)mofChildren.get(i));
            if (adapter != null) {
                nodeToAdapter.put(adapter.getNode(), adapter);
            }
            ++i;
        }
        i = 0;
        int mofIndex = 0;
        ArrayList<EMF2DOMAdapter> adaptersToUpdate = new ArrayList<EMF2DOMAdapter>();
        while (true) {
            EMF2DOMAdapter adapter;
            if (i >= domChilren.size()) break;
            Element childNode = (Element)domChilren.get(i);
            EMF2DOMAdapter eMF2DOMAdapter = adapter = i < mofChildren.size() ? this.getExistingAdapter((EObject)mofChildren.get(i)) : null;
            if (adapter != null && !adapter.isMOFProxy() && adapter.getNode() == childNode) {
                adapter.updateMOF();
                ++mofIndex;
            } else {
                adapter = (EMF2DOMAdapter)nodeToAdapter.get(childNode);
                if (adapter != null) {
                    this.reorderIfNecessary((EList)mofChildren, adapter.getEObject(), mofIndex);
                    ++mofIndex;
                } else {
                    adapter = this.createAdapter(childNode, map);
                    if (adapter != null) {
                        Object var11_13;
                        try {
                            adapter.setNotificationEnabled(false);
                            map.setMOFValue(this.getTarget(), adapter.getTarget(), mofIndex);
                        }
                        catch (Throwable throwable) {
                            var11_13 = null;
                            adapter.setNotificationEnabled(true);
                            throw throwable;
                        }
                        {
                            var11_13 = null;
                            adapter.setNotificationEnabled(true);
                            adaptersToUpdate.add(adapter);
                        }
                        ++mofIndex;
                    }
                }
            }
            ++i;
        }
        Object[] childrenArray = mofChildren.toArray();
        while (true) {
            if (i >= childrenArray.length) break;
            this.removeMOFValue((EObject)childrenArray[i], map);
            ++i;
        }
        int j = 0;
        while (j < adaptersToUpdate.size()) {
            ((EMF2DOMAdapter)adaptersToUpdate.get(j)).updateMOF();
            ++j;
        }
        return;
    }

    protected void removeMOFValue(EObject value, Translator translator) {
        EStructuralFeature feature;
        boolean doUnload;
        if (value == null) {
            return;
        }
        EMF2DOMAdapter adapter = (EMF2DOMAdapter)EcoreUtil.getExistingAdapter((Notifier)value, (Object)EMF2DOMAdapter.ADAPTER_CLASS);
        if (adapter != null) {
            value.eAdapters().remove((Object)adapter);
            this.removeAdapters(adapter.getNode());
        }
        boolean bl = doUnload = (feature = translator.getFeature()) == null || translator.isObjectMap() && ((EReference)feature).isContainment();
        if (doUnload) {
            ExtendedEcoreUtil.unload(value);
        }
        translator.removeMOFValue(this.getTarget(), value);
    }

    protected void reorderIfNecessary(EList emfChildren, EObject eObj, int emfIndex) {
        int currIndex = emfChildren.indexOf((Object)eObj);
        if (currIndex > -1 && currIndex != emfIndex) {
            emfChildren.move(emfIndex, (Object)eObj);
        }
    }

    protected void indent(Node newNode, Translator map) {
    }

    protected Node findInsertBeforeNode(Node parentNode, Translator map, List mofList, int mofInx, List domList) {
        Node insertBeforeNode = null;
        if (domList.size() == 0) {
            return this.findInitialInsertBeforeNode(parentNode, map);
        }
        int i = mofInx + 1;
        while (i < mofList.size() && insertBeforeNode == null) {
            Object o = mofList.get(i);
            if (!map.isObjectMap() || map.isManagedByParent()) break;
            EObject tMOFObject = (EObject)o;
            EMF2DOMAdapter tAdapter = (EMF2DOMAdapter)EcoreUtil.getExistingAdapter((Notifier)tMOFObject, (Object)EMF2DOMAdapter.ADAPTER_CLASS);
            if (tAdapter != null) {
                insertBeforeNode = tAdapter.getNode();
            }
            ++i;
        }
        if (insertBeforeNode == null) {
            insertBeforeNode = DOMUtilities.getNextNodeSibling((Node)domList.get(domList.size() - 1));
        }
        if (insertBeforeNode == null) {
            insertBeforeNode = ((Node)domList.get(domList.size() - 1)).getNextSibling();
        }
        return insertBeforeNode;
    }

    protected Node findInitialInsertBeforeNode(Node parentNode, Translator mapNode) {
        Translator[] maps = this.getChildTranslators();
        int i = 0;
        while (i < maps.length) {
            if (maps[i] == mapNode) break;
            ++i;
        }
        Node insertBeforeNode = null;
        int j = i;
        while (j < maps.length && insertBeforeNode == null) {
            NodeList childNodes = parentNode.getChildNodes();
            Translator nodeToFindMap = maps[j];
            int k = 0;
            while (k < childNodes.getLength()) {
                Node node = childNodes.item(k);
                if (nodeToFindMap.isMapFor(node.getNodeName())) {
                    insertBeforeNode = node;
                    break;
                }
                ++k;
            }
            ++j;
        }
        return insertBeforeNode;
    }

    protected Node findDOMPath(Node parent, Translator map, boolean addAdapters) {
        String path = map.getDOMPath();
        Node curNode = parent;
        Iterator iter = DOMUtilities.createPathIterator(path);
        while (curNode != null && iter.hasNext()) {
            String nodeName = (String)iter.next();
            curNode = DOMUtilities.getNodeChild(curNode, nodeName);
            if (!addAdapters || curNode == null) continue;
            this.addDOMAdapter(curNode);
        }
        return curNode;
    }

    protected List getDOMChildren(Node node, Translator map) {
        Node parent = this.findDOMPath(node, map, true);
        if (parent != null) {
            return DOMUtilities.getNodeChildren(parent, map.getDOMNames());
        }
        return new ArrayList();
    }

    protected EMF2DOMAdapter getExistingAdapter(EObject refObject) {
        EMF2DOMAdapter adapter = (EMF2DOMAdapter)EcoreUtil.getExistingAdapter((Notifier)refObject, (Object)EMF2DOMAdapter.ADAPTER_CLASS);
        if (adapter != null && adapter.isMOFProxy()) {
            refObject.eAdapters().remove((Object)adapter);
            this.removeDOMAdapter(adapter.getNode(), adapter);
            adapter = null;
        }
        return adapter;
    }

    protected void primAddDOMAdapter(Node aNode, EMF2DOMAdapter anAdapter) {
        this.fRenderer.registerDOMAdapter(aNode, anAdapter);
    }

    protected EMF2DOMAdapter primGetExistingAdapter(Node aNode) {
        return this.fRenderer.getExistingDOMAdapter(aNode);
    }

    protected void removeDOMAdapter(Node aNode, EMF2DOMAdapter anAdapter) {
        this.fRenderer.removeDOMAdapter(aNode, anAdapter);
    }

    protected void addDOMAdapter(Node childNode) {
        EMF2DOMAdapter attrAdapter;
        if (childNode.getNodeType() == 1 && ((attrAdapter = this.primGetExistingAdapter(childNode)) == null || attrAdapter.getNode() != this.getNode())) {
            this.removeDOMAdapter(childNode, attrAdapter);
            this.primAddDOMAdapter(childNode, this);
        }
    }

    protected void reorderDOMChild(Node parentNode, Node childNode, Node insertBeforeNode, Translator map) {
        try {
            this.removeDOMChild(parentNode, childNode, false);
            parentNode.insertBefore(childNode, insertBeforeNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getNewlineString(Node node) {
        return DOMUtilities.NEWLINE_STRING;
    }

    protected String primGetIndentString(Node node) {
        return DOMUtilities.getIndentString(node);
    }

    protected void removeDOMChild(Node parentNode, Node childNode) {
        this.removeDOMChild(parentNode, childNode, true);
    }

    protected void removeDOMChild(Node parentNode, Node childNode, boolean removeAdapter) {
        try {
            if (childNode == null) {
                return;
            }
            Text prevText = DOMUtilities.getPreviousTextSibling(childNode);
            if (prevText != null && DOMUtilities.isWhitespace(prevText)) {
                parentNode.removeChild(prevText);
            }
            if (removeAdapter) {
                this.removeAdapters(childNode);
            }
            parentNode.removeChild(childNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeAdapters(Node node) {
        EMF2DOMAdapter adapter = this.primGetExistingAdapter(node);
        if (adapter != null) {
            Notifier localTarget;
            this.removeDOMAdapter(node, adapter);
            if (adapter.getNode() == node && (localTarget = adapter.getTarget()) != null) {
                localTarget.eAdapters().remove((Object)adapter);
            }
        }
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            this.removeAdapters(n);
            ++i;
        }
    }

    protected Node createDOMPath(Node node, Translator map) {
        Iterator i = DOMUtilities.createPathIterator(map.getDOMPath());
        Node curNode = node;
        while (i.hasNext()) {
            String nodeName = (String)i.next();
            curNode = this.findOrCreateNode(node, map, nodeName);
        }
        return curNode;
    }

    protected Element findOrCreateNode(Node parent, Translator map, String segment) {
        Node node = DOMUtilities.getNodeChild(parent, segment);
        if (node == null) {
            Document doc = parent.getOwnerDocument();
            node = doc.createElement(segment);
            if (map.isEmptyTag()) {
                this.setEmptyTag((Element)node);
            }
            Node insertBeforeNode = this.findInitialInsertBeforeNode(parent, map);
            DOMUtilities.insertBeforeNodeAndWhitespace(parent, node, insertBeforeNode);
            this.indent(node, map);
            this.addDOMAdapter(node);
        }
        return (Element)node;
    }

    protected void removeIfEmpty(Node node) {
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node childNode = nl.item(i);
            if (!DOMUtilities.isWhitespace(childNode)) {
                return;
            }
            ++i;
        }
        this.removeDOMChild(node.getParentNode(), node);
    }

    protected void removeDOMPath(Node node, Translator map) {
        Node childNode = this.findDOMPath(node, map, false);
        while (childNode != null && childNode != node) {
            this.removeIfEmpty(childNode);
            childNode = childNode.getParentNode();
        }
    }

    protected EMF2DOMAdapter createAdapter(EObject mofObject, Translator childMap) {
        Assert.isNotNull(mofObject);
        EMF2DOMAdapter adapter = (EMF2DOMAdapter)EcoreUtil.getAdapter((List)mofObject.eAdapters(), (Object)EMF2DOMAdapter.ADAPTER_CLASS);
        if (adapter != null && adapter.isMOFProxy()) {
            mofObject.eAdapters().remove((Object)adapter);
            this.removeAdapters(adapter.getNode());
            adapter = null;
        }
        if (adapter == null) {
            adapter = this.primCreateAdapter(mofObject, childMap);
        }
        return adapter;
    }

    protected EMF2DOMAdapter primCreateAdapter(EObject mofObject, Translator childMap) {
        Element newNode = this.createNewNode(mofObject, childMap);
        return new EMF2DOMAdapterImpl((Notifier)mofObject, newNode, this.fRenderer, childMap);
    }

    protected EMF2DOMAdapter primCreateAdapter(Node node, Translator childMap) {
        return new EMF2DOMAdapterImpl(node, this.fRenderer, childMap);
    }

    protected EMF2DOMAdapter createAdapter(Node node, Translator childMap) {
        Assert.isNotNull(node);
        EMF2DOMAdapter adapter = this.primGetExistingAdapter(node);
        if (adapter != null) {
            if (adapter.isMOFProxy() || adapter.getTarget() == null) {
                this.removeDOMAdapter(node, adapter);
                if (adapter.getTarget() != null) {
                    adapter.getTarget().eAdapters().remove((Object)adapter);
                }
                adapter = null;
            }
        } else {
            adapter = this.primCreateAdapter(node, childMap);
        }
        return adapter;
    }

    protected Element createNewNode(EObject mofObject, Translator childMap) {
        Node node = this.getNode();
        Document doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = doc.createElement(childMap.getDOMName(mofObject));
        if (childMap.isEmptyTag()) {
            this.setEmptyTag(element);
        }
        return element;
    }

    protected void setEmptyTag(Element element) {
        Revisit.toDo();
    }

    public boolean isMOFProxy() {
        if (this.isRoot || this.target == null) {
            return false;
        }
        return ((InternalEObject)this.target).eIsProxy();
    }

    public EObject getEObject() {
        if (this.isRoot) {
            return null;
        }
        return (EObject)this.target;
    }

    public Node getNode() {
        return this.fNode;
    }

    public void setNode(Node aNode) {
        this.fNode = aNode;
    }

    public void updateDOM() {
        if (!this.isNotificationEnabled()) {
            return;
        }
        this.primUpdateDOM();
    }

    public void updateMOF() {
        if (!this.isNotificationEnabled()) {
            return;
        }
        this.primUpdateMOF();
    }

    protected void primUpdateDOM() {
        if (this.isRoot) {
            this.updateDOMRootFeature();
        } else {
            Translator[] maps = this.getChildTranslators();
            int i = 0;
            while (i < maps.length) {
                this.updateDOMFeature(maps[i], this.getNode(), this.getEObject());
                ++i;
            }
        }
    }

    public void primUpdateMOF() {
        if (this.isRoot) {
            this.updateMOFRootFeature();
        } else {
            Translator[] maps = this.getChildTranslators();
            int i = 0;
            while (i < maps.length) {
                this.updateMOFFeature(maps[i], this.getNode(), this.getEObject());
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateDOMRootFeature() {
        boolean notificationFlag = this.isNotificationEnabled();
        try {
            this.setNotificationEnabled(false);
            this.primUpdateDOMMultiFeature(this.fTranslator, this.fNode, (List)this.getResourceContents(), this.getDOMChildren(this.fNode, this.fTranslator), null);
            this.updateDOMDocumentType();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.setNotificationEnabled(notificationFlag);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateMOFRootFeature() {
        boolean notificationFlag = this.isNotificationEnabled();
        try {
            this.setNotificationEnabled(false);
            this.updateMOFDocumentType();
            this.primUpdateMOFMultiFeature(this.fTranslator, this.fNode, (List)this.getResourceContents(), this.getDOMChildren(this.fNode, this.fTranslator));
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.setNotificationEnabled(notificationFlag);
            return;
        }
    }

    protected DocumentType getDocumentType() {
        return ((Document)this.fNode).getDoctype();
    }

    protected TranslatorResource getResource() {
        return (TranslatorResource)this.getTarget();
    }

    protected EList getResourceContents() {
        if (!this.isRoot) {
            throw new IllegalStateException();
        }
        return ((Resource)this.getTarget()).getContents();
    }

    protected void updateDOMDocumentType() {
        DocumentType docType = this.getDocumentType();
        String publicId = null;
        String systemId = null;
        String oldPublicId = docType == null ? null : docType.getPublicId();
        String oldSystemId = docType == null ? null : docType.getSystemId();
        TranslatorResource resource = this.getResource();
        if (resource != null) {
            publicId = resource.getPublicId();
            systemId = resource.getSystemId();
        }
        if (!StringUtil.stringsEqual(publicId, oldPublicId) || !StringUtil.stringsEqual(systemId, oldSystemId)) {
            this.fRenderer.replaceDocumentType(resource.getDoctype(), publicId, systemId);
        }
    }

    protected void updateDOMDocumentType(Notification msg) {
        if (msg.getFeature() == TranslatorResource.DOC_TYPE_FEATURE) {
            this.updateDOMDocumentType();
        }
    }

    protected void updateMOFDocumentType() {
        TranslatorResource resource = this.getResource();
        if (resource == null) {
            return;
        }
        String publicId = null;
        String systemId = null;
        DocumentType docType = this.getDocumentType();
        if (docType != null) {
            publicId = docType.getPublicId();
            systemId = docType.getSystemId();
        }
        if (!StringUtil.stringsEqual(publicId, resource.getPublicId()) || !StringUtil.stringsEqual(systemId, resource.getSystemId()) || resource.getPublicId() == null || resource.getSystemId() == null) {
            resource.setDoctypeValues(publicId, systemId);
        }
    }

    public void notifyChanged(Notification msg) {
        if (this.isRoot) {
            this.notifyChangedForRoot(msg);
            return;
        }
        if (this.isDependencyFeature(msg)) {
            this.handleDependencyFeature(msg);
        }
        if (!this.isNotificationEnabled()) {
            return;
        }
        this.debugMOFNotify(msg);
        switch (msg.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Translator translator = this.findTranslator(msg);
                if (translator == null) {
                    translator = this.addVariableTranslatorIfNecessary(msg);
                }
                if (translator == null) break;
                this.updateDOMFeature(translator, this.getNode(), this.getEObject());
            }
        }
    }

    protected void notifyChangedForRoot(Notification msg) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        this.debugMOFNotify(msg);
        switch (msg.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.primUpdateDOM();
                break;
            }
            case 1: {
                this.updateDOMDocumentType(msg);
                break;
            }
            case 500: {
                this.updateDOM();
            }
        }
    }

    protected void addDependencyAdapter(EObject child) {
        Adapter existing = EcoreUtil.getExistingAdapter((Notifier)child, (Object)"EMF2DOMDependencyAdapter");
        if (existing != null) {
            return;
        }
        DependencyAdapter forwarder = new DependencyAdapter();
        child.eAdapters().add((Object)forwarder);
        forwarder.setTarget((Notifier)child);
    }

    protected void addDOMAdapter() {
        this.primAddDOMAdapter(this.fNode, this);
        NodeList childNodes = this.fNode.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Translator map;
            Node childNode = childNodes.item(j);
            short nodeType = childNode.getNodeType();
            if (!DOMUtilities.isTextNode(childNode) && nodeType != 8 && (map = this.findTranslator(childNode.getNodeName(), false)) != null && map.isManagedByParent()) {
                this.addDOMAdapter(childNode);
            }
            ++j;
        }
    }

    protected Translator addVariableTranslatorIfNecessary(Notification msg) {
        VariableTranslatorFactory fact = this.fTranslator.getVariableTranslatorFactory();
        Translator trans = null;
        if (fact != null && fact.accepts(msg) && (trans = fact.create(msg)) != null) {
            this.childTranslators = (Translator[])Translator.concat((Object[])this.childTranslators, trans);
        }
        return trans;
    }

    protected Text createTextNode(Document doc, Translator map, String text) {
        String nonnulltext = text != null ? text : "";
        return map.isCDATAContent() ? doc.createCDATASection(nonnulltext) : doc.createTextNode(nonnulltext);
    }

    protected String extractReadAheadName() {
        if (!this.fTranslator.hasReadAheadNames()) {
            return null;
        }
        String readAheadName = null;
        ReadAheadHelper helper = this.fTranslator.getReadAheadHelper(this.fNode.getNodeName());
        if (helper == null) {
            return null;
        }
        Node child = null;
        String[] names = helper.getValues();
        if (helper.getChildDOMName() == null) {
            int i = 0;
            while (i < names.length) {
                child = DOMUtilities.getNodeChild(this.fNode, names[i]);
                if (child != null) {
                    readAheadName = names[i];
                    break;
                }
                ++i;
            }
        } else {
            child = DOMUtilities.getNodeChild(this.fNode, helper.getChildDOMName());
            if (child != null) {
                readAheadName = DOMUtilities.getChildText(child);
            }
        }
        if (readAheadName == null) {
            readAheadName = names[0];
        }
        return readAheadName;
    }

    protected Object extractValue(Node node, Translator map, EObject emfObject) {
        Text textNode = DOMUtilities.getChildTextNode(node);
        String trimmedValue = null;
        if (textNode != null) {
            trimmedValue = textNode.getNodeValue();
        }
        try {
            return map.convertStringToValue(trimmedValue, emfObject);
        }
        catch (FeatureValueConversionException ex) {
            Logger.getLogger().logError((Throwable)ex);
            this.handleFeatureValueConversionException(ex);
            return null;
        }
    }

    protected void handleFeatureValueConversionException(FeatureValueConversionException ex) {
        throw ex;
    }

    protected Node findDOMNode(Node parent, Translator map) {
        return this.findDOMNode(parent, map, false);
    }

    protected Node findDOMNode(Node parent, Translator map, boolean addAdapters) {
        Node curNode = this.findDOMPath(parent, map, addAdapters);
        if (map.isDOMTextValue() || map.isDOMAttribute() || curNode == null) {
            return curNode;
        }
        String[] domNames = map.getDOMNames();
        Node node = null;
        int i = 0;
        while (i < domNames.length) {
            String nodeName = domNames[i];
            List nodes = DOMUtilities.getNodeChildren(curNode, nodeName);
            if (nodes != null && !nodes.isEmpty()) {
                if (nodes.size() > 1) {
                    this.handleInvalidMultiNodes(nodeName);
                }
                if ((node = (Node)nodes.get(0)) != null) {
                    if (!addAdapters || map == null && !map.isManagedByParent()) break;
                    this.addDOMAdapter(curNode);
                    break;
                }
            }
            ++i;
        }
        return node;
    }

    protected void handleInvalidMultiNodes(String nodeName) {
        throw new IllegalStateException(WFTUtilsResourceHandler.getString(WFTUtilsResourceHandler.EMF2DOMAdapterImpl_ERROR_0, new Object[]{nodeName}));
    }

    protected Text findOrCreateTextNode(Node parent, Translator map, String text) {
        Text textNode = DOMUtilities.getChildTextNode(parent);
        if (textNode != null) {
            textNode.setData(text);
        } else if (!this.isEmptyTag((Element)parent)) {
            Text newNode = this.createTextNode(parent.getOwnerDocument(), map, text);
            DOMUtilities.insertBeforeNode(parent, newNode, null);
            return newNode;
        }
        return textNode;
    }

    protected Translator findTranslator(String tagName, boolean attributeMap) {
        Translator[] maps = this.getChildTranslators();
        int i = 0;
        while (i < maps.length) {
            Translator map = maps[i];
            if (map.isMapFor(tagName) && attributeMap == map.isDOMAttribute()) {
                return maps[i];
            }
            ++i;
        }
        return null;
    }

    protected EMF2DOMAdapter getExistingAdapter(Node aNode) {
        EMF2DOMAdapter adapter = this.primGetExistingAdapter(aNode);
        if (adapter != null && adapter.isMOFProxy()) {
            this.removeDOMAdapter(aNode, adapter);
            adapter.getTarget().eAdapters().remove((Object)adapter);
            adapter = null;
        }
        return adapter;
    }

    protected void handleDependencyFeature(Notification msg) {
        if (msg.getOldValue() != null) {
            this.removeDependencyAdapter((EObject)msg.getOldValue());
        }
        if (msg.getNewValue() != null) {
            this.addDependencyAdapter((EObject)msg.getNewValue());
        }
    }

    protected boolean isDependencyFeature(Notification msg) {
        switch (msg.getEventType()) {
            case 1: {
                return this.fTranslator.isDependencyParent() && this.fTranslator.getDependencyFeature() == msg.getFeature();
            }
        }
        return false;
    }

    protected boolean isEmptyTag(Element parent) {
        Revisit.toDo();
        return false;
    }

    protected void postUpdateDOMFeature(Translator map, Node node, EObject mofObject) {
    }

    protected void preUpdateDOMFeature(Translator map, Node node, EObject mofObject) {
    }

    protected void primUpdateDOMFeature(Translator map, Node node, EObject mofObject) {
        Object attrValue = null;
        boolean isSet = false;
        if (map.isIDMap()) {
            try {
                attrValue = map.getMOFValue(mofObject);
            }
            catch (IDTranslator.NoResourceException noResourceException) {
                return;
            }
            isSet = attrValue != null;
        } else {
            attrValue = map.getMOFValue(mofObject);
            isSet = map.isSetMOFValue(mofObject);
        }
        if (map.isDOMAttribute()) {
            Element e = (Element)this.createDOMPath(node, map);
            if (attrValue != null && isSet) {
                e.setAttribute(map.getDOMName(mofObject), map.convertValueToString(attrValue, mofObject));
            } else {
                e.removeAttribute(map.getDOMName(mofObject));
            }
        } else {
            this.updateDOMSubtree(map, node, mofObject, attrValue);
        }
    }

    protected void primUpdateDOMLinkFeature(Translator map, Node node, EObject mofObject) {
        LinkUpdaterTarget.INSTANCE.updateDOM(map, node, mofObject);
    }

    protected void primUpdateDOMMultiFeature(Translator map, Node node, EObject mofObject) {
        List mofChildren = map.getMOFChildren(mofObject);
        List domChildren = this.getDOMChildren(node, map);
        this.primUpdateDOMMultiFeature(map, node, mofChildren, domChildren, (Notifier)mofObject);
    }

    protected boolean primUpdateMOFFeature(Translator map, Node node, EObject mofObject) {
        if (!map.featureExists(mofObject)) {
            return false;
        }
        Object domValue = null;
        boolean updateMOFAttAdapter = false;
        boolean isUnset = false;
        EMF2DOMAdapter attrAdapter = null;
        Node child = this.findDOMNode(node, map, true);
        if (map.isDOMAttribute() && child != null) {
            Attr domAttr = (Attr)child.getAttributes().getNamedItem(map.getDOMName(mofObject));
            if (domAttr != null) {
                domValue = domAttr.getValue();
                domValue = map.convertStringToValue((String)domValue, mofObject);
            } else {
                isUnset = true;
            }
        } else if (child != null) {
            if (!map.isManagedByParent()) {
                attrAdapter = this.createAdapter(child, map);
                updateMOFAttAdapter = true;
                domValue = attrAdapter.getTarget();
            } else {
                this.addDOMAdapter(child);
                domValue = this.extractValue(child, map, mofObject);
            }
        } else {
            isUnset = true;
        }
        boolean hasChanged = true;
        try {
            if (map.isIDMap()) {
                map.setMOFValue(mofObject, domValue);
            } else {
                Object oldValue = null;
                oldValue = map.getMOFValue(mofObject);
                boolean isSet = map.isSetMOFValue(mofObject);
                if (oldValue == domValue) {
                    if (oldValue == null || isSet) {
                        hasChanged = false;
                    }
                } else if (domValue == null && !isSet) {
                    hasChanged = false;
                } else if (oldValue != null && oldValue.equals(domValue) && isSet) {
                    hasChanged = false;
                }
                if (oldValue == null && domValue == null && map.isSetMOFValue(mofObject) == isUnset) {
                    hasChanged = true;
                }
                if (hasChanged) {
                    if (!map.isDataType() && !map.isShared()) {
                        this.removeMOFValue((EObject)oldValue, map);
                    }
                    if (domValue == null) {
                        map.unSetMOFValue(mofObject);
                    } else {
                        map.setMOFValue(mofObject, domValue);
                    }
                    if (domValue == null && !map.isEnumFeature() || isUnset) {
                        map.unSetMOFValue(mofObject);
                    }
                    if (updateMOFAttAdapter) {
                        attrAdapter.updateMOF();
                    }
                }
            }
        }
        catch (FeatureValueConversionException ex) {
            this.handleFeatureValueConversionException(ex);
            map.unSetMOFValue(mofObject);
        }
        return hasChanged;
    }

    protected void primUpdateMOFLinkFeature(Translator map, Node node, EObject mofObject) {
        LinkUpdaterTarget.INSTANCE.updateMOF(map, node, mofObject);
    }

    protected void primUpdateMOFMultiFeature(Translator map, Node node, EObject mofObject) {
        if (map.isManagedByParent()) {
            this.updateMOFMultiPrimitiveFeature(map, node, mofObject);
            return;
        }
        List nodeChildren = this.getDOMChildren(node, map);
        List mofChildren = map.getMOFChildren(mofObject);
        this.primUpdateMOFMultiFeature(map, node, mofChildren, nodeChildren);
    }

    protected void removeDependencyAdapter(EObject obj) {
        Adapter existing = EcoreUtil.getExistingAdapter((Notifier)obj, (Object)"EMF2DOMDependencyAdapter");
        if (existing != null) {
            obj.eAdapters().remove((Object)existing);
        }
    }

    protected void removeDOMChildren(Node parent, Translator map) {
        Node childNode;
        String[] domNames = map.getDOMNames();
        HashSet<String> domNamesSet = new HashSet<String>(domNames.length);
        int i = 0;
        while (i < domNames.length) {
            domNamesSet.add(domNames[i]);
            ++i;
        }
        NodeList nl = parent.getChildNodes();
        ArrayList<Node> toRemove = new ArrayList<Node>();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            childNode = nl.item(i2);
            if (domNamesSet.contains(childNode.getNodeName())) {
                toRemove.add(childNode);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < toRemove.size()) {
            childNode = (Node)toRemove.get(i2);
            this.removeDOMChild(parent, childNode, true);
            ++i2;
        }
    }

    protected void setTargetFromNode() {
        this.setTarget((Notifier)this.fTranslator.createEMFObject(this.fNode.getNodeName(), this.extractReadAheadName()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void updateDOMFeature(Translator map, Node node, EObject mofObject) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        try {
            this.preUpdateDOMFeature(map, node, mofObject);
            if (map.isMultiValued()) {
                this.updateDOMMultiFeature(map, node, mofObject);
                Object var7_4 = null;
                this.postUpdateDOMFeature(map, node, mofObject);
                return;
            }
            boolean notificationFlag = this.isNotificationEnabled();
            try {
                this.setNotificationEnabled(false);
                this.primUpdateDOMFeature(map, node, mofObject);
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.setNotificationEnabled(notificationFlag);
                throw throwable;
            }
            {
                Object var5_10 = null;
                this.setNotificationEnabled(notificationFlag);
                if (map.isTargetLinkMap()) {
                    this.updateDOMLinkFeature(map, node, mofObject);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.postUpdateDOMFeature(map, node, mofObject);
            throw throwable;
        }
        {
            Object var7_6 = null;
            this.postUpdateDOMFeature(map, node, mofObject);
            return;
        }
    }

    protected final void updateDOMLinkFeature(Translator map, Node node, EObject mofObject) {
        this.primUpdateDOMLinkFeature(map, node, mofObject);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void updateDOMMultiFeature(Translator map, Node node, EObject mofObject) {
        boolean notificationFlag = this.isNotificationEnabled();
        try {
            this.setNotificationEnabled(false);
            this.primUpdateDOMMultiFeature(map, node, mofObject);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.setNotificationEnabled(notificationFlag);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateDOMSubtree(Translator map, Node node, EObject mofObject, Object attrValue) {
        if (map.featureExists(mofObject)) {
            if ((map.isEnumFeature() || map.isBooleanFeature()) && map.isUnsettable() && !map.isSetMOFValue(mofObject)) {
                attrValue = null;
            }
        } else {
            attrValue = map.extractStringValue(mofObject);
        }
        if (attrValue == null) {
            Node child = this.findDOMNode(node, map);
            if (child == null) return;
            this.removeDOMChild(child.getParentNode(), child);
            return;
        }
        Node parent = this.createDOMPath(node, map);
        if (map.isManagedByParent()) {
            if (map.getDOMName(mofObject) != null && map.getDOMName(mofObject).startsWith("#")) {
                return;
            }
            Element child = map.isDOMTextValue() ? (Element)parent : this.findOrCreateNode(parent, map, map.getDOMName(mofObject));
            this.findOrCreateTextNode(child, map, map.convertValueToString(attrValue, mofObject));
            return;
        }
        EObject mofValue = (EObject)attrValue;
        EMF2DOMAdapter valueAdapter = (EMF2DOMAdapter)EcoreUtil.getExistingAdapter((Notifier)mofValue, (Object)EMF2DOMAdapter.ADAPTER_CLASS);
        if (valueAdapter != null) {
            valueAdapter.updateDOM();
            return;
        }
        this.removeDOMChildren(parent, map);
        EMF2DOMAdapter adapter = this.createAdapter(mofValue, map);
        List mofChildren = map.getMOFChildren(mofObject);
        List domChildren = this.getDOMChildren(parent, map);
        Node insertBeforeNode = this.findInsertBeforeNode(parent, map, mofChildren, 0, domChildren);
        DOMUtilities.insertBeforeNodeAndWhitespace(parent, adapter.getNode(), insertBeforeNode);
        boolean notificationFlag = adapter.isNotificationEnabled();
        adapter.setNotificationEnabled(false);
        try {
            this.indent(adapter.getNode(), map);
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            adapter.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
        {
            Object var13_17 = null;
            adapter.setNotificationEnabled(notificationFlag);
            adapter.updateDOM();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void updateMOFLinkFeature(Translator map, Node node, EObject mofObject) {
        boolean notificationFlag = this.isNotificationEnabled();
        try {
            this.setNotificationEnabled(false);
            this.primUpdateMOFLinkFeature(map, node, mofObject);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.setNotificationEnabled(notificationFlag);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void updateMOFMultiFeature(Translator map, Node node, EObject mofObject) {
        boolean notificationFlag = this.isNotificationEnabled();
        try {
            this.setNotificationEnabled(false);
            this.primUpdateMOFMultiFeature(map, node, mofObject);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.setNotificationEnabled(notificationFlag);
            return;
        }
    }

    protected void updateMOFMultiPrimitiveFeature(Translator map, Node node, EObject mofObject) {
        List nodeChildren = this.getDOMChildren(node, map);
        map.clearList(mofObject);
        int addIndex = 0;
        int i = 0;
        while (i < nodeChildren.size()) {
            Node child = (Node)nodeChildren.get(i);
            Object attributeValue = this.extractValue(child, map, mofObject);
            boolean advanceAddIndex = true;
            if (attributeValue != null) {
                if (map.getFeature() != null && map.getFeature().isUnique() && mofObject.eGet(map.getFeature()) != null && mofObject.eGet(map.getFeature()) instanceof List && ((List)mofObject.eGet(map.getFeature())).contains(attributeValue)) {
                    advanceAddIndex = false;
                    String domName = map.domNameAndPath != null ? map.domNameAndPath : "attribute";
                    Logger.getLogger().logError((Throwable)new IllegalArgumentException("The 'no duplicates' constraint is violated by " + domName + " = " + attributeValue));
                    this.handleInvalidMultiNodes(child.getNodeName());
                } else {
                    map.setMOFValue((Notifier)mofObject, attributeValue, addIndex);
                }
                if (advanceAddIndex) {
                    ++addIndex;
                }
            }
            this.addDOMAdapter(child);
            ++i;
        }
        if (map.hasDOMPath() && nodeChildren.isEmpty() && this.findDOMPath(node, map, false) != null) {
            map.setMOFValueFromEmptyDOMPath(mofObject);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMOFFeature(Translator map, Node node, EObject mofObject) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        if (map.isMultiValued()) {
            this.updateMOFMultiFeature(map, node, mofObject);
            return;
        }
        if (map.isComment()) {
            this.updateMOFCommentFeature(map, node, mofObject);
            return;
        }
        boolean notificationFlag = this.isNotificationEnabled();
        boolean hasChanged = false;
        try {
            this.setNotificationEnabled(false);
            hasChanged = this.primUpdateMOFFeature(map, node, mofObject);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.setNotificationEnabled(notificationFlag);
            if (map.isTargetLinkMap() && hasChanged) {
                this.updateMOFLinkFeature(map, node, mofObject);
            }
            return;
        }
    }

    public void updateMOFCommentFeature(Translator map, Node node, EObject mofObject) {
        Node commentNode = node;
        while ((commentNode = commentNode.getPreviousSibling()) != null && commentNode.getNodeType() != 8) {
            if (commentNode.getNodeType() != 1) continue;
            return;
        }
        if (commentNode != null) {
            map.setMOFValue(mofObject, (Object)commentNode.getNodeValue());
        }
    }

    private class DependencyAdapter
    extends AdapterImpl {
        static final String KEY = "EMF2DOMDependencyAdapter";

        private DependencyAdapter() {
        }

        public void notifyChanged(Notification msg) {
            EMF2DOMAdapterImpl.this.notifyChanged(msg);
        }

        public boolean isAdapterForType(Object type) {
            return KEY.equals(type);
        }
    }
}

