/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IBufferFactory;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.ASTHolderCUInfo;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.wst.jsdt.internal.core.IVirtualParent;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataReader;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataSourceElementNotifier;
import org.xml.sax.InputSource;

public class MetadataFile
extends Openable
implements IClassFile,
ICompilationUnit,
IVirtualParent {
    protected String name;
    protected IPath filePath;
    private static final IField[] NO_FIELDS = new IField[0];
    private static final IFunction[] NO_METHODS = new IFunction[0];
    private LibraryAPIs apis = null;

    protected MetadataFile(PackageFragment parent, String path) {
        super(parent);
        this.filePath = Path.fromOSString((String)path);
        if (this.filePath.getFileExtension() != null) {
            String lastSegment = this.filePath.lastSegment();
            this.name = lastSegment.substring(0, lastSegment.length() - (this.filePath.getFileExtension().length() + 1));
        } else {
            this.name = path;
        }
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaScriptModelException {
        boolean createAST;
        if (underlyingResource != null && !underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        CompilationUnitElementInfo unitInfo = new CompilationUnitElementInfo();
        CompilationUnitStructureRequestor requestor = new CompilationUnitStructureRequestor(this, unitInfo, newElements);
        if (info instanceof ASTHolderCUInfo) {
            ASTHolderCUInfo astHolder = (ASTHolderCUInfo)info;
            createAST = astHolder.astLevel != 0;
        } else {
            createAST = false;
        }
        new MetadataSourceElementNotifier(this.getAPIs(), requestor).notifyRequestor();
        if (underlyingResource == null) {
            underlyingResource = this.getResource();
        }
        if (underlyingResource != null) {
            unitInfo.timestamp = ((IFile)underlyingResource).getModificationStamp();
        }
        info.setChildren(unitInfo.children);
        if (createAST) {
            throw new RuntimeException("Implement this");
        }
        return true;
    }

    public LibraryAPIs getAPIs() {
        if (this.apis == null) {
            IFile file = (IFile)this.getResource();
            try {
                this.apis = MetadataReader.readAPIsFromStream(new InputSource(file.getContents()));
                this.apis.fileName = file.getFullPath().toPortableString();
            }
            catch (CoreException e) {
                Util.log(e, "error reading metadata");
                this.apis = new LibraryAPIs();
            }
        }
        return this.apis;
    }

    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                BinaryType type = new BinaryType(this, typeName);
                return type.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '&';
    }

    public IJavaScriptUnit becomeWorkingCopy(IProblemRequestor problemRequestor, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        return null;
    }

    public byte[] getBytes() throws JavaScriptModelException {
        IFile file = (IFile)this.getResource();
        return Util.getResourceContentsAsByteArray(file);
    }

    public IType getType() {
        return null;
    }

    public IType[] getTypes() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public IJavaScriptElement getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws JavaScriptModelException {
        return null;
    }

    public boolean isClass() throws JavaScriptModelException {
        return true;
    }

    public boolean isInterface() throws JavaScriptModelException {
        return false;
    }

    public IType findPrimaryType() {
        return null;
    }

    public IJavaScriptElement getElementAt(int position) throws JavaScriptModelException {
        return null;
    }

    public IJavaScriptUnit getWorkingCopy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        return null;
    }

    public int getElementType() {
        return 6;
    }

    public IPath getPath() {
        return this.filePath;
    }

    public IResource getResource() {
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    public String getSource() throws JavaScriptModelException {
        IBuffer buffer = super.getBuffer();
        if (buffer == null) {
            return null;
        }
        return buffer.getContents();
    }

    public ISourceRange getSourceRange() throws JavaScriptModelException {
        return null;
    }

    public void codeComplete(int offset, CompletionRequestor requestor) throws JavaScriptModelException {
    }

    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) throws JavaScriptModelException {
    }

    public IJavaScriptElement[] codeSelect(int offset, int length) throws JavaScriptModelException {
        return null;
    }

    public IJavaScriptElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws JavaScriptModelException {
        return null;
    }

    public IField getField(String fieldName) {
        return new SourceField(this, fieldName);
    }

    public IField[] getFields() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(8);
        int size = list.size();
        if (size == 0) {
            return NO_FIELDS;
        }
        IField[] array = new IField[size];
        list.toArray(array);
        return array;
    }

    public IFunction getFunction(String selector, String[] parameterTypeSignatures) {
        return new SourceMethod(this, selector, parameterTypeSignatures);
    }

    public IFunction[] getMethods() throws JavaScriptModelException {
        return this.getFunctions();
    }

    public IFunction[] getFunctions() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(9);
        int size = list.size();
        if (size == 0) {
            return NO_METHODS;
        }
        IFunction[] array = new IFunction[size];
        list.toArray(array);
        return array;
    }

    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    public char[] getContents() {
        char[] chars = null;
        try {
            chars = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(new File(this.filePath.toOSString()), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return chars;
    }

    public String getInferenceID() {
        return null;
    }

    public char[] getMainTypeName() {
        return null;
    }

    public char[][] getPackageName() {
        return new char[][]{this.getParent().getElementName().toCharArray()};
    }

    public char[] getFileName() {
        return this.filePath != null ? this.filePath.toString().toCharArray() : this.getElementName().toCharArray();
    }

    public JsGlobalScopeContainerInitializer getContainerInitializer() {
        JsGlobalScopeContainerInitializer init = ((IVirtualParent)((Object)this.parent)).getContainerInitializer();
        return init;
    }

    public String getElementName() {
        return "OpenAjaxAPI.xml";
    }
}

