/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.consumption.core.command;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jst.ws.axis2.consumption.core.data.DataModel;
import org.eclipse.jst.ws.axis2.consumption.core.messages.Axis2ConsumptionUIMessages;
import org.eclipse.jst.ws.axis2.consumption.core.utils.ContentCopyUtils;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.common.BundleUtils;

public class Axis2ClientTestCaseIntegrateCommand
extends AbstractDataModelOperation {
    private DataModel model;
    private IProject project;
    private boolean testClassPathExists;

    public Axis2ClientTestCaseIntegrateCommand(IProject project_, DataModel model_) {
        this.model = model_;
        this.project = project_;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        if (this.model.isTestCaseCheck()) {
            try {
                this.CopyJUnitJarToProject(workspaceDirectory, monitor);
                JavaProject javaProj = new JavaProject(this.project, null);
                IClasspathEntry[] classpathEntries = javaProj.getRawClasspath();
                IClasspathEntry newClasspathEntry = JavaCore.newSourceEntry((IPath)this.getPathToTestFolder(this.project, workspaceDirectory));
                int i = 0;
                while (i < classpathEntries.length) {
                    if (classpathEntries[i].equals(newClasspathEntry)) {
                        this.testClassPathExists = true;
                    }
                    ++i;
                }
                int classPathLength = classpathEntries.length;
                if (!this.testClassPathExists) {
                    ++classPathLength;
                }
                IClasspathEntry[] newClasspathEntryArray = new IClasspathEntry[classPathLength];
                int i2 = 0;
                while (i2 < classpathEntries.length) {
                    newClasspathEntryArray[i2] = classpathEntries[i2];
                    ++i2;
                }
                if (!this.testClassPathExists) {
                    newClasspathEntryArray[classPathLength - 1] = newClasspathEntry;
                }
                javaProj.setRawClasspath(newClasspathEntryArray, monitor);
            }
            catch (JavaModelException e) {
                throw new ExecutionException(e.getMessage());
            }
            catch (IOException e) {
                throw new ExecutionException(e.getMessage());
            }
        }
        return status;
    }

    private String CopyJUnitJarToProject(String workspace, IProgressMonitor monitor) throws ExecutionException, IOException {
        File relativeWebInfJunitFile = new File(FileUtils.addAnotherNodeToPath((String)J2EEUtils.getWebInfPath((IProject)this.project).toOSString(), (String)("lib" + File.separator + "junit.jar")));
        File obsaluteWebInfJunitFile = new File(FileUtils.addAnotherNodeToPath((String)workspace, (String)relativeWebInfJunitFile.toString()));
        IEnvironment environment = this.getEnvironment();
        IStatusHandler statusHandler = environment.getStatusHandler();
        ContentCopyUtils contentCopyUtils = new ContentCopyUtils();
        contentCopyUtils.copyDirectoryRecursivelyIntoWorkspace(this.getFrameworkJunitFile().getAbsolutePath(), obsaluteWebInfJunitFile.getAbsolutePath(), monitor, statusHandler);
        return obsaluteWebInfJunitFile.getAbsolutePath();
    }

    private File getFrameworkJunitFile() throws ExecutionException {
        IPath junitJarPath = BundleUtils.getJarredPluginPath((String)"org.junit");
        if (junitJarPath != null) {
            return new File(FileUtils.addAnotherNodeToPath((String)junitJarPath.toOSString(), (String)"junit.jar"));
        }
        throw new ExecutionException(Axis2ConsumptionUIMessages.ERROR_JUNIT_JAR_NOT_FOUND);
    }

    private IPath getPathToTestFolder(IProject project, String workspace) {
        String pathToTest = String.valueOf(project.getFullPath().toOSString()) + File.separator + "test";
        Path pathToTestFolder = new Path(pathToTest);
        return pathToTestFolder;
    }
}

