/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.MultiRelationshipMapping;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaRelationshipMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaMultiRelationshipMapping<T extends RelationshipMappingAnnotation>
extends AbstractJavaRelationshipMapping<T>
implements MultiRelationshipMapping {
    protected String mappedBy;
    protected String orderBy;
    protected boolean isNoOrdering;
    protected boolean isPkOrdering;
    protected boolean isCustomOrdering;
    protected final JavaJoinTable joinTable = this.getJpaFactory().buildJavaJoinTable(this);
    protected String mapKey;

    protected AbstractJavaMultiRelationshipMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        this.setMappedByOnResourceModel(newMappedBy);
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    protected void setMappedBy_(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    protected abstract void setMappedByOnResourceModel(String var1);

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public void setOrderBy(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        if (newOrderBy == null) {
            if (this.getOrderByResource() != null) {
                this.removeOrderByResource();
            }
        } else {
            if (this.getOrderByResource() == null) {
                this.addOrderByResource();
            }
            this.getOrderByResource().setValue(newOrderBy);
        }
        this.firePropertyChanged("orderByProperty", oldOrderBy, newOrderBy);
    }

    protected void setOrderBy_(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        this.firePropertyChanged("orderByProperty", oldOrderBy, newOrderBy);
    }

    protected OrderByAnnotation getOrderByResource() {
        return (OrderByAnnotation)this.getResourcePersistentAttribute().getAnnotation("javax.persistence.OrderBy");
    }

    protected OrderByAnnotation addOrderByResource() {
        return (OrderByAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.OrderBy");
    }

    protected void removeOrderByResource() {
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.OrderBy");
    }

    @Override
    public boolean isNoOrdering() {
        return this.isNoOrdering;
    }

    @Override
    public void setNoOrdering(boolean newNoOrdering) {
        boolean oldNoOrdering = this.isNoOrdering;
        this.isNoOrdering = newNoOrdering;
        if (newNoOrdering && this.getOrderByResource() != null) {
            this.removeOrderByResource();
        }
        this.firePropertyChanged("noOrderingProperty", oldNoOrdering, newNoOrdering);
    }

    protected void setNoOrdering_(boolean newNoOrdering) {
        boolean oldNoOrdering = this.isNoOrdering;
        this.isNoOrdering = newNoOrdering;
        this.firePropertyChanged("noOrderingProperty", oldNoOrdering, newNoOrdering);
    }

    @Override
    public boolean isPkOrdering() {
        return this.isPkOrdering;
    }

    @Override
    public void setPkOrdering(boolean newPkOrdering) {
        boolean oldPkOrdering = this.isPkOrdering;
        this.isPkOrdering = newPkOrdering;
        if (newPkOrdering) {
            if (this.getOrderByResource() == null) {
                this.addOrderByResource();
            } else {
                this.getOrderByResource().setValue(null);
            }
        }
        this.firePropertyChanged("pkOrderingProperty", oldPkOrdering, newPkOrdering);
    }

    protected void setPkOrdering_(boolean newPkOrdering) {
        boolean oldPkOrdering = this.isPkOrdering;
        this.isPkOrdering = newPkOrdering;
        this.firePropertyChanged("pkOrderingProperty", oldPkOrdering, newPkOrdering);
    }

    @Override
    public boolean isCustomOrdering() {
        return this.isCustomOrdering;
    }

    @Override
    public void setCustomOrdering(boolean newCustomOrdering) {
        boolean oldCustomOrdering = this.isCustomOrdering;
        this.isCustomOrdering = newCustomOrdering;
        if (newCustomOrdering) {
            this.setOrderBy("");
        }
        this.firePropertyChanged("customOrderingProperty", oldCustomOrdering, newCustomOrdering);
    }

    protected void setCustomOrdering_(boolean newCustomOrdering) {
        boolean oldCustomOrdering = this.isCustomOrdering;
        this.isCustomOrdering = newCustomOrdering;
        this.firePropertyChanged("customOrderingProperty", oldCustomOrdering, newCustomOrdering);
    }

    @Override
    public FetchType getDefaultFetch() {
        return MultiRelationshipMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public JavaJoinTable getJoinTable() {
        return this.joinTable;
    }

    @Override
    public boolean isJoinTableSpecified() {
        return this.getJoinTable().isSpecified();
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.getMappedBy() == null;
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public void setMapKey(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        if (oldMapKey != newMapKey) {
            if (this.getMapKeyResource(this.getResourcePersistentAttribute()) != null) {
                if (newMapKey != null) {
                    this.getMapKeyResource(this.getResourcePersistentAttribute()).setName(newMapKey);
                } else {
                    this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.MapKey");
                }
            } else if (newMapKey != null) {
                this.getResourcePersistentAttribute().addAnnotation("javax.persistence.MapKey");
                this.getMapKeyResource(this.getResourcePersistentAttribute()).setName(newMapKey);
            }
        }
        this.firePropertyChanged("mapKeyProperty", oldMapKey, newMapKey);
    }

    protected void setMapKey_(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        this.firePropertyChanged("mapKeyProperty", oldMapKey, newMapKey);
    }

    @Override
    protected String defaultTargetEntity(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        if (!resourcePersistentAttribute.typeIsContainer()) {
            return null;
        }
        return resourcePersistentAttribute.getQualifiedReferenceEntityElementTypeName();
    }

    protected abstract boolean mappedByTouches(int var1, CompilationUnit var2);

    protected boolean mapKeyNameTouches(int pos, CompilationUnit astRoot) {
        if (this.getMapKeyResource(this.getResourcePersistentAttribute()) != null) {
            return this.getMapKeyResource(this.getResourcePersistentAttribute()).nameTouches(pos, astRoot);
        }
        return false;
    }

    protected MapKeyAnnotation getMapKeyResource(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        return (MapKeyAnnotation)resourcePersistentAttribute.getAnnotation("javax.persistence.MapKey");
    }

    @Override
    public Iterator<String> candidateMapKeyNames() {
        return this.allTargetEntityAttributeNames();
    }

    protected Iterator<String> candidateMapKeyNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateMapKeyNames(), filter);
    }

    protected Iterator<String> quotedCandidateMapKeyNames(Filter<String> filter) {
        return StringTools.quote(this.candidateMapKeyNames(filter));
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getJoinTable().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.mappedByTouches(pos, astRoot)) {
            return this.quotedCandidateMappedByAttributeNames(filter);
        }
        if (this.mapKeyNameTouches(pos, astRoot)) {
            return this.quotedCandidateMapKeyNames(filter);
        }
        return null;
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.initializeFromResource(resourcePersistentAttribute);
        MapKeyAnnotation mapKey = this.getMapKeyResource(resourcePersistentAttribute);
        if (mapKey != null) {
            this.mapKey = mapKey.getName();
        }
        this.initializeOrderBy(this.getOrderByResource());
        this.joinTable.initializeFromResource(resourcePersistentAttribute);
    }

    @Override
    protected void initialize(T relationshipMapping) {
        super.initialize(relationshipMapping);
        this.mappedBy = this.mappedBy(relationshipMapping);
    }

    protected void initializeOrderBy(OrderByAnnotation orderBy) {
        if (orderBy != null) {
            this.orderBy = orderBy.getValue();
            if (orderBy.getValue() == null) {
                this.isPkOrdering = true;
            } else {
                this.isCustomOrdering = true;
            }
        } else {
            this.isNoOrdering = true;
        }
    }

    @Override
    public void update(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.update(resourcePersistentAttribute);
        this.updateMapKey(resourcePersistentAttribute);
        this.updateOrderBy(this.getOrderByResource());
        this.joinTable.update(resourcePersistentAttribute);
    }

    @Override
    protected void update(T relationshipMapping) {
        super.update(relationshipMapping);
        this.setMappedBy_(this.mappedBy(relationshipMapping));
    }

    protected void updateMapKey(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        MapKeyAnnotation mapKey = this.getMapKeyResource(resourcePersistentAttribute);
        if (mapKey != null) {
            this.setMapKey_(mapKey.getName());
        } else {
            this.setMapKey_(null);
        }
    }

    protected void updateOrderBy(OrderByAnnotation orderBy) {
        if (orderBy != null) {
            this.setOrderBy_(orderBy.getValue());
            if (orderBy.getValue() == null) {
                this.setPkOrdering_(true);
                this.setCustomOrdering_(false);
                this.setNoOrdering_(false);
            } else {
                this.setPkOrdering_(false);
                this.setCustomOrdering_(true);
                this.setNoOrdering_(false);
            }
        } else {
            this.setOrderBy_(null);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setNoOrdering_(true);
        }
    }

    protected abstract String mappedBy(T var1);

    public abstract TextRange getMappedByTextRange(CompilationUnit var1);

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        if (this.entityOwned() && (this.isJoinTableSpecified() || this.isRelationshipOwner())) {
            this.getJoinTable().addToMessages(messages, astRoot);
        }
        if (this.getMappedBy() != null) {
            this.addMappedByMessages(messages, astRoot);
        }
    }

    protected void addMappedByMessages(List<IMessage> messages, CompilationUnit astRoot) {
        NonOwningMapping mappedByMapping;
        Entity targetEntity;
        String mappedBy = this.getMappedBy();
        if (this.isJoinTableSpecified()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_WITH_JOIN_TABLE", this.getJoinTable(), this.getJoinTable().getValidationTextRange(astRoot)));
        }
        if ((targetEntity = this.getResolvedTargetEntity()) == null) {
            return;
        }
        PersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(mappedBy);
        if (attribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{mappedBy}, this, this.getMappedByTextRange(astRoot)));
            return;
        }
        if (!this.mappedByIsValid(attribute.getMapping())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{mappedBy}, this, this.getMappedByTextRange(astRoot)));
            return;
        }
        try {
            mappedByMapping = (NonOwningMapping)attribute.getMapping();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (mappedByMapping.getMappedBy() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", this, this.getMappedByTextRange(astRoot)));
        }
    }
}

