/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.ddlgen;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.internal.validation.JpaHelper;
import org.eclipse.jpt.core.internal.validation.JpaValidator;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.ValidatorJob;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class EclipseLinkDDLGenerator {
    public static String ECLIPSELINK_DDL_GEN_JAR_VERSION = "1.0.0";
    public static String LAUNCH_CONFIG_NAME = "EclipseLink";
    public static String DDL_GEN_PACKAGE_NAME = "org.eclipse.jpt.eclipselink.core.ddlgen";
    public static String ECLIPSELINK_DDL_GEN_CLASS = String.valueOf(DDL_GEN_PACKAGE_NAME) + ".Main";
    public static String ECLIPSELINK_DDL_GEN_JAR = String.valueOf(DDL_GEN_PACKAGE_NAME) + "_" + ECLIPSELINK_DDL_GEN_JAR_VERSION + ".jar";
    public static String PROPERTIES_FILE_NAME = "login.properties";
    public static String ECLIPSE_HOME = "ECLIPSE_HOME";
    public static String PLUGINS_DIR = "plugins";
    private IVMInstall jre;
    private ILaunchConfigurationWorkingCopy launchConfig;
    private ILaunch launch;
    private String puName;
    private JpaProject project;
    private String projectLocation;
    private boolean isDebug = false;

    public static void generate(String puName, JpaProject project, String projectLocation, IProgressMonitor monitor) {
        if (puName == null || puName.length() == 0 || project == null) {
            throw new NullPointerException();
        }
        new EclipseLinkDDLGenerator(puName, project, projectLocation, monitor).generate();
    }

    private EclipseLinkDDLGenerator(String puName, JpaProject project, String projectLocation, IProgressMonitor monitor) {
        this.puName = puName;
        this.project = project;
        this.projectLocation = projectLocation;
        this.initialize();
    }

    protected JpaPlatform getPlatform() {
        return this.project.getJpaPlatform();
    }

    protected ConnectionProfile getConnectionProfile() {
        return this.project.getConnectionProfile();
    }

    protected ILaunch getLaunch() {
        return this.launch;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private IVMInstall getProjectJRE() throws CoreException {
        return JavaRuntime.getVMInstall((IJavaProject)this.project.getJavaProject());
    }

    protected void initialize() {
        try {
            this.jre = this.getProjectJRE();
            if (this.jre == null) {
                String message = "Could not identify the VM.";
                throw new RuntimeException(message);
            }
            this.launchConfig = this.buildLaunchConfiguration();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void generate() {
        this.preGenerate();
        String propertiesFile = String.valueOf(this.projectLocation) + "/" + PROPERTIES_FILE_NAME;
        try {
            this.initializeLaunchConfiguration(this.projectLocation, propertiesFile);
            this.saveLoginProperties(this.projectLocation, propertiesFile);
            this.launch = this.saveAndLaunchConfig();
            this.addLaunchListener();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeLaunchConfiguration(String projectLocation, String propertiesFile) throws CoreException {
        this.specifyJRE(this.jre.getName(), this.jre.getVMInstallType().getId());
        this.specifyProject(this.project.getProject().getName());
        this.specifyMainType(ECLIPSELINK_DDL_GEN_CLASS);
        this.specifyProgramArguments(this.puName, propertiesFile);
        this.specifyWorkingDir(projectLocation);
        this.specifyClasspathProperties(this.project, this.buildJdbcJarPath(), this.buildBootstrapJarPath());
    }

    private void addLaunchListener() {
        this.getLaunchManager().addLaunchListener((ILaunchesListener)this.buildLaunchListener());
    }

    protected void preGenerate() {
        this.project.getConnectionProfile().disconnect();
    }

    protected void postGenerate() {
        try {
            if (!this.isDebug) {
                this.removeLaunchConfiguration(LAUNCH_CONFIG_NAME);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        this.project.getConnectionProfile().connect();
        this.validateProject();
    }

    protected void validateProject() {
        JpaValidator validator = new JpaValidator();
        IProject project = this.project.getProject();
        JpaHelper helper = new JpaHelper();
        helper.setProject(project);
        ValidatorJob validatorJob = new ValidatorJob((IValidatorJob)validator, "JPA Validator", "", project, (IWorkbenchContext)helper);
        validatorJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        validatorJob.setUser(true);
        validatorJob.schedule();
    }

    private IPath buildJdbcJarPath() {
        return new Path(this.project.getConnectionProfile().getDriverJarList());
    }

    private IPath buildBootstrapJarPath() {
        IPath path = JavaCore.getClasspathVariable((String)ECLIPSE_HOME);
        return path.append(PLUGINS_DIR).append(ECLIPSELINK_DDL_GEN_JAR);
    }

    private ILaunchesListener2 buildLaunchListener() {
        return new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                int i = 0;
                while (i < launches.length) {
                    ILaunch launch = launches[i];
                    if (launch.equals(EclipseLinkDDLGenerator.this.getLaunch())) {
                        EclipseLinkDDLGenerator.this.postGenerate();
                        return;
                    }
                    ++i;
                }
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesRemoved(ILaunch[] launches) {
            }
        };
    }

    private void specifyJRE(String jreName, String vmId) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, jreName);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmId);
    }

    private void specifyProject(String projectName) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
    }

    private void specifyMainType(String mainType) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
    }

    private void specifyProgramArguments(String puName, String propertiesPath) {
        StringBuffer programArguments = new StringBuffer();
        programArguments.append(this.buildPuNameArgument(puName));
        programArguments.append(this.buildPropertiesPathArgument(propertiesPath));
        programArguments.append(this.buildDebugArgument());
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
    }

    private void specifyClasspathProperties(JpaProject project, IPath jdbcJar, IPath bootstrapJar) throws CoreException {
        IRuntimeClasspathEntry bootstrapEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)bootstrapJar);
        bootstrapEntry.setClasspathProperty(3);
        IRuntimeClasspathEntry defaultEntry = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)project.getJavaProject());
        defaultEntry.setClasspathProperty(3);
        IRuntimeClasspathEntry jdbcEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)jdbcJar);
        jdbcEntry.setClasspathProperty(3);
        Path systemLibsPath = new Path(JavaRuntime.JRE_CONTAINER);
        IRuntimeClasspathEntry systemLibsEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)systemLibsPath, (int)1);
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(bootstrapEntry.getMemento());
        classpath.add(defaultEntry.getMemento());
        classpath.add(jdbcEntry.getMemento());
        classpath.add(systemLibsEntry.getMemento());
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    private void specifyWorkingDir(String projectLocation) {
        File workingDir = new Path(projectLocation).toFile();
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, workingDir.getAbsolutePath());
    }

    private ILaunch saveAndLaunchConfig() throws CoreException {
        ILaunchConfiguration configuration = this.launchConfig.doSave();
        return configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
    }

    private ILaunchConfigurationWorkingCopy buildLaunchConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy launchConfig = null;
        this.removeLaunchConfiguration(LAUNCH_CONFIG_NAME);
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        launchConfig = type.newInstance(null, LAUNCH_CONFIG_NAME);
        return launchConfig;
    }

    private void removeLaunchConfiguration(String launchConfigurationName) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration configuration = configurations[i];
            if (configuration.getName().equals(launchConfigurationName)) {
                configuration.delete();
                break;
            }
            ++i;
        }
    }

    private void buildProjectLocationProperty(Properties properties, String location) {
        this.putProperty(properties, "eclipselink.application-location", location);
    }

    private void buildDDLModeProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.ddl-generation", "drop-and-create-tables");
        this.putProperty(properties, "eclipselink.ddl-generation.output-mode", "database");
    }

    private void buildLoginProperties(Properties properties) {
        ConnectionProfile profile = this.getConnectionProfile();
        this.putProperty(properties, "eclipselink.jdbc.bind-parameters", "false");
        this.putProperty(properties, "eclipselink.jdbc.driver", profile.getDriverClassName());
        this.putProperty(properties, "eclipselink.jdbc.url", profile.getUrl());
        this.putProperty(properties, "eclipselink.jdbc.user", profile.getUserName());
        this.putProperty(properties, "eclipselink.jdbc.password", profile.getUserPassword());
        this.putProperty(properties, "eclipselink.logging.level", "FINEST");
        this.putProperty(properties, "eclipselink.logging.timestamp", "false");
        this.putProperty(properties, "eclipselink.logging.thread", "false");
        this.putProperty(properties, "eclipselink.logging.session", "false");
        this.putProperty(properties, "eclipselink.logging.exceptions", "true");
        this.putProperty(properties, "eclipselink.orm.throw.exceptions", "true");
    }

    private void putProperty(Properties properties, String key, String value) {
        properties.put(key, value == null ? "" : value);
    }

    private void saveLoginProperties(String projectLocation, String propertiesFile) {
        Properties elProperties = new Properties();
        this.buildLoginProperties(elProperties);
        this.buildDDLModeProperties(elProperties);
        this.buildProjectLocationProperty(elProperties, projectLocation);
        try {
            File file = new File(propertiesFile);
            file.createNewFile();
            FileOutputStream stream = new FileOutputStream(file);
            elProperties.store(stream, null);
            stream.close();
        }
        catch (Exception e) {
            String message = "Error saving: " + propertiesFile;
            throw new RuntimeException(message, e);
        }
    }

    private String buildPuNameArgument(String puName) {
        return " -pu \"" + puName + "\"";
    }

    private String buildPropertiesPathArgument(String propertiesFile) {
        return " -p \"" + propertiesFile + "\"";
    }

    private String buildDebugArgument() {
        return this.isDebug ? " -debug" : "";
    }
}

