/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.customization;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.context.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.Customization;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.CustomizerProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.Weaving;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkCustomization
extends EclipseLinkPersistenceUnitProperties
implements Customization {
    private Boolean throwExceptions;
    private Weaving weaving;
    private Boolean weavingLazy;
    private Boolean weavingChangeTracking;
    private Boolean weavingFetchGroups;
    private String sessionCustomizer;
    private Map<String, CustomizerProperties> entitiesCustomizerProperties;
    private static final long serialVersionUID = 1L;

    public EclipseLinkCustomization(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        super(parent, propertyListAdapter);
    }

    @Override
    protected void initializeProperties() {
        this.entitiesCustomizerProperties = new HashMap<String, CustomizerProperties>();
        this.throwExceptions = this.getBooleanValue("eclipselink.orm.throw.exceptions");
        this.weaving = (Weaving)this.getEnumValue("eclipselink.weaving", Weaving.values());
        this.weavingLazy = this.getBooleanValue("eclipselink.weaving.lazy");
        this.weavingChangeTracking = this.getBooleanValue("eclipselink.weaving.changetracking");
        this.weavingFetchGroups = this.getBooleanValue("eclipselink.weaving.fetchgroups");
        this.sessionCustomizer = this.getStringValue("eclipselink.session.customizer");
        Set<Property> properties = this.getPropertiesSetWithPrefix("eclipselink.descriptor.customizer.");
        this.initializeEntitiesCustomizerClass(properties);
    }

    private void initializeEntitiesCustomizerClass(Set<Property> properties) {
        for (Property property : properties) {
            String entityName = this.getEntityName(property);
            this.setCustomizerClass_(property, entityName);
        }
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.orm.throw.exceptions", "throwExceptionsProperty");
        propertyNames.put("eclipselink.weaving", "weavingProperty");
        propertyNames.put("eclipselink.weaving.lazy", "weavingLazyProperty");
        propertyNames.put("eclipselink.weaving.changetracking", "weavingChangeTrackingProperty");
        propertyNames.put("eclipselink.weaving.fetchgroups", "weavingFetchGroupsProperty");
        propertyNames.put("eclipselink.session.customizer", "sessionCustomizerProperty");
    }

    @Override
    public boolean itemIsProperty(Property item) {
        boolean isProperty = super.itemIsProperty(item);
        if (!isProperty && item.getName() != null && item.getName().startsWith("eclipselink.descriptor.customizer.")) {
            return true;
        }
        return isProperty;
    }

    @Override
    public String propertyIdFor(Property property) {
        try {
            return super.propertyIdFor(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (property.getName().startsWith("eclipselink.descriptor.customizer.")) {
                return "descriptorCustomizerProperty";
            }
            throw new IllegalArgumentException("Illegal property: " + property.toString());
        }
    }

    public void propertyChanged(PropertyChangeEvent event) {
        String aspectName = event.getAspectName();
        if (aspectName.equals("throwExceptionsProperty")) {
            this.throwExceptionsChanged(event);
        } else if (aspectName.equals("weavingProperty")) {
            this.weavingChanged(event);
        } else if (aspectName.equals("weavingLazyProperty")) {
            this.weavingLazyChanged(event);
        } else if (aspectName.equals("weavingChangeTrackingProperty")) {
            this.weavingChangeTrackingChanged(event);
        } else if (aspectName.equals("weavingFetchGroupsProperty")) {
            this.weavingFetchGroupsChanged(event);
        } else if (aspectName.equals("sessionCustomizerProperty")) {
            this.sessionCustomizerChanged(event);
        } else if (aspectName.equals("descriptorCustomizerProperty")) {
            this.descriptorCustomizerChanged(event);
        } else {
            throw new IllegalArgumentException("Illegal event received - property not applicable: " + aspectName);
        }
    }

    @Override
    public Boolean getThrowExceptions() {
        return this.throwExceptions;
    }

    @Override
    public void setThrowExceptions(Boolean newThrowExceptions) {
        Boolean old = this.throwExceptions;
        this.throwExceptions = newThrowExceptions;
        this.putProperty("throwExceptionsProperty", newThrowExceptions);
        this.firePropertyChanged("throwExceptionsProperty", old, newThrowExceptions);
    }

    private void throwExceptionsChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf(stringValue);
        Boolean old = this.throwExceptions;
        this.throwExceptions = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultThrowExceptions() {
        return DEFAULT_THROW_EXCEPTIONS;
    }

    @Override
    public Boolean getWeavingLazy() {
        return this.weavingLazy;
    }

    @Override
    public void setWeavingLazy(Boolean newWeavingLazy) {
        Boolean old = this.weavingLazy;
        this.weavingLazy = newWeavingLazy;
        this.putProperty("weavingLazyProperty", newWeavingLazy);
        this.firePropertyChanged("weavingLazyProperty", old, newWeavingLazy);
    }

    private void weavingLazyChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf(stringValue);
        Boolean old = this.weavingLazy;
        this.weavingLazy = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingLazy() {
        return DEFAULT_WEAVING_LAZY;
    }

    @Override
    public Boolean getWeavingChangeTracking() {
        return this.weavingChangeTracking;
    }

    @Override
    public void setWeavingChangeTracking(Boolean newWeavingChangeTracking) {
        Boolean old = this.weavingChangeTracking;
        this.weavingChangeTracking = newWeavingChangeTracking;
        this.putProperty("weavingChangeTrackingProperty", newWeavingChangeTracking);
        this.firePropertyChanged("weavingChangeTrackingProperty", old, newWeavingChangeTracking);
    }

    private void weavingChangeTrackingChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf(stringValue);
        Boolean old = this.weavingChangeTracking;
        this.weavingChangeTracking = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingChangeTracking() {
        return DEFAULT_WEAVING_CHANGE_TRACKING;
    }

    @Override
    public Boolean getWeavingFetchGroups() {
        return this.weavingFetchGroups;
    }

    @Override
    public void setWeavingFetchGroups(Boolean newWeavingFetchGroups) {
        Boolean old = this.weavingFetchGroups;
        this.weavingFetchGroups = newWeavingFetchGroups;
        this.putProperty("weavingFetchGroupsProperty", newWeavingFetchGroups);
        this.firePropertyChanged("weavingFetchGroupsProperty", old, newWeavingFetchGroups);
    }

    private void weavingFetchGroupsChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf(stringValue);
        Boolean old = this.weavingFetchGroups;
        this.weavingFetchGroups = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingFetchGroups() {
        return DEFAULT_WEAVING_FETCH_GROUPS;
    }

    @Override
    public String getSessionCustomizer() {
        return this.sessionCustomizer;
    }

    @Override
    public void setSessionCustomizer(String newSessionCustomizer) {
        String old = this.sessionCustomizer;
        this.sessionCustomizer = newSessionCustomizer;
        this.putProperty("sessionCustomizerProperty", newSessionCustomizer);
        this.firePropertyChanged("sessionCustomizerProperty", old, newSessionCustomizer);
    }

    private void sessionCustomizerChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.sessionCustomizer;
        this.sessionCustomizer = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultSessionCustomizer() {
        return DEFAULT_SESSION_CUSTOMIZER;
    }

    @Override
    public Weaving getWeaving() {
        return this.weaving;
    }

    @Override
    public void setWeaving(Weaving newWeaving) {
        Weaving old = this.weaving;
        this.weaving = newWeaving;
        this.putProperty("weavingProperty", (Object)newWeaving);
        this.firePropertyChanged("weavingProperty", (Object)old, (Object)newWeaving);
    }

    private void weavingChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Weaving newValue = (Weaving)EclipseLinkCustomization.getEnumValueOf((String)stringValue, (Enum[])Weaving.values());
        Weaving old = this.weaving;
        this.weaving = newValue;
        this.firePropertyChanged(event.getAspectName(), (Object)old, (Object)newValue);
    }

    @Override
    public Weaving getDefaultWeaving() {
        return DEFAULT_WEAVING;
    }

    @Override
    public String getDescriptorCustomizer(String entityName) {
        CustomizerProperties customizer = this.customizerPropertiesOf(entityName);
        return customizer == null ? null : customizer.getClassName();
    }

    @Override
    public void setDescriptorCustomizer(String newDescriptorCustomizer, String entityName) {
        CustomizerProperties old = this.setCustomizerClass_(newDescriptorCustomizer, entityName);
        this.putStringValue("eclipselink.descriptor.customizer.", entityName, newDescriptorCustomizer, false);
        this.firePropertyChanged("descriptorCustomizerProperty", old, this.customizerPropertiesOf(entityName));
    }

    private void descriptorCustomizerChanged(PropertyChangeEvent event) {
        Property newProperty = (Property)event.getNewValue();
        String entityName = newProperty == null ? this.getEntityName((Property)event.getOldValue()) : this.getEntityName(newProperty);
        CustomizerProperties old = this.setCustomizerClass_(newProperty, entityName);
        this.firePropertyChanged(event.getAspectName(), old, this.customizerPropertiesOf(entityName));
    }

    @Override
    public String getDefaultDescriptorCustomizer() {
        return DEFAULT_DESCRIPTOR_CUSTOMIZER;
    }

    private CustomizerProperties setCustomizerClass_(Property newProperty, String entityName) {
        String newValue = newProperty == null ? null : newProperty.getValue();
        return this.setCustomizerClass_(newValue, entityName);
    }

    private CustomizerProperties setCustomizerClass_(String newValue, String entityName) {
        CustomizerProperties properties = this.customizerPropertiesOf(entityName);
        CustomizerProperties old = properties.clone();
        properties.setClassName(newValue);
        this.putEntityCustomizerProperties(entityName, properties);
        return old;
    }

    private CustomizerProperties customizerPropertiesOf(String entityName) {
        CustomizerProperties properties = this.entitiesCustomizerProperties.get(entityName);
        if (properties == null) {
            properties = new CustomizerProperties(entityName);
        }
        return properties;
    }

    private void clearCustomizerProperties(String entityName) {
        this.setDescriptorCustomizer(null, entityName);
    }

    private void putEntityCustomizerProperties(String entityName, CustomizerProperties properties) {
        this.addOrReplacePropertiesForEntity(entityName, properties);
    }

    @Override
    public ListIterator<String> entities() {
        return CollectionTools.list((Iterable)this.entitiesCustomizerProperties.keySet()).listIterator();
    }

    @Override
    public int entitiesSize() {
        return this.entitiesCustomizerProperties.size();
    }

    @Override
    public boolean entityExists(String entity) {
        return this.entitiesCustomizerProperties.containsKey(entity);
    }

    @Override
    public String addEntity(String entity) {
        if (this.entityExists(entity)) {
            throw new IllegalStateException("Entity " + entity + " already exist.");
        }
        return this.addOrReplacePropertiesForEntity(entity, new CustomizerProperties(entity));
    }

    private String addOrReplacePropertiesForEntity(String entity, CustomizerProperties properties) {
        if (this.entityExists(entity)) {
            this.replaceEntity_(entity, properties);
            return null;
        }
        this.entitiesCustomizerProperties.put(entity, properties);
        this.fireListChanged("entitiesListProperty");
        return entity;
    }

    private CustomizerProperties replaceEntity_(String entity, CustomizerProperties properties) {
        CustomizerProperties old = this.entitiesCustomizerProperties.get(entity);
        if (properties.isEmpty()) {
            this.entitiesCustomizerProperties.remove(entity);
            this.fireListChanged("entitiesListProperty");
        } else {
            this.entitiesCustomizerProperties.put(entity, properties);
        }
        return old;
    }

    @Override
    public void removeEntity(String entity) {
        if (!this.entityExists(entity)) {
            return;
        }
        this.clearCustomizerProperties(entity);
        this.entitiesCustomizerProperties.remove(entity);
        this.fireListChanged("entitiesListProperty");
    }
}

